/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.AddFileAnnotationFix;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/UseOptInFileAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddFileAnnotationFix;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "optInFqName", "Lorg/jetbrains/kotlin/name/FqName;", "argumentClassFqName", "existingAnnotationEntry", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/SmartPsiElementPointer;)V", "fileName", "", "Lorg/jetbrains/annotations/NotNull;", "getFamilyName", "getText", "kotlin.fir.frontend-independent"})
public final class UseOptInFileAnnotationFix
extends AddFileAnnotationFix {
    @NotNull
    private final FqName argumentClassFqName;
    @NotNull
    private final String fileName;

    public UseOptInFileAnnotationFix(@NotNull KtFile file2, @NotNull FqName optInFqName, @NotNull FqName argumentClassFqName, @Nullable SmartPsiElementPointer<KtAnnotationEntry> existingAnnotationEntry) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)optInFqName, (String)"optInFqName");
        Intrinsics.checkNotNullParameter((Object)argumentClassFqName, (String)"argumentClassFqName");
        super(file2, optInFqName, argumentClassFqName, existingAnnotationEntry);
        this.argumentClassFqName = argumentClassFqName;
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.fileName = string;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.argumentClassFqName.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String argumentText2 = string;
        Object[] objectArray = new Object[]{argumentText2, this.fileName};
        return KotlinBundle.message((String)"fix.opt_in.text.use.containing.file", (Object[])objectArray);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.opt_in.annotation.family", (Object[])new Object[0]);
    }
}

