/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\r*\u00020\u0012\u00a8\u0006\u0013"}, d2={"collectAffectedCallables", "", "declaration", "Lcom/intellij/psi/PsiElement;", "results", "", "getAffectedCallables", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptorsForChange", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getBodyScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getContainingScope", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nCallableRefactoring.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableRefactoring.kt\norg/jetbrains/kotlin/idea/refactoring/CallableRefactoringKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,231:1\n1#2:232\n1855#3,2:233\n1282#4,2:235\n*S KotlinDebug\n*F\n+ 1 CallableRefactoring.kt\norg/jetbrains/kotlin/idea/refactoring/CallableRefactoringKt\n*L\n204#1:233,2\n228#1:235,2\n*E\n"})
public final class CallableRefactoringKt {
    @NotNull
    public static final Collection<PsiElement> getAffectedCallables(@NotNull Project project2, @NotNull Collection<? extends CallableDescriptor> descriptorsForChange) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(descriptorsForChange, (String)"descriptorsForChange");
        HashSet results2 = new HashSet();
        for (CallableDescriptor callableDescriptor : descriptorsForChange) {
            PsiElement declaration2;
            if (DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, (DeclarationDescriptor)callableDescriptor) == null) continue;
            CallableRefactoringKt.collectAffectedCallables(declaration2, results2);
        }
        return results2;
    }

    private static final void collectAffectedCallables(PsiElement declaration2, Collection<PsiElement> results2) {
        if (!results2.add(declaration2)) {
            return;
        }
        if (declaration2 instanceof KtDeclaration) {
            for (KtDeclaration it : ExpectActualUtilKt.actualsForExpected$default((KtDeclaration)declaration2, null, 1, null)) {
                CallableRefactoringKt.collectAffectedCallables((PsiElement)it, results2);
            }
            KtDeclaration ktDeclaration = ExpectActualUtilKt.liftToExpected((KtDeclaration)declaration2);
            if (ktDeclaration != null) {
                KtDeclaration it = ktDeclaration;
                boolean bl = false;
                CallableRefactoringKt.collectAffectedCallables((PsiElement)it, results2);
            }
            if (!(declaration2 instanceof KtCallableDeclaration)) {
                return;
            }
            OverridersSearchKt.forEachOverridingElement$default((KtNamedDeclaration)declaration2, null, false, (Function2)new Function2<PsiElement, PsiElement, Boolean>(results2){
                final /* synthetic */ Collection<PsiElement> $results;
                {
                    this.$results = $results;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement psiElement2, @NotNull PsiElement overridingElement) {
                    Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)overridingElement, (String)"overridingElement");
                    Collection<PsiElement> collection = this.$results;
                    PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)overridingElement);
                    collection.add(psiNamedElement != null ? (PsiElement)psiNamedElement : overridingElement);
                    return true;
                }
            }, 3, null);
        } else {
            for (PsiMethod psiMethod2 : LightClassUtilsKt.toLightMethods((PsiElement)declaration2)) {
                Query query = OverridingMethodsSearch.search((PsiMethod)psiMethod2);
                Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
                Iterable $this$forEach$iv = (Iterable)query;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PsiMethod it = (PsiMethod)element$iv;
                    boolean bl = false;
                    Collection<PsiElement> collection = results2;
                    Intrinsics.checkNotNull((Object)it);
                    PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)((PsiElement)it));
                    if (psiNamedElement == null) {
                        psiNamedElement = (PsiNamedElement)it;
                    }
                    collection.add((PsiElement)psiNamedElement);
                }
            }
        }
    }

    @Nullable
    public static final LexicalScope getContainingScope(@NotNull DeclarationDescriptor $this$getContainingScope) {
        Object object;
        KtBlockExpression block2;
        PsiElement declaration2;
        Intrinsics.checkNotNullParameter((Object)$this$getContainingScope, (String)"<this>");
        PsiElement psiElement2 = declaration2 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)$this$getContainingScope);
        PsiElement psiElement3 = psiElement2 != null ? psiElement2.getParent() : null;
        KtBlockExpression ktBlockExpression = block2 = psiElement3 instanceof KtBlockExpression ? (KtBlockExpression)psiElement3 : null;
        if (block2 != null) {
            List list2 = block2.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
            KtExpression lastStatement = (KtExpression)CollectionsKt.last((List)list2);
            Intrinsics.checkNotNull((Object)lastStatement);
            BindingContext bindingContext2 = ResolutionUtils.analyze$default((KtElement)lastStatement, null, 1, null);
            object = ScopeUtils.getResolutionScope((PsiElement)lastStatement, bindingContext2, ResolutionUtils.getResolutionFacade((KtElement)lastStatement));
        } else {
            DeclarationDescriptor declarationDescriptor = $this$getContainingScope.getContainingDeclaration();
            if (declarationDescriptor == null) {
                return null;
            }
            DeclarationDescriptor containingDescriptor = declarationDescriptor;
            object = containingDescriptor instanceof ClassDescriptorWithResolutionScopes ? ((ClassDescriptorWithResolutionScopes)containingDescriptor).getScopeForInitializerResolution() : (containingDescriptor instanceof PackageFragmentDescriptor ? (LexicalScope)new LexicalScope.Base((HierarchicalScope)ScopeUtilsKt.memberScopeAsImportingScope$default((MemberScope)((PackageFragmentDescriptor)containingDescriptor).getMemberScope(), null, (int)1, null), $this$getContainingScope) : null);
        }
        return object;
    }

    @Nullable
    public static final LexicalScope getBodyScope(@NotNull KtDeclarationWithBody $this$getBodyScope, @NotNull BindingContext bindingContext2) {
        PsiElement[] psiElementArray;
        block5: {
            block4: {
                PsiElement[] psiElementArray2;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)$this$getBodyScope, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
                    psiElementArray = $this$getBodyScope.getBodyExpression();
                    if (psiElementArray == null || (psiElementArray = psiElementArray.getChildren()) == null) break block4;
                    PsiElement[] $this$firstOrNull$iv = psiElementArray;
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int j = 0; j < n; ++j) {
                        PsiElement[] element$iv;
                        PsiElement[] it = element$iv = $this$firstOrNull$iv[j];
                        boolean bl = false;
                        if (!(it instanceof KtExpression)) continue;
                        psiElementArray2 = element$iv;
                        break block3;
                    }
                    psiElementArray2 = psiElementArray = null;
                }
                if (psiElementArray2 != null) break block5;
            }
            return null;
        }
        PsiElement[] expression2 = psiElementArray;
        return ScopeUtils.getResolutionScope((PsiElement)expression2, bindingContext2, ResolutionUtils.getResolutionFacade((KtElement)$this$getBodyScope));
    }
}

