/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001am\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u00012\u0006\u0010\u0006\u001a\u0002H\u00012\u001f\b\u0002\u0010\u0007\u001a\u0019\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\b\u00a2\u0006\u0002\b\t2\u001d\u0010\n\u001a\u0019\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\r\u001a\u001c\u0010\u000e\u001a\u00020\u0002*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0012*\u00020\u0014\u001a<\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001a0\u00192\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c\u001a\u0016\u0010\u001e\u001a\u00020\u001f*\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001a\u001a\n\u0010!\u001a\u00020\u0016*\u00020\"\u001a\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\f*\u00020\u00142\b\b\u0002\u0010$\u001a\u00020\u0012\u001a\n\u0010%\u001a\u00020\u0014*\u00020\u0014\u001a\f\u0010&\u001a\u0004\u0018\u00010\u0002*\u00020\"\u001a.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\f*\u00020\u00142\b\b\u0002\u0010$\u001a\u00020\u00122\b\b\u0002\u0010(\u001a\u00020\u00122\b\b\u0002\u0010)\u001a\u00020\u0012\u001a\f\u0010*\u001a\u0004\u0018\u00010+*\u00020,\u001a\n\u0010-\u001a\u00020\u0012*\u00020.\u001a\n\u0010-\u001a\u00020\u0012*\u00020/\u001a\n\u00100\u001a\u00020\u0012*\u000201\u001a\n\u00102\u001a\u00020\u0012*\u00020,\u001aF\u00103\u001a\u00020\u0012*\u00020\u00022\u000e\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u000206052%\u00107\u001a!\u0012\u0004\u0012\u00020\u0014\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020605\u0012\u0004\u0012\u00020\u00120\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u00108\u001a\n\u00109\u001a\u00020\u0012*\u00020\u0014\u001a\n\u0010:\u001a\u00020\u0012*\u00020;\u001a\"\u0010<\u001a\u00020\u0016*\u00020,2\u0016\b\u0002\u0010=\u001a\u0010\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u000b\u001a\n\u0010?\u001a\u00020@*\u00020\u0014\u00a8\u0006A"}, d2={"replaceListPsiAndKeepDelimiters", "ListType", "Lorg/jetbrains/kotlin/psi/KtElement;", "changeInfo", "Lcom/intellij/refactoring/changeSignature/ChangeInfo;", "originalList", "newList", "listReplacer", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "itemsFun", "Lkotlin/Function1;", "", "(Lcom/intellij/refactoring/changeSignature/ChangeInfo;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/psi/KtElement;", "addElement", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "element", "addNewLine", "", "canRefactorElement", "Lcom/intellij/psi/PsiElement;", "checkConflictsInteractively", "", "Lcom/intellij/openapi/project/Project;", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "", "onShowConflicts", "Lkotlin/Function0;", "onAccept", "createTempCopy", "Lorg/jetbrains/kotlin/psi/KtFile;", "text", "deleteWithCompanion", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getAllExtractionContainers", "strict", "getContainer", "getDeclarationBody", "getExtractionContainers", "includeAll", "acceptScript", "getLastLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "hasIdentifiersOnly", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "isAbstract", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isComplexCallWithLambdaArgument", "isInsideOfCallerBody", "allUsages", "", "Lcom/intellij/usageView/UsageInfo;", "isCaller", "(Lorg/jetbrains/kotlin/psi/KtElement;[Lcom/intellij/usageView/UsageInfo;Lkotlin/jvm/functions/Function2;)Z", "isInterfaceClass", "isOpen", "Lorg/jetbrains/kotlin/psi/KtClass;", "moveFunctionLiteralOutsideParentheses", "moveCaretTo", "", "nameDeterminant", "Lcom/intellij/psi/PsiNamedElement;", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nkotlinCommonRefactoringUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kotlinCommonRefactoringUtil.kt\norg/jetbrains/kotlin/idea/refactoring/KotlinCommonRefactoringUtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,339:1\n12474#2,2:340\n5261#2,7:363\n11065#2:372\n11400#2,3:373\n1774#3,4:342\n1747#3,3:348\n1855#3,2:351\n1855#3,2:353\n1747#3,3:355\n1855#3,2:358\n1855#3,2:360\n1855#3,2:370\n1855#3,2:378\n800#3,11:382\n1726#3,3:394\n1726#3,3:397\n179#4,2:346\n1247#4,2:376\n179#4,2:380\n1#5:362\n73#6:393\n*S KotlinDebug\n*F\n+ 1 kotlinCommonRefactoringUtil.kt\norg/jetbrains/kotlin/idea/refactoring/KotlinCommonRefactoringUtilKt\n*L\n67#1:340,2\n154#1:363,7\n162#1:372\n162#1:373,3\n98#1:342,4\n125#1:348,3\n127#1:351,2\n128#1:353,2\n131#1:355,3\n132#1:358,2\n133#1:360,2\n154#1:370,2\n175#1:378,2\n289#1:382,11\n338#1:394,3\n339#1:397,3\n112#1:346,2\n163#1:376,2\n221#1:380,2\n323#1:393\n*E\n"})
public final class KotlinCommonRefactoringUtilKt {
    @NotNull
    public static final PsiNamedElement nameDeterminant(@NotNull PsiElement $this$nameDeterminant) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)$this$nameDeterminant, (String)"<this>");
        if ($this$nameDeterminant instanceof KtConstructor) {
            KtClass ktClass2 = KtPsiUtilKt.containingClass((KtElement)((KtElement)$this$nameDeterminant));
            if (ktClass2 == null) {
                throw new IllegalStateException("Constructor had no containing class".toString());
            }
            psiElement2 = (PsiElement)ktClass2;
        } else if ($this$nameDeterminant instanceof PsiMethod && ((PsiMethod)$this$nameDeterminant).isConstructor()) {
            PsiClass psiClass2 = ((PsiMethod)$this$nameDeterminant).getContainingClass();
            if (psiClass2 == null) {
                throw new IllegalStateException("Constructor had no containing class".toString());
            }
            psiElement2 = (PsiElement)psiClass2;
        } else {
            psiElement2 = $this$nameDeterminant;
        }
        return (PsiNamedElement)psiElement2;
    }

    @NotNull
    public static final PsiElement getContainer(@NotNull PsiElement $this$getContainer) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)$this$getContainer, (String)"<this>");
        if ($this$getContainer instanceof KtElement) {
            Class[] classArray = new Class[]{KtPropertyAccessor.class, KtProperty.class, KtNamedFunction.class, KtConstructor.class, KtClassOrObject.class};
            KtDeclarationStub ktDeclarationStub = (KtDeclarationStub)PsiTreeUtil.getParentOfType((PsiElement)$this$getContainer, (Class[])classArray);
            NavigatablePsiElement navigatablePsiElement2 = ktDeclarationStub != null ? (NavigatablePsiElement)ktDeclarationStub : (NavigatablePsiElement)((KtElement)$this$getContainer).getContainingFile();
            Intrinsics.checkNotNull((Object)navigatablePsiElement2);
            psiElement2 = (PsiElement)navigatablePsiElement2;
        } else {
            PsiElement psiElement3 = ConflictsUtil.getContainer((PsiElement)$this$getContainer);
            psiElement2 = psiElement3;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getContainer(...)");
        }
        return psiElement2;
    }

    @NotNull
    public static final KtFile createTempCopy(@NotNull KtFile $this$createTempCopy, @Nullable String text2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$createTempCopy, (String)"<this>");
        KtPsiFactory ktPsiFactory = KtPsiFactory.Companion.contextual$default((KtPsiFactory.Companion)KtPsiFactory.Companion, (PsiElement)((PsiElement)$this$createTempCopy), (boolean)false, (boolean)false, (int)6, null);
        String string2 = $this$createTempCopy.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = text2;
        if (string3 == null) {
            string3 = string = $this$createTempCopy.getText();
        }
        if (string3 == null) {
            string = "";
        }
        KtFile tmpFile = ktPsiFactory.createFile(string2, string);
        tmpFile.setOriginalFile((PsiFile)$this$createTempCopy);
        return tmpFile;
    }

    public static /* synthetic */ KtFile createTempCopy$default(KtFile ktFile2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return KotlinCommonRefactoringUtilKt.createTempCopy(ktFile2, string);
    }

    public static final boolean canRefactorElement(@NotNull PsiElement $this$canRefactorElement) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$canRefactorElement, (String)"<this>");
            if (!$this$canRefactorElement.isValid()) {
                bl = false;
            } else if ($this$canRefactorElement instanceof PsiPackage) {
                PsiDirectory[] psiDirectoryArray = ((PsiPackage)$this$canRefactorElement).getDirectories();
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
                Object[] $this$any$iv = psiDirectoryArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiDirectory it = (PsiDirectory)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!KotlinCommonRefactoringUtilKt.canRefactorElement((PsiElement)it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            } else {
                bl = $this$canRefactorElement instanceof KtElement || $this$canRefactorElement instanceof PsiMember && Intrinsics.areEqual((Object)((PsiMember)$this$canRefactorElement).getLanguage(), (Object)JavaLanguage.INSTANCE) || $this$canRefactorElement instanceof PsiDirectory ? SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.projectSources, false, false, false, false, true, false, 47, null), $this$canRefactorElement) : false;
            }
        }
        return bl;
    }

    public static final boolean isOpen(@NotNull KtClass $this$isOpen) {
        Intrinsics.checkNotNullParameter((Object)$this$isOpen, (String)"<this>");
        return $this$isOpen.hasModifier(KtTokens.OPEN_KEYWORD) || KotlinCommonRefactoringUtilKt.isAbstract((KtDeclaration)$this$isOpen) || KotlinCommonRefactoringUtilKt.isInterfaceClass((PsiElement)$this$isOpen) || $this$isOpen.isSealed();
    }

    public static final boolean isInterfaceClass(@NotNull PsiElement $this$isInterfaceClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInterfaceClass, (String)"<this>");
        PsiElement psiElement2 = $this$isInterfaceClass;
        return psiElement2 instanceof KtClass ? ((KtClass)$this$isInterfaceClass).isInterface() : (psiElement2 instanceof PsiClass ? ((PsiClass)$this$isInterfaceClass).isInterface() : (psiElement2 instanceof KtPsiClassWrapper ? ((KtPsiClassWrapper)$this$isInterfaceClass).getPsiClass().isInterface() : false));
    }

    public static final boolean isAbstract(@NotNull KtDeclaration $this$isAbstract) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isAbstract, (String)"<this>");
        if ($this$isAbstract.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            bl = true;
        } else {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)$this$isAbstract);
            boolean bl2 = ktClassOrObject != null ? KotlinCommonRefactoringUtilKt.isInterfaceClass((PsiElement)ktClassOrObject) : false;
            bl = !bl2 ? false : ($this$isAbstract instanceof KtProperty ? ((KtProperty)$this$isAbstract).getInitializer() == null && ((KtProperty)$this$isAbstract).getDelegate() == null && ((KtProperty)$this$isAbstract).getAccessors().isEmpty() : ($this$isAbstract instanceof KtNamedFunction ? !((KtNamedFunction)$this$isAbstract).hasBody() : false));
        }
        return bl;
    }

    @Nullable
    public static final KtLambdaExpression getLastLambdaExpression(@NotNull KtCallExpression $this$getLastLambdaExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$getLastLambdaExpression, (String)"<this>");
        List list2 = $this$getLastLambdaExpression.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
        if (!((Collection)list2).isEmpty()) {
            return null;
        }
        List list3 = $this$getLastLambdaExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueArguments(...)");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.lastOrNull((List)list3);
        return ktValueArgument != null && (ktValueArgument = ktValueArgument.getArgumentExpression()) != null ? KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)ktValueArgument, (boolean)false, (int)1, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isComplexCallWithLambdaArgument(@NotNull KtCallExpression $this$isComplexCallWithLambdaArgument) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isComplexCallWithLambdaArgument, (String)"<this>");
        List list2 = $this$isComplexCallWithLambdaArgument.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.lastOrNull((List)list2);
        boolean bl2 = ktValueArgument != null ? ktValueArgument.isNamed() : false;
        if (bl2) {
            bl = true;
        } else {
            boolean bl3;
            List list3 = $this$isComplexCallWithLambdaArgument.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueArguments(...)");
            Iterable $this$count$iv = list3;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                bl3 = false;
            } else {
                void var3_3;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    KtLambdaExpression ktLambdaExpression2;
                    KtExpression ktExpression;
                    KtValueArgument it = (KtValueArgument)element$iv;
                    boolean bl4 = false;
                    KtExpression ktExpression2 = ktExpression = it.getArgumentExpression();
                    if (ktExpression2 != null) {
                        Intrinsics.checkNotNull((Object)ktExpression2);
                        ktLambdaExpression2 = KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)ktExpression, (boolean)false, (int)1, null);
                    } else {
                        ktLambdaExpression2 = null;
                    }
                    if (!(ktLambdaExpression2 != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                bl3 = var3_3;
            }
            bl = bl3 > true;
        }
        return bl;
    }

    public static final void moveFunctionLiteralOutsideParentheses(@NotNull KtCallExpression $this$moveFunctionLiteralOutsideParentheses, @Nullable Function1<? super Integer, Unit> moveCaretTo) {
        block27: {
            KtExpression it;
            KtValueArgument argument2;
            List arguments2;
            KtValueArgumentList argumentList2;
            block26: {
                boolean bl;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                PsiElement it2;
                List nextComments2;
                block25: {
                    boolean bl2;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    KtLambdaArgument functionLiteralArgument;
                    KtPsiFactory psiFactory;
                    List prevComments2;
                    block24: {
                        List list22;
                        List list3;
                        PsiElement $i$f$firstOrNull2;
                        List list4;
                        PsiElement prevComma;
                        PsiElement psiElement2;
                        Object v4;
                        PsiElement it3;
                        Object element$iv;
                        Iterator iterator2;
                        KtExpression expression2;
                        block23: {
                            boolean bl3;
                            Intrinsics.checkNotNullParameter((Object)$this$moveFunctionLiteralOutsideParentheses, (String)"<this>");
                            boolean bl4 = $this$moveFunctionLiteralOutsideParentheses.getLambdaArguments().isEmpty();
                            if (_Assertions.ENABLED && !bl4) {
                                String string = "Assertion failed";
                                throw new AssertionError((Object)string);
                            }
                            KtValueArgumentList ktValueArgumentList = $this$moveFunctionLiteralOutsideParentheses.getValueArgumentList();
                            Intrinsics.checkNotNull((Object)ktValueArgumentList);
                            argumentList2 = ktValueArgumentList;
                            List list5 = argumentList2.getArguments();
                            Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getArguments(...)");
                            arguments2 = list5;
                            argument2 = (KtValueArgument)CollectionsKt.last((List)arguments2);
                            KtExpression ktExpression = argument2.getArgumentExpression();
                            Intrinsics.checkNotNull((Object)ktExpression);
                            expression2 = ktExpression;
                            boolean bl5 = bl3 = KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)expression2, (boolean)false, (int)1, null) != null;
                            if (_Assertions.ENABLED && !bl3) {
                                String string = "Assertion failed";
                                throw new AssertionError((Object)string);
                            }
                            Intrinsics.checkNotNull((Object)argument2);
                            Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings((PsiElement)((PsiElement)argument2), (boolean)false, (boolean)false);
                            boolean $i$f$firstOrNull2 = false;
                            iterator2 = $this$firstOrNull$iv.iterator();
                            while (iterator2.hasNext()) {
                                element$iv = iterator2.next();
                                it3 = (PsiElement)element$iv;
                                boolean list22 = false;
                                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it3), (Object)KtTokens.COMMA)) continue;
                                v4 = element$iv;
                                break block23;
                            }
                            v4 = null;
                        }
                        if ((psiElement2 = (prevComma = (PsiElement)v4)) == null) {
                            psiElement2 = argumentList2.getLeftParenthesis();
                        }
                        if ((list4 = ($i$f$firstOrNull2 = psiElement2) != null && (iterator2 = PsiUtilsKt.siblings((PsiElement)$i$f$firstOrNull2, (boolean)true, (boolean)false)) != null && (element$iv = SequencesKt.takeWhile((Sequence)iterator2, (Function1)moveFunctionLiteralOutsideParentheses.prevComments.1.INSTANCE)) != null ? SequencesKt.toList(element$iv) : null) == null) {
                            list4 = prevComments2 = CollectionsKt.emptyList();
                        }
                        if ((list3 = (iterator2 = argumentList2.getRightParenthesis()) != null && (element$iv = PsiUtilsKt.siblings((PsiElement)iterator2, (boolean)false, (boolean)false)) != null && (it3 = SequencesKt.takeWhile(element$iv, (Function1)moveFunctionLiteralOutsideParentheses.nextComments.1.INSTANCE)) != null && (list22 = SequencesKt.toList((Sequence)it3)) != null ? CollectionsKt.reversed((Iterable)list22) : null) == null) {
                            list3 = CollectionsKt.emptyList();
                        }
                        nextComments2 = list3;
                        Project project2 = $this$moveFunctionLiteralOutsideParentheses.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        psiFactory = new KtPsiFactory(project2, false, 2, null);
                        KtExpression ktExpression = psiFactory.createExpression("foo() {}");
                        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                        KtCallExpression dummyCall2 = (KtCallExpression)ktExpression;
                        List list6 = dummyCall2.getLambdaArguments();
                        Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"getLambdaArguments(...)");
                        functionLiteralArgument = (KtLambdaArgument)CollectionsKt.single((List)list6);
                        KtExpression ktExpression2 = functionLiteralArgument.getArgumentExpression();
                        if (ktExpression2 != null) {
                            ktExpression2.replace((PsiElement)expression2);
                        }
                        $this$any$iv = prevComments2;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it2 = (PsiElement)element$iv2;
                                boolean bl6 = false;
                                if (!(it2 instanceof PsiComment)) continue;
                                bl2 = true;
                                break block24;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        if (!(CollectionsKt.firstOrNull((List)prevComments2) instanceof PsiWhiteSpace)) {
                            $this$moveFunctionLiteralOutsideParentheses.add(psiFactory.createWhiteSpace());
                        }
                        $this$forEach$iv = prevComments2;
                        $i$f$forEach = false;
                        for (Object element$iv2 : $this$forEach$iv) {
                            it2 = (PsiElement)element$iv2;
                            boolean bl7 = false;
                            $this$moveFunctionLiteralOutsideParentheses.add(it2);
                        }
                        $this$forEach$iv = prevComments2;
                        $i$f$forEach = false;
                        for (Object element$iv2 : $this$forEach$iv) {
                            it2 = (PsiElement)element$iv2;
                            boolean bl8 = false;
                            if (!(it2 instanceof PsiComment)) continue;
                            it2.delete();
                        }
                    }
                    $this$moveFunctionLiteralOutsideParentheses.add((PsiElement)functionLiteralArgument);
                    $this$any$iv = nextComments2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            it2 = (PsiElement)element$iv2;
                            boolean bl9 = false;
                            if (!(it2 instanceof PsiComment)) continue;
                            bl = true;
                            break block25;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    $this$forEach$iv = nextComments2;
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        it2 = (PsiElement)element$iv2;
                        boolean bl10 = false;
                        $this$moveFunctionLiteralOutsideParentheses.add(it2);
                    }
                    $this$forEach$iv = nextComments2;
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        it2 = (PsiElement)element$iv2;
                        boolean bl11 = false;
                        if (!(it2 instanceof PsiComment)) continue;
                        it2.delete();
                    }
                }
                if (argumentList2.getArguments().size() != 1 || $this$moveFunctionLiteralOutsideParentheses.getCalleeExpression() instanceof KtCallExpression) break block26;
                argumentList2.delete();
                KtExpression ktExpression = $this$moveFunctionLiteralOutsideParentheses.getCalleeExpression();
                if (ktExpression == null) break block27;
                it = ktExpression;
                boolean bl12 = false;
                Function1<? super Integer, Unit> function1 = moveCaretTo;
                if (function1 != null) {
                    function1.invoke((Object)PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it)));
                }
                break block27;
            }
            argumentList2.removeArgument(argument2);
            if (arguments2.size() <= 1) break block27;
            KtValueArgument ktValueArgument = (KtValueArgument)arguments2.get(arguments2.size() - 2);
            if (ktValueArgument != null) {
                it = ktValueArgument;
                boolean bl = false;
                Function1<? super Integer, Unit> function1 = moveCaretTo;
                if (function1 != null) {
                    function1.invoke((Object)PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it)));
                }
            }
        }
    }

    public static /* synthetic */ void moveFunctionLiteralOutsideParentheses$default(KtCallExpression ktCallExpression, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        KotlinCommonRefactoringUtilKt.moveFunctionLiteralOutsideParentheses(ktCallExpression, (Function1<? super Integer, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <ListType extends KtElement> ListType replaceListPsiAndKeepDelimiters(@NotNull ChangeInfo changeInfo, @NotNull ListType originalList, @NotNull ListType newList, @NotNull Function2<? super ListType, ? super ListType, ? extends ListType> listReplacer, @NotNull Function1<? super ListType, ? extends List<? extends KtElement>> itemsFun) {
        block22: {
            PsiElement psiElement2;
            boolean withMultiline;
            int commonCount;
            int newCount;
            List newParameters2;
            List list2;
            block21: {
                boolean keepComments;
                boolean bl;
                List originalIndexes;
                PsiElement it;
                int oldCount;
                block20: {
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)changeInfo, (String)"changeInfo");
                    Intrinsics.checkNotNullParameter(originalList, (String)"originalList");
                    Intrinsics.checkNotNullParameter(newList, (String)"newList");
                    Intrinsics.checkNotNullParameter(listReplacer, (String)"listReplacer");
                    Intrinsics.checkNotNullParameter(itemsFun, (String)"itemsFun");
                    PsiElement[] psiElementArray = originalList.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                    Object[] objectArray = psiElementArray;
                    boolean $i$f$takeWhile = false;
                    ArrayList list$iv = new ArrayList();
                    for (Object item$iv : objectArray) {
                        PsiElement it2 = (PsiElement)item$iv;
                        boolean bl2 = false;
                        if (!(it2 instanceof PsiErrorElement)) break;
                        list$iv.add(item$iv);
                    }
                    Iterable iterable = list$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : iterable) {
                        PsiElement it3 = (PsiElement)element$iv;
                        boolean bl3 = false;
                        it3.delete();
                    }
                    list2 = CollectionsKt.toMutableList((Collection)((Collection)itemsFun.invoke(originalList)));
                    newParameters2 = (List)itemsFun.invoke(newList);
                    oldCount = list2.size();
                    newCount = newParameters2.size();
                    commonCount = Math.min(oldCount, newCount);
                    ParameterInfo[] parameterInfoArray = changeInfo.getNewParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)parameterInfoArray, (String)"getNewParameters(...)");
                    Object[] $this$map$iv = parameterInfoArray;
                    boolean $i$f$map = false;
                    Object[] objectArray2 = $this$map$iv;
                    Iterator destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        ParameterInfo parameterInfo = (ParameterInfo)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(it.getOldIndex());
                    }
                    originalIndexes = (List)((Object)destination$iv$iv);
                    Sequence $this$any$iv = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)originalList));
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it4 = (PsiElement)element$iv;
                        boolean bl5 = false;
                        if (!(it4 instanceof PsiComment)) continue;
                        bl = true;
                        break block20;
                    }
                    bl = false;
                }
                boolean bl2 = keepComments = bl && oldCount > commonCount && Intrinsics.areEqual((Object)originalIndexes, (Object)CollectionsKt.sorted((Iterable)originalIndexes));
                if (!keepComments) {
                    for (int i2 = 0; i2 < commonCount; ++i2) {
                        PsiElement psiElement3 = ((KtElement)list2.get(i2)).replace((PsiElement)newParameters2.get(i2));
                        Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                        list2.set(i2, (KtElement)psiElement3);
                    }
                }
                if (commonCount == 0 && !keepComments) {
                    return (ListType)((KtElement)listReplacer.invoke(originalList, newList));
                }
                if (oldCount <= commonCount) break block21;
                if (keepComments) {
                    Iterable $this$forEach$iv = CollectionsKt.minus((Iterable)((Iterable)RangesKt.until((int)0, (int)list2.size())), (Iterable)originalIndexes);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PsiElement nextComma;
                        int index = ((Number)element$iv).intValue();
                        boolean bl7 = false;
                        KtElement oldParameter = (KtElement)list2.get(index);
                        if (PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)oldParameter), (boolean)false, (int)1, null) != null) {
                            PsiElement it5 = it;
                            boolean bl8 = false;
                            v5 = Intrinsics.areEqual((Object)it5.getNode().getElementType(), (Object)KtTokens.COMMA) ? it : null;
                        } else {
                            v5 = nextComma = null;
                        }
                        if (nextComma != null) {
                            nextComma.delete();
                        } else {
                            Object object = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)oldParameter), (boolean)false, (int)1, null);
                            if (object != null) {
                                PsiElement psiElement4;
                                PsiElement it6 = psiElement4 = object;
                                boolean bl9 = false;
                                object = Intrinsics.areEqual((Object)it6.getNode().getElementType(), (Object)KtTokens.COMMA) ? psiElement4 : null;
                                if (object != null) {
                                    object.delete();
                                }
                            }
                        }
                        oldParameter.delete();
                    }
                } else {
                    originalList.deleteChildRange(((KtElement)list2.get(commonCount - 1)).getNextSibling(), (PsiElement)CollectionsKt.last((List)list2));
                }
                break block22;
            }
            if (newCount <= commonCount) break block22;
            KtElement lastOriginalParameter = (KtElement)CollectionsKt.last((List)list2);
            PsiElement psiBeforeLastParameter = lastOriginalParameter.getPrevSibling();
            boolean bl = withMultiline = (psiBeforeLastParameter instanceof PsiWhiteSpace || psiBeforeLastParameter instanceof PsiComment) && psiBeforeLastParameter.textContains('\n');
            if (withMultiline) {
                Project project2 = originalList.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                psiElement2 = new KtPsiFactory(project2, false, 2, null).createNewLine();
            } else {
                psiElement2 = null;
            }
            PsiElement extraSpace = psiElement2;
            originalList.addRangeAfter(((KtElement)newParameters2.get(commonCount - 1)).getNextSibling(), (PsiElement)CollectionsKt.last((List)newParameters2), (PsiElement)lastOriginalParameter);
            if (extraSpace != null) {
                List addedItems = ((List)itemsFun.invoke(originalList)).subList(commonCount, newCount);
                for (KtElement addedItem : addedItems) {
                    PsiElement elementBefore = addedItem.getPrevSibling();
                    if ((elementBefore instanceof PsiWhiteSpace || elementBefore instanceof PsiComment) && elementBefore.textContains('\n')) continue;
                    addedItem.getParent().addBefore(extraSpace, (PsiElement)addedItem);
                }
            }
        }
        return originalList;
    }

    public static /* synthetic */ KtElement replaceListPsiAndKeepDelimiters$default(ChangeInfo changeInfo, KtElement ktElement, KtElement ktElement2, Function2 function2, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function2 = replaceListPsiAndKeepDelimiters.1.INSTANCE;
        }
        return KotlinCommonRefactoringUtilKt.replaceListPsiAndKeepDelimiters(changeInfo, ktElement, ktElement2, function2, function1);
    }

    @Nullable
    public static final KtElement getDeclarationBody(@NotNull KtNamedDeclaration $this$getDeclarationBody) {
        Intrinsics.checkNotNullParameter((Object)$this$getDeclarationBody, (String)"<this>");
        KtNamedDeclaration ktNamedDeclaration = $this$getDeclarationBody;
        return ktNamedDeclaration instanceof KtClassOrObject ? (KtElement)((KtClassOrObject)$this$getDeclarationBody).getSuperTypeList() : (ktNamedDeclaration instanceof KtPrimaryConstructor ? (KtElement)((KtPrimaryConstructor)$this$getDeclarationBody).getContainingClassOrObject().getSuperTypeList() : (ktNamedDeclaration instanceof KtSecondaryConstructor ? (KtElement)((KtSecondaryConstructor)$this$getDeclarationBody).getDelegationCall() : (ktNamedDeclaration instanceof KtNamedFunction ? (KtElement)((KtNamedFunction)$this$getDeclarationBody).getBodyExpression() : null)));
    }

    public static final boolean isInsideOfCallerBody(@NotNull KtElement $this$isInsideOfCallerBody, @NotNull UsageInfo[] allUsages, @NotNull Function2<? super PsiElement, ? super UsageInfo[], Boolean> isCaller2) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isInsideOfCallerBody, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)allUsages, (String)"allUsages");
            Intrinsics.checkNotNullParameter(isCaller2, (String)"isCaller");
            Sequence $this$firstOrNull$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)$this$isInsideOfCallerBody));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtNamedFunction || it instanceof KtConstructor || it instanceof KtClassOrObject)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Object var5_9 = v0;
        KtNamedDeclaration ktNamedDeclaration = var5_9 instanceof KtNamedDeclaration ? (KtNamedDeclaration)var5_9 : null;
        if (ktNamedDeclaration == null) {
            return false;
        }
        KtNamedDeclaration container = ktNamedDeclaration;
        KtElement ktElement = KotlinCommonRefactoringUtilKt.getDeclarationBody(container);
        if (ktElement == null) {
            return false;
        }
        KtElement body2 = ktElement;
        return body2.getTextRange().contains($this$isInsideOfCallerBody.getTextRange()) && (Boolean)isCaller2.invoke((Object)container, (Object)allUsages) != false;
    }

    public static final void deleteWithCompanion(@NotNull KtNamedDeclaration $this$deleteWithCompanion) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteWithCompanion, (String)"<this>");
        KtClassOrObject containingClass = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$deleteWithCompanion));
        if (containingClass instanceof KtObjectDeclaration && ((KtObjectDeclaration)containingClass).isCompanion() && ((KtObjectDeclaration)containingClass).getDeclarations().size() == 1 && ((KtObjectDeclaration)containingClass).getSuperTypeList() == null) {
            ((KtObjectDeclaration)containingClass).delete();
        } else {
            $this$deleteWithCompanion.delete();
        }
    }

    @NotNull
    public static final List<KtElement> getAllExtractionContainers(@NotNull PsiElement $this$getAllExtractionContainers, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllExtractionContainers, (String)"<this>");
        ArrayList<KtElement> containers2 = new ArrayList<KtElement>();
        boolean objectOrNonInnerNestedClassFound = false;
        Sequence parents2 = strict ? PsiUtilsKt.getParents((PsiElement)$this$getAllExtractionContainers) : PsiUtilsKt.getParentsWithSelf((PsiElement)$this$getAllExtractionContainers);
        for (PsiElement element3 : parents2) {
            PsiElement psiElement2 = element3;
            boolean bl = psiElement2 instanceof KtFile ? true : (psiElement2 instanceof KtClassBody ? !objectOrNonInnerNestedClassFound || ((KtClassBody)element3).getParent() instanceof KtObjectDeclaration : (psiElement2 instanceof KtBlockExpression ? !objectOrNonInnerNestedClassFound : false));
            boolean isValidContainer = bl;
            if (!isValidContainer) continue;
            Intrinsics.checkNotNull((Object)element3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            containers2.add((KtElement)element3);
            if (objectOrNonInnerNestedClassFound) continue;
            KtClassBody ktClassBody = element3 instanceof KtClassBody ? (KtClassBody)element3 : null;
            PsiElement bodyParent = ktClassBody != null ? ktClassBody.getParent() : null;
            objectOrNonInnerNestedClassFound = bodyParent instanceof KtObjectDeclaration && !((KtObjectDeclaration)bodyParent).isObjectLiteral() || bodyParent instanceof KtClass && !((KtClass)bodyParent).isInner();
        }
        return containers2;
    }

    public static /* synthetic */ List getAllExtractionContainers$default(PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return KotlinCommonRefactoringUtilKt.getAllExtractionContainers(psiElement2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtElement> getExtractionContainers(@NotNull PsiElement $this$getExtractionContainers, boolean strict, boolean includeAll, boolean acceptScript) {
        List<Object> list2;
        PsiElement enclosingDeclaration;
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)$this$getExtractionContainers, (String)"<this>");
        if (includeAll) {
            return KotlinCommonRefactoringUtilKt.getAllExtractionContainers($this$getExtractionContainers, strict);
        }
        PsiElement psiElement3 = KotlinCommonRefactoringUtilKt.getExtractionContainers$getEnclosingDeclaration(acceptScript, $this$getExtractionContainers, strict);
        if (psiElement3 != null) {
            PsiElement it = psiElement3;
            boolean bl = false;
            psiElement2 = it instanceof KtDeclarationWithBody || it instanceof KtAnonymousInitializer ? KotlinCommonRefactoringUtilKt.getExtractionContainers$getEnclosingDeclaration(acceptScript, it, true) : it;
        } else {
            psiElement2 = null;
        }
        PsiElement psiElement4 = enclosingDeclaration = psiElement2;
        if (psiElement4 instanceof KtFile) {
            List<PsiElement> list3 = Collections.singletonList(enclosingDeclaration);
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"singletonList(...)");
        } else if (psiElement4 instanceof KtScript) {
            List<PsiElement> list4 = Collections.singletonList(enclosingDeclaration);
            list2 = list4;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"singletonList(...)");
        } else if (psiElement4 instanceof KtClassBody) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = KotlinCommonRefactoringUtilKt.getAllExtractionContainers($this$getExtractionContainers, strict);
            boolean $i$f$filterIsInstance = false;
            Iterable bl = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtClassBody)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            PsiElement psiElement5 = enclosingDeclaration;
            KtExpression targetContainer = psiElement5 instanceof KtDeclarationWithBody ? ((KtDeclarationWithBody)enclosingDeclaration).getBodyExpression() : (psiElement5 instanceof KtAnonymousInitializer ? ((KtAnonymousInitializer)enclosingDeclaration).getBody() : null);
            List<Object> list5 = targetContainer instanceof KtBlockExpression ? Collections.singletonList(targetContainer) : Collections.emptyList();
            Intrinsics.checkNotNull(list5);
            list2 = list5;
        }
        return list2;
    }

    public static /* synthetic */ List getExtractionContainers$default(PsiElement psiElement2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        return KotlinCommonRefactoringUtilKt.getExtractionContainers(psiElement2, bl, bl2, bl3);
    }

    @NotNull
    public static final KtElement addElement(@NotNull KtBlockExpression $this$addElement, @NotNull KtElement element3, boolean addNewLine) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)$this$addElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement rBrace = $this$addElement.getRBrace();
        Project project2 = $this$addElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        PsiElement newLine = new KtPsiFactory(project2, false, 2, null).createNewLine();
        if (rBrace == null) {
            PsiElement lastChild = $this$addElement.getLastChild();
            PsiWhiteSpace psiWhiteSpace = lastChild instanceof PsiWhiteSpace ? (PsiWhiteSpace)lastChild : null;
            if (psiWhiteSpace != null) {
                psiElement2 = (PsiElement)psiWhiteSpace;
            } else {
                PsiElement psiElement3 = $this$addElement.addAfter(newLine, lastChild);
                psiElement2 = psiElement3;
                Intrinsics.checkNotNull((Object)psiElement3);
            }
        } else {
            PsiElement psiElement4 = rBrace.getPrevSibling();
            psiElement2 = psiElement4;
            Intrinsics.checkNotNull((Object)psiElement4);
        }
        PsiElement anchor = psiElement2;
        PsiElement psiElement5 = $this$addElement.addAfter((PsiElement)element3, anchor);
        Intrinsics.checkNotNull((Object)psiElement5);
        KtElement addedElement = (KtElement)psiElement5;
        if (addNewLine) {
            $this$addElement.addAfter(newLine, (PsiElement)addedElement);
        }
        return addedElement;
    }

    public static /* synthetic */ KtElement addElement$default(KtBlockExpression ktBlockExpression, KtElement ktElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KotlinCommonRefactoringUtilKt.addElement(ktBlockExpression, ktElement, bl);
    }

    public static final void checkConflictsInteractively(@NotNull Project $this$checkConflictsInteractively, @NotNull MultiMap<PsiElement, String> conflicts2, @NotNull Function0<Unit> onShowConflicts, @NotNull Function0<Unit> onAccept) {
        Intrinsics.checkNotNullParameter((Object)$this$checkConflictsInteractively, (String)"<this>");
        Intrinsics.checkNotNullParameter(conflicts2, (String)"conflicts");
        Intrinsics.checkNotNullParameter(onShowConflicts, (String)"onShowConflicts");
        Intrinsics.checkNotNullParameter(onAccept, (String)"onAccept");
        if (!conflicts2.isEmpty()) {
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts2.values());
            }
            ConflictsDialog dialog2 = new ConflictsDialog($this$checkConflictsInteractively, conflicts2, () -> KotlinCommonRefactoringUtilKt.checkConflictsInteractively$lambda$20(onAccept));
            dialog2.show();
            if (!dialog2.isOK()) {
                if (dialog2.isShowConflicts()) {
                    onShowConflicts.invoke();
                }
                return;
            }
        }
        onAccept.invoke();
    }

    public static /* synthetic */ void checkConflictsInteractively$default(Project project2, MultiMap multiMap, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = checkConflictsInteractively.1.INSTANCE;
        }
        KotlinCommonRefactoringUtilKt.checkConflictsInteractively(project2, (MultiMap<PsiElement, String>)multiMap, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    public static final boolean hasIdentifiersOnly(@NotNull FqNameUnsafe $this$hasIdentifiersOnly) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasIdentifiersOnly, (String)"<this>");
            List list2 = $this$hasIdentifiersOnly.pathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"pathSegments(...)");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Name it = (Name)element$iv;
                    boolean bl2 = false;
                    String string = it.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    if (KtPsiUtilKt.isIdentifier((String)KtPsiUtilKt.quoteIfNeeded((String)string))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean hasIdentifiersOnly(@NotNull FqName $this$hasIdentifiersOnly) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasIdentifiersOnly, (String)"<this>");
            List list2 = $this$hasIdentifiersOnly.pathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"pathSegments(...)");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Name it = (Name)element$iv;
                    boolean bl2 = false;
                    String string = it.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    if (KtPsiUtilKt.isIdentifier((String)KtPsiUtilKt.quoteIfNeeded((String)string))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean moveFunctionLiteralOutsideParentheses$isWhiteSpaceOrComment(PsiElement e) {
        return e instanceof PsiWhiteSpace || e instanceof PsiComment;
    }

    private static final PsiElement getExtractionContainers$getEnclosingDeclaration(boolean $acceptScript, PsiElement element3, boolean strict) {
        return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)(strict ? PsiUtilsKt.getParents((PsiElement)element3) : PsiUtilsKt.getParentsWithSelf((PsiElement)element3)), (Function1)((Function1)new Function1<PsiElement, Boolean>($acceptScript){
            final /* synthetic */ boolean $acceptScript;
            {
                this.$acceptScript = $acceptScript;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof KtDeclarationWithBody && !(it instanceof KtFunctionLiteral) && (!(it instanceof KtNamedFunction) || ((KtNamedFunction)it).getName() != null) || it instanceof KtAnonymousInitializer || it instanceof KtClassBody || it instanceof KtFile || this.$acceptScript && it instanceof KtScript;
            }
        })));
    }

    private static final void checkConflictsInteractively$lambda$20(Function0 $onAccept) {
        Intrinsics.checkNotNullParameter((Object)$onAccept, (String)"$onAccept");
        $onAccept.invoke();
    }

    public static final /* synthetic */ boolean access$moveFunctionLiteralOutsideParentheses$isWhiteSpaceOrComment(PsiElement e) {
        return KotlinCommonRefactoringUtilKt.moveFunctionLiteralOutsideParentheses$isWhiteSpaceOrComment(e);
    }
}

