/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine;

import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.AnalysisResult;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptorWithException;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractableCodeDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractableCodeDescriptorWithConflicts;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionData;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionEngine;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionEngineHelper;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionGeneratorConfiguration;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionResult;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u0003*\u000e\b\u0002\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00010\u0005*\u000e\b\u0003\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00010\u0007*\u000e\b\u0004\u0010\b*\b\u0012\u0004\u0012\u0002H\u00010\t*\u000e\b\u0005\u0010\n*\b\u0012\u0004\u0012\u0002H\u00010\u000b2\u00020\fB1\u0012*\u0010\r\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0015J1\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00028\u00012\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020\u00170\u001b\u00a2\u0006\u0002\u0010\u001cR5\u0010\r\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionEngine;", "KotlinType", "ExtractionData", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionData;", "Config", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionGeneratorConfiguration;", "Result", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionResult;", "Descriptor", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractableCodeDescriptor;", "DescriptorWithConflicts", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractableCodeDescriptorWithConflicts;", "", "helper", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionEngineHelper;", "(Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionEngineHelper;)V", "getHelper", "()Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionEngineHelper;", "performAnalysis", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/AnalysisResult;", "extractionData", "(Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionData;)Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/AnalysisResult;", "run", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "onFinish", "Lkotlin/Function1;", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionData;Lkotlin/jvm/functions/Function1;)V", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nIExtractionEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IExtractionEngine.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1549#2:173\n1620#2,3:174\n*S KotlinDebug\n*F\n+ 1 IExtractionEngine.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionEngine\n*L\n105#1:173\n105#1:174,3\n*E\n"})
public abstract class IExtractionEngine<KotlinType, ExtractionData extends IExtractionData, Config extends IExtractionGeneratorConfiguration<KotlinType>, Result extends IExtractionResult<KotlinType>, Descriptor extends IExtractableCodeDescriptor<KotlinType>, DescriptorWithConflicts extends IExtractableCodeDescriptorWithConflicts<KotlinType>> {
    @NotNull
    private final IExtractionEngineHelper<KotlinType, ExtractionData, Config, Result, Descriptor, DescriptorWithConflicts> helper;

    public IExtractionEngine(@NotNull IExtractionEngineHelper<KotlinType, ExtractionData, Config, Result, Descriptor, DescriptorWithConflicts> helper2) {
        Intrinsics.checkNotNullParameter(helper2, (String)"helper");
        this.helper = helper2;
    }

    @NotNull
    public final IExtractionEngineHelper<KotlinType, ExtractionData, Config, Result, Descriptor, DescriptorWithConflicts> getHelper() {
        return this.helper;
    }

    @NotNull
    public abstract AnalysisResult<KotlinType> performAnalysis(@NotNull ExtractionData var1);

    /*
     * WARNING - void declaration
     */
    public final void run(@NotNull Editor editor2, @NotNull ExtractionData extractionData, @NotNull Function1<? super Result, Unit> onFinish2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(extractionData, (String)"extractionData");
        Intrinsics.checkNotNullParameter(onFinish2, (String)"onFinish");
        Project project2 = extractionData.getProject();
        ExtractionData adjustExtractionData = this.helper.adjustExtractionData(extractionData);
        AnalysisResult analysisResult2 = (AnalysisResult)ActionUtil.underModalProgress((Project)project2, (String)KotlinBundle.message((String)"progress.title.analyze.extraction.data", (Object[])new Object[0]), () -> IExtractionEngine.run$lambda$0(this, adjustExtractionData));
        if (ApplicationManager.getApplication().isUnitTestMode() && analysisResult2.getStatus() != AnalysisResult.Status.SUCCESS) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = analysisResult2.getMessages();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AnalysisResult.ErrorMessage errorMessage = (AnalysisResult.ErrorMessage)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.renderMessage());
            }
            Collection collection = (List)destination$iv$iv;
            throw new BaseRefactoringProcessor.ConflictsInTestsException(collection);
        }
        String message2 = CollectionsKt.joinToString$default((Iterable)analysisResult2.getMessages(), (CharSequence)"\n", null, null, (int)0, null, (Function1)run.message.1.INSTANCE, (int)30, null);
        switch (WhenMappings.$EnumSwitchMapping$0[analysisResult2.getStatus().ordinal()]) {
            case 1: {
                IntroduceUtilsKt.showErrorHint(project2, editor2, message2, this.helper.getOperationName());
                break;
            }
            case 2: {
                Component component2 = editor2.getContentComponent();
                VisualPosition visualPosition = editor2.getSelectionModel().getSelectionStartPosition();
                Intrinsics.checkNotNull((Object)visualPosition);
                RelativePoint anchorPoint = new RelativePoint(component2, editor2.visualPositionToXY(visualPosition));
                String htmlContent = message2 + "<br/><br/><a href=\"EXTRACT\">" + KotlinBundle.message((String)"text.proceed.with.extraction", (Object[])new Object[0]) + "</a>";
                JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
                Intrinsics.checkNotNull((Object)jBPopupFactory);
                jBPopupFactory.createHtmlTextBalloonBuilder(htmlContent, MessageType.WARNING, arg_0 -> IExtractionEngine.run$lambda$3(project2, this, analysisResult2, editor2, onFinish2, extractionData, arg_0)).setHideOnClickOutside(true).setHideOnFrameResize(false).setHideOnLinkClick(true).createBalloon().show(anchorPoint, Balloon.Position.below);
                break;
            }
            case 3: {
                IExtractionEngine.run$validateAndRefactor(project2, this, analysisResult2, editor2, onFinish2, extractionData);
            }
        }
    }

    public static /* synthetic */ void run$default(IExtractionEngine iExtractionEngine, Editor editor2, IExtractionData iExtractionData, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: run");
        }
        if ((n & 4) != 0) {
            function1 = run.1.INSTANCE;
        }
        iExtractionEngine.run(editor2, iExtractionData, function1);
    }

    private static final AnalysisResult run$lambda$0(IExtractionEngine this$0, IExtractionData $adjustExtractionData) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$adjustExtractionData, (String)"$adjustExtractionData");
        return this$0.performAnalysis($adjustExtractionData);
    }

    private static final Object run$validateAndRefactor$lambda$2(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke();
    }

    private static final <KotlinType, ExtractionData extends IExtractionData, Config extends IExtractionGeneratorConfiguration<KotlinType>, Result extends IExtractionResult<KotlinType>, Descriptor extends IExtractableCodeDescriptor<KotlinType>, DescriptorWithConflicts extends IExtractableCodeDescriptorWithConflicts<KotlinType>> void run$validateAndRefactor(Project project2, IExtractionEngine<KotlinType, ExtractionData, Config, Result, Descriptor, DescriptorWithConflicts> this$0, AnalysisResult<KotlinType> analysisResult2, Editor $editor, Function1<? super Result, Unit> $onFinish, ExtractionData $extractionData) {
        Function0 callable2 = (Function0)new Function0<Object>(this$0, analysisResult2){
            final /* synthetic */ IExtractionEngine<KotlinType, ExtractionData, Config, Result, Descriptor, DescriptorWithConflicts> this$0;
            final /* synthetic */ AnalysisResult<KotlinType> $analysisResult;
            {
                this.this$0 = $receiver;
                this.$analysisResult = $analysisResult;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                ExtractableCodeDescriptorWithException extractableCodeDescriptorWithException;
                try {
                    IExtractionEngineHelper<KotlinType, ExtractionData, Config, Result, IExtractableCodeDescriptor<KotlinType>, DescriptorWithConflicts> iExtractionEngineHelper = this.this$0.getHelper();
                    IExtractableCodeDescriptor<KotlinType> iExtractableCodeDescriptor = this.$analysisResult.getDescriptor();
                    Intrinsics.checkNotNull(iExtractableCodeDescriptor, (String)"null cannot be cast to non-null type Descriptor of org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionEngine.run$validateAndRefactor");
                    extractableCodeDescriptorWithException = iExtractionEngineHelper.validate(iExtractableCodeDescriptor);
                }
                catch (RuntimeException e) {
                    if (e instanceof ControlFlowException) {
                        throw e;
                    }
                    extractableCodeDescriptorWithException = new ExtractableCodeDescriptorWithException(e);
                }
                return extractableCodeDescriptorWithException;
            }
        };
        Function1 finishOnUIThread2 = (Function1)new Function1<Object, Unit>(project2, this$0, $editor, $onFinish, $extractionData){
            final /* synthetic */ Project $project;
            final /* synthetic */ IExtractionEngine<KotlinType, ExtractionData, Config, Result, Descriptor, DescriptorWithConflicts> this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Function1<Result, Unit> $onFinish;
            final /* synthetic */ ExtractionData $extractionData;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$onFinish = $onFinish;
                this.$extractionData = $extractionData;
                super(1);
            }

            public final void invoke(@NotNull Object result2) {
                ExtractableCodeDescriptorWithException extractableCodeDescriptorWithException;
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                ExtractableCodeDescriptorWithException extractableCodeDescriptorWithException2 = extractableCodeDescriptorWithException = result2 instanceof ExtractableCodeDescriptorWithException ? (ExtractableCodeDescriptorWithException)result2 : null;
                if (extractableCodeDescriptorWithException != null) {
                    ExtractableCodeDescriptorWithException it = extractableCodeDescriptorWithException;
                    boolean bl = false;
                    throw it.getException();
                }
                IExtractableCodeDescriptorWithConflicts validationResult2 = (IExtractableCodeDescriptorWithConflicts)result2;
                KotlinCommonRefactoringUtilKt.checkConflictsInteractively$default(this.$project, validationResult2.getConflicts(), null, (Function0)new Function0<Unit>(this.this$0, this.$project, this.$editor, validationResult2, this.$onFinish, this.$extractionData){
                    final /* synthetic */ IExtractionEngine<KotlinType, ExtractionData, Config, Result, Descriptor, DescriptorWithConflicts> this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ DescriptorWithConflicts $validationResult;
                    final /* synthetic */ Function1<Result, Unit> $onFinish;
                    final /* synthetic */ ExtractionData $extractionData;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$editor = $editor;
                        this.$validationResult = $validationResult;
                        this.$onFinish = $onFinish;
                        this.$extractionData = $extractionData;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getHelper().configureAndRun(this.$project, this.$editor, this.$validationResult, (Function1)new Function1<Result, Unit>(this.$onFinish, this.$extractionData){
                            final /* synthetic */ Function1<Result, Unit> $onFinish;
                            final /* synthetic */ ExtractionData $extractionData;
                            {
                                this.$onFinish = $onFinish;
                                this.$extractionData = $extractionData;
                                super(1);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void invoke(@NotNull Result it) {
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                try {
                                    this.$onFinish.invoke(it);
                                }
                                finally {
                                    it.dispose();
                                    this.$extractionData.dispose();
                                }
                            }
                        });
                    }
                }, 2, null);
            }
        };
        Object result2 = ActionUtil.underModalProgress((Project)project2, (String)KotlinBundle.message((String)"progress.title.check.for.conflicts", (Object[])new Object[0]), () -> IExtractionEngine.run$validateAndRefactor$lambda$2(callable2));
        if (result2 != null) {
            finishOnUIThread2.invoke(result2);
        }
    }

    private static final void run$lambda$3(Project $project, IExtractionEngine this$0, AnalysisResult $analysisResult, Editor $editor, Function1 $onFinish, IExtractionData $extractionData, HyperlinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$onFinish, (String)"$onFinish");
        Intrinsics.checkNotNullParameter((Object)$extractionData, (String)"$extractionData");
        HyperlinkEvent hyperlinkEvent = event;
        if (Intrinsics.areEqual((Object)(hyperlinkEvent != null ? hyperlinkEvent.getEventType() : null), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            IExtractionEngine.run$validateAndRefactor($project, this$0, $analysisResult, $editor, $onFinish, $extractionData);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnalysisResult.Status.values().length];
            try {
                nArray[AnalysisResult.Status.CRITICAL_ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnalysisResult.Status.NON_CRITICAL_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnalysisResult.Status.SUCCESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

