/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinRenameDispatcherHandler;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinVariableInplaceRenameHandler;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J$\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\"\u0010\u000f\u001a\u00020\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\f\u0010\u0013\u001a\u00020\u0006*\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinMemberInplaceRenameHandler;", "Lcom/intellij/refactoring/rename/inplace/MemberInplaceRenameHandler;", "()V", "createMemberRenamer", "Lcom/intellij/refactoring/rename/inplace/MemberInplaceRenamer;", "element", "Lcom/intellij/psi/PsiElement;", "elementToRename", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "editor", "Lcom/intellij/openapi/editor/Editor;", "doRename", "Lcom/intellij/refactoring/rename/inplace/InplaceRefactoring;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "substitute", "RenamerImpl", "kotlin.refactorings.common"})
public final class KotlinMemberInplaceRenameHandler
extends MemberInplaceRenameHandler {
    private final PsiElement substitute(PsiElement $this$substitute) {
        if ($this$substitute instanceof KtPrimaryConstructor) {
            return (PsiElement)((KtPrimaryConstructor)$this$substitute).getContainingClassOrObject();
        }
        if ($this$substitute instanceof KtNameReferenceExpression) {
            PsiElement psiElement2 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)$this$substitute)).resolve();
            if (psiElement2 == null) {
                psiElement2 = $this$substitute;
            }
            return psiElement2;
        }
        return $this$substitute;
    }

    @Nullable
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, @NotNull Editor editor2, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (elementToRename instanceof KtNameReferenceExpression) {
            PsiElement psiElement2 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)elementToRename)).resolve();
            if (psiElement2 == null) {
                psiElement2 = elementToRename;
            }
            return super.doRename(psiElement2, editor2, dataContext);
        }
        return super.doRename(elementToRename, editor2, dataContext);
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(@NotNull PsiElement element3, @NotNull PsiNameIdentifierOwner elementToRename, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiElement psiElement2 = this.substitute((PsiElement)elementToRename);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiNameIdentifierOwner");
        PsiNameIdentifierOwner currentElementToRename = (PsiNameIdentifierOwner)psiElement2;
        PsiElement nameIdentifier = currentElementToRename.getNameIdentifier();
        int offset2 = editor2.getCaretModel().getOffset();
        PsiFile editorPsiFile = PsiDocumentManager.getInstance((Project)element3.getProject()).getPsiFile(editor2.getDocument());
        if (nameIdentifier != null && Intrinsics.areEqual((Object)editorPsiFile, (Object)elementToRename.getContainingFile()) && elementToRename instanceof KtPrimaryConstructor && !nameIdentifier.getTextRange().contains(offset2) && ((KtPrimaryConstructor)elementToRename).getTextRange().contains(offset2)) {
            editor2.getCaretModel().moveToOffset(nameIdentifier.getTextOffset());
        }
        PsiElement psiElement3 = nameIdentifier;
        String string = psiElement3 != null ? psiElement3.getText() : null;
        if (string == null) {
            string = "";
        }
        String currentName = string;
        return new RenamerImpl((PsiNamedElement)currentElementToRename, element3, editor2, currentName, currentName);
    }

    protected boolean isAvailable(@Nullable PsiElement element3, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!editor2.getSettings().isVariableInplaceRenameEnabled()) {
            return false;
        }
        PsiElement psiElement2 = element3;
        PsiElement psiElement3 = psiElement2 != null ? this.substitute(psiElement2) : null;
        KtNamedDeclaration ktNamedDeclaration = psiElement3 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement3 : null;
        if (ktNamedDeclaration == null) {
            return false;
        }
        KtNamedDeclaration currentElement = ktNamedDeclaration;
        return currentElement.getNameIdentifier() != null && !KotlinVariableInplaceRenameHandler.Companion.isInplaceRenameAvailable((PsiElement)currentElement);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\tH\u0014J\u001c\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u001c\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinMemberInplaceRenameHandler$RenamerImpl;", "Lcom/intellij/refactoring/rename/inplace/MemberInplaceRenamer;", "elementToRename", "Lcom/intellij/psi/PsiNamedElement;", "substitutedElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "currentName", "", "oldName", "(Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;Ljava/lang/String;)V", "acceptReference", "", "reference", "Lcom/intellij/psi/PsiReference;", "createInplaceRenamerToRestart", "Lcom/intellij/refactoring/rename/inplace/VariableInplaceRenamer;", "variable", "initialName", "isIdentifier", "newName", "language", "Lcom/intellij/lang/Language;", "startsOnTheSameElement", "handler", "Lcom/intellij/refactoring/RefactoringActionHandler;", "element", "kotlin.refactorings.common"})
    private static final class RenamerImpl
    extends MemberInplaceRenamer {
        public RenamerImpl(@NotNull PsiNamedElement elementToRename, @Nullable PsiElement substitutedElement, @NotNull Editor editor2, @NotNull String currentName, @NotNull String oldName) {
            Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)currentName, (String)"currentName");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            super(elementToRename, substitutedElement, editor2, currentName, oldName);
        }

        protected boolean isIdentifier(@Nullable String newName2, @Nullable Language language) {
            if (Intrinsics.areEqual((Object)newName2, (Object)"")) {
                PsiNamedElement psiNamedElement = this.getVariable();
                KtObjectDeclaration ktObjectDeclaration = psiNamedElement instanceof KtObjectDeclaration ? (KtObjectDeclaration)psiNamedElement : null;
                boolean bl = ktObjectDeclaration != null ? ktObjectDeclaration.isCompanion() : false;
                if (bl) {
                    return true;
                }
            }
            return super.isIdentifier(newName2, language);
        }

        protected boolean acceptReference(@NotNull PsiReference reference2) {
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            PsiElement psiElement2 = reference2.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
            PsiElement refElement2 = psiElement2;
            TextRange textRange = reference2.getRangeInElement();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
            TextRange textRange2 = textRange;
            String string = refElement2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = textRange2.getStartOffset();
            int n2 = textRange2.getEndOffset();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String referenceText = KotlinPsiModificationUtils.unquoteKotlinIdentifier(string3);
            return Intrinsics.areEqual((Object)referenceText, (Object)this.myElementToRename.getName());
        }

        protected boolean startsOnTheSameElement(@Nullable RefactoringActionHandler handler2, @Nullable PsiElement element3) {
            return Intrinsics.areEqual((Object)this.getVariable(), (Object)element3) && (handler2 instanceof MemberInplaceRenameHandler || handler2 instanceof KotlinRenameDispatcherHandler);
        }

        @NotNull
        protected VariableInplaceRenamer createInplaceRenamerToRestart(@NotNull PsiNamedElement variable2, @NotNull Editor editor2, @NotNull String initialName2) {
            Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)initialName2, (String)"initialName");
            PsiElement psiElement2 = this.getSubstituted();
            String string = this.myOldName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myOldName");
            return (VariableInplaceRenamer)new RenamerImpl(variable2, psiElement2, editor2, initialName2, string);
        }
    }
}

