/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00010\f\u00a8\u0006\r"}, d2={"findOverridingMethod", "Lcom/intellij/psi/PsiMethod;", "inheritor", "Lcom/intellij/psi/PsiClass;", "baseElement", "Lcom/intellij/psi/PsiNamedElement;", "findOverridingMethodsInKotlin", "", "parentClass", "parameters", "Lcom/intellij/psi/search/searches/OverridingMethodsSearch$SearchParameters;", "consumer", "Lcom/intellij/util/Processor;", "kotlin.base.analysis"})
public final class InternalSearchUtilsKt {
    public static final boolean findOverridingMethodsInKotlin(@NotNull PsiClass parentClass2, @NotNull PsiNamedElement baseElement, @NotNull OverridingMethodsSearch.SearchParameters parameters2, @NotNull Processor<? super PsiMethod> consumer) {
        Intrinsics.checkNotNullParameter((Object)parentClass2, (String)"parentClass");
        Intrinsics.checkNotNullParameter((Object)baseElement, (String)"baseElement");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return ClassInheritorsSearch.search((PsiClass)parentClass2, (SearchScope)parameters2.getScope(), (boolean)true).forEach(arg_0 -> InternalSearchUtilsKt.findOverridingMethodsInKotlin$lambda$0(consumer, parameters2, baseElement, arg_0));
    }

    private static final PsiMethod findOverridingMethod(PsiClass inheritor, PsiNamedElement baseElement) {
        if (!(inheritor instanceof KtLightClass)) {
            return null;
        }
        String name2 = baseElement.getName();
        PsiMethod[] psiMethodArray = inheritor.findMethodsByName(name2, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
        for (PsiMethod lightMethodCandidate : psiMethodArray) {
            KtLightMethod ktLightMethod = lightMethodCandidate instanceof KtLightMethod ? (KtLightMethod)lightMethodCandidate : null;
            if (ktLightMethod == null || (ktLightMethod = (KtDeclaration)ktLightMethod.getKotlinOrigin()) == null) continue;
            KtLightMethod kotlinOrigin = ktLightMethod;
            Project project2 = ((KtLightClass)inheritor).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (!KotlinSearchUsagesSupport.Companion.getInstance(project2).isCallableOverride((KtDeclaration)kotlinOrigin, baseElement)) continue;
            return lightMethodCandidate;
        }
        return null;
    }

    private static final boolean findOverridingMethodsInKotlin$lambda$0(Processor $consumer, OverridingMethodsSearch.SearchParameters $parameters, PsiNamedElement $baseElement, PsiClass inheritor) {
        Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
        Intrinsics.checkNotNullParameter((Object)$parameters, (String)"$parameters");
        Intrinsics.checkNotNullParameter((Object)$baseElement, (String)"$baseElement");
        Intrinsics.checkNotNullParameter((Object)inheritor, (String)"inheritor");
        PsiMethod found2 = (PsiMethod)ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiMethod>(inheritor, $baseElement){
            final /* synthetic */ PsiClass $inheritor;
            final /* synthetic */ PsiNamedElement $baseElement;
            {
                this.$inheritor = $inheritor;
                this.$baseElement = $baseElement;
                super(0);
            }

            @Nullable
            public final PsiMethod invoke() {
                return InternalSearchUtilsKt.access$findOverridingMethod(this.$inheritor, this.$baseElement);
            }
        }));
        return found2 == null || $consumer.process((Object)found2) && $parameters.isCheckDeep();
    }

    public static final /* synthetic */ PsiMethod access$findOverridingMethod(PsiClass inheritor, PsiNamedElement baseElement) {
        return InternalSearchUtilsKt.findOverridingMethod(inheritor, baseElement);
    }
}

