/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.refIndex;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.idea.search.refIndex.KotlinCompilerReferenceIndexVerifierActionKt;
import org.jetbrains.kotlin.idea.search.refIndex.KotlinReferenceIndexBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexVerifierAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "kotlin.compiler-reference-index"})
@SourceDebugExtension(value={"SMAP\nKotlinCompilerReferenceIndexVerifierAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompilerReferenceIndexVerifierAction.kt\norg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexVerifierAction\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,144:1\n118#2:145\n*S KotlinDebug\n*F\n+ 1 KotlinCompilerReferenceIndexVerifierAction.kt\norg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexVerifierAction\n*L\n51#1:145\n*E\n"})
public final class KotlinCompilerReferenceIndexVerifierAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KotlinCompilerReferenceIndexVerifierAction() {
        super(KotlinReferenceIndexBundle.INSTANCE.lazyMessage("action.KotlinCompilerReferenceIndexVerifierAction.text", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            boolean bl = false;
            KotlinCompilerReferenceIndexVerifierActionKt.access$showProjectNotFound();
            return;
        }
        Project project3 = project2;
        PsiElement psiElement2 = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        if (psiElement2 == null) {
            boolean bl = false;
            KotlinCompilerReferenceIndexVerifierActionKt.access$showPsiElementNotFound(project3);
            return;
        }
        PsiElement element3 = psiElement2;
        SmartPsiElementPointer pointToElement = SmartPointersKt.createSmartPointer((PsiElement)element3);
        Object[] objectArray = new Object[]{this};
        ReadAction.nonBlocking(() -> KotlinCompilerReferenceIndexVerifierAction.actionPerformed$lambda$2(pointToElement)).finishOnUiThread(ModalityState.current(), arg_0 -> KotlinCompilerReferenceIndexVerifierAction.actionPerformed$lambda$3((Function1)new Function1<Companion.CompilerReferenceData, Unit>(project3){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(Companion.CompilerReferenceData context2) {
                if (context2 == null) {
                    return;
                }
                String string = KotlinReferenceIndexBundle.INSTANCE.message("dialog.title.compiler.index.status", new Object[0]);
                DialogPanel dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(context2){
                    final /* synthetic */ Companion.CompilerReferenceData $context;
                    {
                        this.$context = $context;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$panel) {
                        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                        KotlinCompilerReferenceIndexVerifierActionKt.access$rowWithImmutableTextField($this$panel, "Element class:", this.$context.getElementText());
                        Panel.group$default((Panel)$this$panel, (String)"PsiSearchHelper#getCodeUsageScope", (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.$context){
                            final /* synthetic */ Companion.CompilerReferenceData $context;
                            {
                                this.$context = $context;
                                super(1);
                            }

                            public final void invoke(@NotNull Panel $this$group) {
                                Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                                Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.$context){
                                    final /* synthetic */ Companion.CompilerReferenceData $context;
                                    {
                                        this.$context = $context;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Row $this$row) {
                                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                        KotlinCompilerReferenceIndexVerifierActionKt.access$immutableScrollableTextArea($this$row, this.$context.getCodeUsageScopeText());
                                    }
                                }), (int)1, null).resizableRow();
                            }
                        }), (int)2, null).resizableRow();
                        Panel.group$default((Panel)$this$panel, (String)"Use Scope vs. Code Usage Scope", (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.$context){
                            final /* synthetic */ Companion.CompilerReferenceData $context;
                            {
                                this.$context = $context;
                                super(1);
                            }

                            public final void invoke(@NotNull Panel $this$group) {
                                Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                                KotlinCompilerReferenceIndexVerifierActionKt.access$rowWithImmutableTextField($this$group, "Number of Kotlin files:", this.$context.getNumberOfKotlinFilesInUseScope() + "/" + this.$context.getNumberOfKotlinFilesInCodeUsageScope());
                                KotlinCompilerReferenceIndexVerifierActionKt.access$rowWithImmutableTextField($this$group, "Number of Java files:", this.$context.getNumberOfJavaFilesInUseScope() + "/" + this.$context.getNumberOfJavaFilesInCodeUsageScope());
                            }
                        }), (int)2, null);
                    }
                }));
                ComponentsKt.dialog$default((String)string, (JComponent)((JComponent)dialogPanel), (boolean)true, null, (boolean)false, (Project)this.$project, null, null, null, null, null, (int)2008, null).show();
            }
        }, arg_0)).coalesceBy(objectArray).inSmartMode(project3).expireWhen(() -> KotlinCompilerReferenceIndexVerifierAction.actionPerformed$lambda$4(pointToElement, project3)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static final Companion.CompilerReferenceData actionPerformed$lambda$2(SmartPsiElementPointer $pointToElement) {
        Intrinsics.checkNotNullParameter((Object)$pointToElement, (String)"$pointToElement");
        PsiElement psiElement2 = $pointToElement.getElement();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement psiElement3 = psiElement2;
        SearchScope codeUsageScope = KotlinScopeUtils.codeUsageScope(psiElement3);
        SearchScope useScope2 = KotlinScopeUtils.useScope(psiElement3);
        String string = Reflection.getOrCreateKotlinClass(psiElement3.getClass()).getSimpleName();
        PsiElement $this$safeAs$iv = psiElement3;
        boolean $i$f$safeAs = false;
        PsiElement psiElement4 = $this$safeAs$iv;
        if (!(psiElement4 instanceof PsiNamedElement)) {
            psiElement4 = null;
        }
        PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement4;
        String string2 = string + ":" + (psiNamedElement != null ? psiNamedElement.getName() : null);
        String string3 = SearchUtilKt.toHumanReadableString(codeUsageScope);
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"INSTANCE");
        String string4 = KotlinCompilerReferenceIndexVerifierAction.Companion.countOfFileType(codeUsageScope, (FileType)kotlinFileType);
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaFileType, (String)"INSTANCE");
        String string5 = KotlinCompilerReferenceIndexVerifierAction.Companion.countOfFileType(codeUsageScope, (FileType)javaFileType);
        KotlinFileType kotlinFileType2 = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType2, (String)"INSTANCE");
        String string6 = KotlinCompilerReferenceIndexVerifierAction.Companion.countOfFileType(useScope2, (FileType)kotlinFileType2);
        JavaFileType javaFileType2 = JavaFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaFileType2, (String)"INSTANCE");
        return new Companion.CompilerReferenceData(string2, string3, string4, string5, string6, KotlinCompilerReferenceIndexVerifierAction.Companion.countOfFileType(useScope2, (FileType)javaFileType2));
    }

    private static final void actionPerformed$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean actionPerformed$lambda$4(SmartPsiElementPointer $pointToElement, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$pointToElement, (String)"$pointToElement");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return $pointToElement.getElement() == null || $project.isDisposed();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexVerifierAction$Companion;", "", "()V", "countOfFileType", "", "Lcom/intellij/psi/search/SearchScope;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "CompilerReferenceData", "kotlin.compiler-reference-index"})
    @SourceDebugExtension(value={"SMAP\nKotlinCompilerReferenceIndexVerifierAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompilerReferenceIndexVerifierAction.kt\norg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexVerifierAction$Companion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,144:1\n118#2:145\n*S KotlinDebug\n*F\n+ 1 KotlinCompilerReferenceIndexVerifierAction.kt\norg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexVerifierAction$Companion\n*L\n106#1:145\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String countOfFileType(SearchScope $this$countOfFileType, FileType fileType) {
            Object object;
            block5: {
                block4: {
                    SearchScope $this$safeAs$iv = $this$countOfFileType;
                    boolean $i$f$safeAs = false;
                    SearchScope searchScope2 = $this$safeAs$iv;
                    if (!(searchScope2 instanceof GlobalSearchScope)) {
                        searchScope2 = null;
                    }
                    if ((object = (GlobalSearchScope)searchScope2) == null) break block4;
                    GlobalSearchScope it = object;
                    boolean bl = false;
                    String string = String.valueOf(FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)it).size());
                    object = string;
                    if (string != null) break block5;
                }
                object = "Non global scope";
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexVerifierAction$Companion$CompilerReferenceData;", "", "elementText", "", "codeUsageScopeText", "numberOfKotlinFilesInCodeUsageScope", "numberOfJavaFilesInCodeUsageScope", "numberOfKotlinFilesInUseScope", "numberOfJavaFilesInUseScope", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCodeUsageScopeText", "()Ljava/lang/String;", "getElementText", "getNumberOfJavaFilesInCodeUsageScope", "getNumberOfJavaFilesInUseScope", "getNumberOfKotlinFilesInCodeUsageScope", "getNumberOfKotlinFilesInUseScope", "kotlin.compiler-reference-index"})
        private static final class CompilerReferenceData {
            @NotNull
            private final String elementText;
            @NotNull
            private final String codeUsageScopeText;
            @NotNull
            private final String numberOfKotlinFilesInCodeUsageScope;
            @NotNull
            private final String numberOfJavaFilesInCodeUsageScope;
            @NotNull
            private final String numberOfKotlinFilesInUseScope;
            @NotNull
            private final String numberOfJavaFilesInUseScope;

            public CompilerReferenceData(@NotNull String elementText, @NotNull String codeUsageScopeText, @NotNull String numberOfKotlinFilesInCodeUsageScope, @NotNull String numberOfJavaFilesInCodeUsageScope, @NotNull String numberOfKotlinFilesInUseScope, @NotNull String numberOfJavaFilesInUseScope) {
                Intrinsics.checkNotNullParameter((Object)elementText, (String)"elementText");
                Intrinsics.checkNotNullParameter((Object)codeUsageScopeText, (String)"codeUsageScopeText");
                Intrinsics.checkNotNullParameter((Object)numberOfKotlinFilesInCodeUsageScope, (String)"numberOfKotlinFilesInCodeUsageScope");
                Intrinsics.checkNotNullParameter((Object)numberOfJavaFilesInCodeUsageScope, (String)"numberOfJavaFilesInCodeUsageScope");
                Intrinsics.checkNotNullParameter((Object)numberOfKotlinFilesInUseScope, (String)"numberOfKotlinFilesInUseScope");
                Intrinsics.checkNotNullParameter((Object)numberOfJavaFilesInUseScope, (String)"numberOfJavaFilesInUseScope");
                this.elementText = elementText;
                this.codeUsageScopeText = codeUsageScopeText;
                this.numberOfKotlinFilesInCodeUsageScope = numberOfKotlinFilesInCodeUsageScope;
                this.numberOfJavaFilesInCodeUsageScope = numberOfJavaFilesInCodeUsageScope;
                this.numberOfKotlinFilesInUseScope = numberOfKotlinFilesInUseScope;
                this.numberOfJavaFilesInUseScope = numberOfJavaFilesInUseScope;
            }

            @NotNull
            public final String getElementText() {
                return this.elementText;
            }

            @NotNull
            public final String getCodeUsageScopeText() {
                return this.codeUsageScopeText;
            }

            @NotNull
            public final String getNumberOfKotlinFilesInCodeUsageScope() {
                return this.numberOfKotlinFilesInCodeUsageScope;
            }

            @NotNull
            public final String getNumberOfJavaFilesInCodeUsageScope() {
                return this.numberOfJavaFilesInCodeUsageScope;
            }

            @NotNull
            public final String getNumberOfKotlinFilesInUseScope() {
                return this.numberOfKotlinFilesInUseScope;
            }

            @NotNull
            public final String getNumberOfJavaFilesInUseScope() {
                return this.numberOfJavaFilesInUseScope;
            }
        }
    }
}

