/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.testIntegration.framework;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.idea.testIntegration.framework.KotlinPsiBasedTestFramework;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0004J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bH\u0004J\u001e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0004J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001fH\u0004J \u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0004H\u0004J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0018H\u0016J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0018H\u0016J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020$H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/testIntegration/framework/AbstractKotlinPsiBasedTestFramework;", "Lorg/jetbrains/kotlin/idea/testIntegration/framework/KotlinPsiBasedTestFramework;", "()V", "allowTestMethodsInObject", "", "getAllowTestMethodsInObject", "()Z", "disabledTestAnnotation", "", "getDisabledTestAnnotation", "()Ljava/lang/String;", "markerClassFqn", "getMarkerClassFqn", "checkNameMatch", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "fqNames", "", "shortName", "checkTestClass", "Lcom/intellij/util/ThreeState;", "declaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "findAnnotatedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "classOrObject", "isAnnotated", "element", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "fqName", "isFrameworkAvailable", "Lorg/jetbrains/kotlin/psi/KtElement;", "javaOnly", "isIgnoredMethod", "isTestMethod", "responsibleFor", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "kotlin.base.code-insight"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinPsiBasedTestFramework.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinPsiBasedTestFramework.kt\norg/jetbrains/kotlin/idea/testIntegration/framework/AbstractKotlinPsiBasedTestFramework\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,136:1\n1#2:137\n1747#3,3:138\n1747#3,3:141\n1747#3,3:144\n142#4:147\n*S KotlinDebug\n*F\n+ 1 AbstractKotlinPsiBasedTestFramework.kt\norg/jetbrains/kotlin/idea/testIntegration/framework/AbstractKotlinPsiBasedTestFramework\n*L\n53#1:138,3\n54#1:141,3\n55#1:144,3\n68#1:147\n*E\n"})
public abstract class AbstractKotlinPsiBasedTestFramework
implements KotlinPsiBasedTestFramework {
    @NotNull
    protected abstract String getMarkerClassFqn();

    @NotNull
    protected abstract String getDisabledTestAnnotation();

    protected abstract boolean getAllowTestMethodsInObject();

    protected final boolean isFrameworkAvailable(@NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return this.isFrameworkAvailable(element3, this.getMarkerClassFqn(), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isFrameworkAvailable(@NotNull KtElement element3, @NotNull String markerClassFqn, boolean javaOnly) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)markerClassFqn, (String)"markerClassFqn");
        Module module2 = GenericPsiUtils.getModule((PsiElement)element3);
        if (module2 == null) {
            return false;
        }
        Module module3 = module2;
        boolean javaClassExists = JavaLibraryUtil.hasLibraryClass((Module)module3, (String)markerClassFqn);
        if (javaOnly) return javaClassExists;
        if (javaClassExists) {
            return javaClassExists;
        }
        GlobalSearchScope globalSearchScope = module3.getModuleWithDependenciesAndLibrariesScope(true);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleWithDependenciesAndLibrariesScope(...)");
        GlobalSearchScope scope2 = globalSearchScope;
        Processor processor2 = AbstractKotlinPsiBasedTestFramework::isFrameworkAvailable$lambda$0;
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (!KotlinFullClassNameIndex.Helper.processElements(markerClassFqn, project2, scope2, processor2)) return true;
        Project project3 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        if (KotlinTopLevelTypeAliasFqNameIndex.Helper.processElements(markerClassFqn, project3, scope2, processor2)) return false;
        return true;
    }

    @Override
    public boolean responsibleFor(@NotNull KtNamedDeclaration declaration2) {
        boolean bl;
        block5: {
            block6: {
                KtClassOrObject ktClassOrObject;
                block8: {
                    block7: {
                        KtNamedDeclaration ktNamedDeclaration;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                            if (!this.isFrameworkAvailable((KtElement)declaration2)) {
                                return false;
                            }
                            ktNamedDeclaration = declaration2;
                            if (!(ktNamedDeclaration instanceof KtClassOrObject)) break block4;
                            bl = this.checkTestClass((KtClassOrObject)declaration2) == ThreeState.YES;
                            break block5;
                        }
                        if (!(ktNamedDeclaration instanceof KtNamedFunction)) break block6;
                        ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration2));
                        if (ktClassOrObject == null) break block7;
                        KtClassOrObject p0 = ktClassOrObject;
                        boolean bl2 = false;
                        ThreeState threeState = this.checkTestClass(p0);
                        ktClassOrObject = threeState;
                        if (threeState != null) break block8;
                    }
                    ktClassOrObject = ThreeState.NO;
                }
                bl = ktClassOrObject == ThreeState.YES && this.isTestMethod((KtNamedFunction)declaration2);
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public ThreeState checkTestClass(@NotNull KtClassOrObject declaration2) {
        ThreeState threeState;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2.isAnnotation()) {
            threeState = ThreeState.NO;
        } else if (declaration2.isTopLevel() && declaration2 instanceof KtObjectDeclaration && !this.getAllowTestMethodsInObject()) {
            threeState = ThreeState.NO;
        } else {
            List list2 = declaration2.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
            if (!((Collection)list2).isEmpty()) {
                threeState = ThreeState.UNSURE;
            } else {
                KtSuperTypeListEntry it;
                boolean bl;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block19: {
                    $this$any$iv = declaration2.getSuperTypeListEntries();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (KtSuperTypeListEntry)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof KtSuperTypeCallEntry)) continue;
                            bl = true;
                            break block19;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    threeState = ThreeState.UNSURE;
                } else {
                    boolean bl3;
                    block20: {
                        $this$any$iv = declaration2.getDeclarations();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (KtDeclaration)element$iv;
                                boolean bl4 = false;
                                if (!(it instanceof KtNamedFunction && !KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)it)))) continue;
                                bl3 = true;
                                break block20;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        threeState = ThreeState.UNSURE;
                    } else {
                        boolean bl5;
                        block21: {
                            $this$any$iv = declaration2.getDeclarations();
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl5 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    it = (KtDeclaration)element$iv;
                                    boolean bl6 = false;
                                    if (!(it instanceof KtClassOrObject && !KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)it)))) continue;
                                    bl5 = true;
                                    break block21;
                                }
                                bl5 = false;
                            }
                        }
                        threeState = bl5 ? ThreeState.UNSURE : ThreeState.NO;
                    }
                }
            }
        }
        return threeState;
    }

    @Override
    public boolean isTestMethod(@NotNull KtNamedFunction declaration2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2.isTopLevel()) {
            bl = false;
        } else if (declaration2.isLocal()) {
            bl = false;
        } else if (declaration2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            bl = false;
        } else if (declaration2.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            bl = false;
        } else if (KtPsiUtilKt.isExtensionDeclaration((PsiElement)((PsiElement)declaration2))) {
            bl = false;
        } else {
            ThreeState threeState;
            KtClassOrObject ktClassOrObject;
            KtClassOrObject ktClassOrObject2;
            if (this.getAllowTestMethodsInObject()) {
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)declaration2;
                boolean $i$f$getStrictParentOfType = false;
                ktClassOrObject2 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
            } else {
                ktClassOrObject2 = (KtClassOrObject)KtPsiUtilKt.containingClass((KtElement)((KtElement)declaration2));
            }
            KtClassOrObject ktClassOrObject3 = ktClassOrObject = ktClassOrObject2;
            if (ktClassOrObject3 != null) {
                KtClassOrObject p0 = ktClassOrObject3;
                boolean bl2 = false;
                threeState = this.checkTestClass(p0);
            } else {
                threeState = null;
            }
            bl = threeState == ThreeState.YES;
        }
        return bl;
    }

    @Override
    public boolean isIgnoredMethod(@NotNull KtNamedFunction declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return (this.isAnnotated((KtAnnotated)declaration2, "kotlin.test.Ignore") || this.isAnnotated((KtAnnotated)declaration2, this.getDisabledTestAnnotation())) && this.isTestMethod(declaration2);
    }

    protected final boolean checkNameMatch(@NotNull KtFile file2, @NotNull Set<String> fqNames, @NotNull String shortName) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(fqNames, (String)"fqNames");
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        if (fqNames.contains(shortName) || fqNames.contains(file2.getPackageFqName() + "." + shortName)) {
            return true;
        }
        for (KtImportDirective importDirective2 : file2.getImportDirectives()) {
            Object object;
            if (!importDirective2.isValidImport() || (object = importDirective2.getImportedFqName()) == null || (object = object.asString()) == null) continue;
            Object importedFqName = object;
            if (!importDirective2.isAllUnder()) {
                if (Intrinsics.areEqual((Object)importDirective2.getAliasName(), (Object)shortName) && fqNames.contains(importedFqName)) {
                    return true;
                }
                if (!fqNames.contains(importedFqName) || !StringsKt.endsWith$default((String)importedFqName, (String)("." + shortName), (boolean)false, (int)2, null)) continue;
                return true;
            }
            if (!fqNames.contains((String)importedFqName + "." + shortName)) continue;
            return true;
        }
        return false;
    }

    protected final boolean isAnnotated(@NotNull KtAnnotated element3, @NotNull String fqName2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.isAnnotated(element3, SetsKt.setOf((Object)fqName2));
    }

    protected final boolean isAnnotated(@NotNull KtAnnotated element3, @NotNull Set<String> fqNames) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(fqNames, (String)"fqNames");
        List list2 = element3.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
        List annotationEntries = list2;
        if (annotationEntries.isEmpty()) {
            return false;
        }
        KtFile ktFile2 = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile file2 = ktFile2;
        for (KtAnnotationEntry annotationEntry2 : annotationEntries) {
            String fqName2;
            if (annotationEntry2.getShortName() == null) continue;
            KtTypeReference ktTypeReference = annotationEntry2.getTypeReference();
            String string = fqName2 = ktTypeReference != null ? ktTypeReference.getText() : null;
            if (!CollectionsKt.contains((Iterable)fqNames, (Object)fqName2)) {
                Name shortName;
                String string2 = shortName.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                if (!this.checkNameMatch(file2, fqNames, string2)) continue;
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected final KtNamedFunction findAnnotatedFunction(@Nullable KtClassOrObject classOrObject, @NotNull Set<String> fqNames) {
        Intrinsics.checkNotNullParameter(fqNames, (String)"fqNames");
        if (classOrObject == null) {
            return null;
        }
        for (KtDeclaration declaration2 : classOrObject.getDeclarations()) {
            KtNamedFunction function2;
            KtNamedFunction ktNamedFunction = declaration2 instanceof KtNamedFunction ? (KtNamedFunction)declaration2 : null;
            if (ktNamedFunction == null || !this.isAnnotated((KtAnnotated)(function2 = ktNamedFunction), fqNames)) continue;
            return function2;
        }
        return null;
    }

    private static final boolean isFrameworkAvailable$lambda$0(Object it) {
        return false;
    }
}

