/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.hints.BinaryFileTypePolicy;
import com.intellij.util.indexing.hints.FileNameExtensionInputFilter;
import com.intellij.util.indexing.hints.FileTypeInputFilterPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.versions.KotlinJsMetadataVersionIndexKt;
import org.jetbrains.kotlin.idea.versions.KotlinMetadataVersionIndexBase;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u000f\u001a \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\r\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014H\u0014J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R,\u0010\u0004\u001a \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/versions/KotlinJsMetadataVersionIndex;", "Lorg/jetbrains/kotlin/idea/versions/KotlinMetadataVersionIndexBase;", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "()V", "INDEXER", "Lcom/intellij/util/indexing/DataIndexer;", "kotlin.jvm.PlatformType", "Ljava/lang/Void;", "Lcom/intellij/util/indexing/FileContent;", "createBinaryVersion", "versionArray", "", "extraBoolean", "", "([ILjava/lang/Boolean;)Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "getIndexer", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getName", "Lcom/intellij/util/indexing/ID;", "getVersion", "", "Companion", "kotlin.project-configuration"})
@SourceDebugExtension(value={"SMAP\nKotlinJsMetadataVersionIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJsMetadataVersionIndex.kt\norg/jetbrains/kotlin/idea/versions/KotlinJsMetadataVersionIndex\n+ 2 KotlinMetadataVersionIndexBase.kt\norg/jetbrains/kotlin/idea/versions/KotlinMetadataVersionIndexBase\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n52#2,2:62\n54#2,4:65\n1#3:64\n*S KotlinDebug\n*F\n+ 1 KotlinJsMetadataVersionIndex.kt\norg/jetbrains/kotlin/idea/versions/KotlinJsMetadataVersionIndex\n*L\n47#1:62,2\n47#1:65,4\n*E\n"})
public final class KotlinJsMetadataVersionIndex
extends KotlinMetadataVersionIndexBase<JsMetadataVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataIndexer<JsMetadataVersion, Void, FileContent> INDEXER = arg_0 -> KotlinJsMetadataVersionIndex.INDEXER$lambda$2(this, arg_0);
    @NotNull
    private static final ID<JsMetadataVersion, Void> NAME;

    @NotNull
    public ID<JsMetadataVersion, Void> getName() {
        return NAME;
    }

    @Override
    @NotNull
    protected JsMetadataVersion createBinaryVersion(@NotNull int[] versionArray, @Nullable Boolean extraBoolean) {
        Intrinsics.checkNotNullParameter((Object)versionArray, (String)"versionArray");
        return new JsMetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @NotNull
    public DataIndexer<JsMetadataVersion, Void, FileContent> getIndexer() {
        return this.INDEXER;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return KotlinJsMetadataVersionIndexKt.access$getLOG$p();
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter;
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName("JS");
        if (fileType == null) {
            inputFilter = (FileBasedIndex.InputFilter)new FileNameExtensionInputFilter("js", false, BinaryFileTypePolicy.NON_BINARY);
        } else {
            FileType[] fileTypeArray = new FileType[]{fileType};
            inputFilter = (FileBasedIndex.InputFilter)new FileTypeInputFilterPredicate(fileTypeArray);
        }
        return inputFilter;
    }

    public int getVersion() {
        return 3;
    }

    private static final Map INDEXER$lambda$2(KotlinJsMetadataVersionIndex this$0, FileContent inputData) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        HashMap result2 = new HashMap();
        KotlinMetadataVersionIndexBase this_$iv = this$0;
        boolean $i$f$tryBlock = false;
        try {
            boolean bl = false;
            ArrayList metadataList = new ArrayList();
            CharSequence charSequence = inputData.getContentAsText();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getContentAsText(...)");
            KotlinJavascriptMetadataUtils.parseMetadata((CharSequence)charSequence, (List)metadataList);
            for (KotlinJavascriptMetadata metadata : metadataList) {
                JsMetadataVersion jsMetadataVersion;
                JsMetadataVersion it = jsMetadataVersion = metadata.getVersion();
                boolean bl2 = false;
                Object object = it.isCompatible() ? jsMetadataVersion : null;
                if (object == null) {
                    object = JsMetadataVersion.INVALID_VERSION;
                }
                JsMetadataVersion version2 = object;
                ((Map)result2).put(version2, null);
            }
        }
        catch (Throwable e$iv) {
            KotlinMetadataVersionIndexBase.access$getLogger(this_$iv).warn("Could not index ABI version for file " + inputData.getFile() + ": " + e$iv.getMessage());
        }
        return result2;
    }

    static {
        ID iD = ID.create((String)KotlinJsMetadataVersionIndex.class.getCanonicalName());
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"create(...)");
        NAME = iD;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/versions/KotlinJsMetadataVersionIndex$Companion;", "", "()V", "NAME", "Lcom/intellij/util/indexing/ID;", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "Ljava/lang/Void;", "getNAME", "()Lcom/intellij/util/indexing/ID;", "kotlin.project-configuration"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ID<JsMetadataVersion, Void> getNAME() {
            return NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

