/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.UtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0002*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u001a\u0012\u0010\n\u001a\u00020\b*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"typeConversionMap", "", "", "getTypeConversionMethod", "Lcom/intellij/psi/PsiExpression;", "expectedType", "Lcom/intellij/psi/PsiType;", "isMainMethodParameter", "", "Lcom/intellij/psi/PsiVariable;", "needTypeConversion", "expected", "kotlin.j2k.k1.old"})
public final class TypeConverterKt {
    @NotNull
    private static final Map<String, String> typeConversionMap;

    @Nullable
    public static final String getTypeConversionMethod(@NotNull PsiExpression $this$getTypeConversionMethod, @NotNull PsiType expectedType) {
        Intrinsics.checkNotNullParameter((Object)$this$getTypeConversionMethod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        PsiType psiType = $this$getTypeConversionMethod.getType();
        if (psiType == null) {
            return null;
        }
        PsiType actualType = psiType;
        if (Intrinsics.areEqual((Object)actualType, (Object)expectedType)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)expectedType.getCanonicalText(), (Object)"java.lang.String")) {
            return "toString";
        }
        PsiType psiType2 = expectedType;
        return Intrinsics.areEqual((Object)psiType2, (Object)PsiTypes.byteType()) ? "toByte" : (Intrinsics.areEqual((Object)psiType2, (Object)PsiTypes.shortType()) ? "toShort" : (Intrinsics.areEqual((Object)psiType2, (Object)PsiTypes.intType()) ? "toInt" : (Intrinsics.areEqual((Object)psiType2, (Object)PsiTypes.longType()) ? "toLong" : (Intrinsics.areEqual((Object)psiType2, (Object)PsiTypes.floatType()) ? "toFloat" : (Intrinsics.areEqual((Object)psiType2, (Object)PsiTypes.doubleType()) ? "toDouble" : (Intrinsics.areEqual((Object)psiType2, (Object)PsiTypes.charType()) ? "toChar" : null))))));
    }

    public static final boolean needTypeConversion(@NotNull PsiType $this$needTypeConversion, @NotNull PsiType expected) {
        Intrinsics.checkNotNullParameter((Object)$this$needTypeConversion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        String string = expected.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        String expectedStr = string;
        String string2 = $this$needTypeConversion.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalText(...)");
        String actualStr = string2;
        return !Intrinsics.areEqual((Object)expectedStr, (Object)actualStr) && !Intrinsics.areEqual((Object)expectedStr, (Object)typeConversionMap.get(actualStr)) && !Intrinsics.areEqual((Object)actualStr, (Object)typeConversionMap.get(expectedStr));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isMainMethodParameter(PsiVariable $this$isMainMethodParameter) {
        if (!($this$isMainMethodParameter instanceof PsiParameter)) return false;
        PsiElement psiElement2 = ((PsiParameter)$this$isMainMethodParameter).getDeclarationScope();
        if (!(psiElement2 instanceof PsiMethod)) return false;
        PsiMethod psiMethod2 = (PsiMethod)psiElement2;
        if (psiMethod2 == null) return false;
        boolean bl = UtilsKt.isMainMethod(psiMethod2);
        if (!bl) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isMainMethodParameter(PsiVariable $receiver) {
        return TypeConverterKt.isMainMethodParameter($receiver);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"java.lang.Byte", (Object)"byte"), TuplesKt.to((Object)"java.lang.Short", (Object)"short"), TuplesKt.to((Object)"java.lang.Integer", (Object)"int"), TuplesKt.to((Object)"java.lang.Long", (Object)"long"), TuplesKt.to((Object)"java.lang.Float", (Object)"float"), TuplesKt.to((Object)"java.lang.Double", (Object)"double"), TuplesKt.to((Object)"java.lang.Character", (Object)"char")};
        typeConversionMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

