/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.onboarding.k2.satisfaction.survey;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.impl.OnDemandFeedbackResolver;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginMode;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.base.util.DumbModeUtils;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.K2FeedbackSurvey;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.K2UserTrackerState;
import org.jetbrains.kotlin.onboarding.k2.satisfaction.survey.PluginModes;

@State(name="K2NewUserTracker", storages={@Storage(value="k2-feedback.xml")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\b\u0010\u001b\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\u0015\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001fR\u001a\u0010\u0004\u001a\u00020\u0002X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0013\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\f\"\u0004\b\u0015\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTracker;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTrackerState;", "()V", "currentState", "getCurrentState$kotlin_onboarding", "()Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTrackerState;", "setCurrentState$kotlin_onboarding", "(Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTrackerState;)V", "forUnitTests", "", "getForUnitTests$kotlin_onboarding", "()Z", "setForUnitTests$kotlin_onboarding", "(Z)V", "forced", "k2PluginModeForTests", "getK2PluginModeForTests$kotlin_onboarding", "setK2PluginModeForTests$kotlin_onboarding", "switchedToK1", "getSwitchedToK1$kotlin_onboarding", "setSwitchedToK1$kotlin_onboarding", "checkIfKotlinPluginModeWasSwitchedOnRestart", "", "forceShowFeedbackForm", "project", "Lcom/intellij/openapi/project/Project;", "getState", "loadState", "state", "shouldShowK2FeedbackDialog", "shouldShowK2FeedbackDialog$kotlin_onboarding", "Companion", "kotlin.onboarding"})
public final class K2UserTracker
implements PersistentStateComponent<K2UserTrackerState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean forced;
    private boolean switchedToK1;
    private boolean forUnitTests;
    private boolean k2PluginModeForTests;
    @NotNull
    private K2UserTrackerState currentState = new K2UserTrackerState();
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    public final void forceShowFeedbackForm(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.forced = true;
        OnDemandFeedbackResolver.Companion.getInstance().showFeedbackNotification(Reflection.getOrCreateKotlinClass(K2FeedbackSurvey.class), project2, (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ K2UserTracker this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean it) {
                K2UserTracker.access$setForced$p(this.this$0, false);
            }
        });
    }

    public final boolean getSwitchedToK1$kotlin_onboarding() {
        return this.switchedToK1;
    }

    public final void setSwitchedToK1$kotlin_onboarding(boolean bl) {
        this.switchedToK1 = bl;
    }

    public final boolean getForUnitTests$kotlin_onboarding() {
        return this.forUnitTests;
    }

    public final void setForUnitTests$kotlin_onboarding(boolean bl) {
        this.forUnitTests = bl;
    }

    public final boolean getK2PluginModeForTests$kotlin_onboarding() {
        return this.k2PluginModeForTests;
    }

    public final void setK2PluginModeForTests$kotlin_onboarding(boolean bl) {
        this.k2PluginModeForTests = bl;
    }

    @NotNull
    public final K2UserTrackerState getCurrentState$kotlin_onboarding() {
        return this.currentState;
    }

    public final void setCurrentState$kotlin_onboarding(@NotNull K2UserTrackerState k2UserTrackerState) {
        Intrinsics.checkNotNullParameter((Object)((Object)k2UserTrackerState), (String)"<set-?>");
        this.currentState = k2UserTrackerState;
    }

    @NotNull
    public K2UserTrackerState getState() {
        return this.currentState;
    }

    public void loadState(@NotNull K2UserTrackerState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.currentState = state;
    }

    public final void checkIfKotlinPluginModeWasSwitchedOnRestart() {
        if (KotlinPluginModeProvider.Companion.getCurrentPluginMode() == KotlinPluginMode.K1 && Intrinsics.areEqual((Object)this.getState().getLastSavedPluginMode(), (Object)PluginModes.K2.getValue())) {
            LOG.debug("Switched to K1");
            this.switchedToK1 = true;
        }
        if (KotlinPluginModeProvider.Companion.getCurrentPluginMode() == KotlinPluginMode.K2 && Intrinsics.areEqual((Object)this.getState().getLastSavedPluginMode(), (Object)PluginModes.K1.getValue())) {
            LOG.debug("Switched to K2");
            this.getState().setK2UserSince(Instant.now().getEpochSecond());
        }
        this.getState().setLastSavedPluginMode(KotlinPluginModeProvider.Companion.getCurrentPluginMode().name());
    }

    public final boolean shouldShowK2FeedbackDialog$kotlin_onboarding(@NotNull Project project2) {
        boolean k2Chosen;
        boolean projectContainsNonScriptKotlinFile2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (this.forced) {
            return true;
        }
        LOG.debug("State: " + this.getState());
        if (!Registry.is((String)"test.k2.feedback.survey", (boolean)false)) {
            if (!this.forUnitTests && ApplicationManager.getApplication().isInternal()) {
                return false;
            }
            if (this.getState().getUserSawSurvey()) {
                return false;
            }
        } else {
            this.getState().setUserSawSurvey(false);
        }
        boolean bl = projectContainsNonScriptKotlinFile2 = this.forUnitTests || (Boolean)DumbModeUtils.runReadActionInSmartMode(project2, (Function0)new Function0<Boolean>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return ProjectStructureUtils.containsNonScriptKotlinFile(this.$project);
            }
        }) != false;
        if (!projectContainsNonScriptKotlinFile2) {
            return false;
        }
        if (this.switchedToK1) {
            return true;
        }
        boolean bl2 = this.forUnitTests ? this.k2PluginModeForTests : (k2Chosen = KotlinPluginModeProvider.Companion.getCurrentPluginMode() == KotlinPluginMode.K2);
        if (!k2Chosen) {
            LOG.debug("Not showing the K2 feedback dialog because the user doesn't use K2");
            return false;
        }
        if (this.getState().getK2UserSince() == -1L) {
            this.getState().setK2UserSince(Instant.now().getEpochSecond());
        }
        Instant k2UserSince = Instant.ofEpochSecond(this.getState().getK2UserSince());
        Duration durationSinceK2User = Duration.between(k2UserSince, Instant.now());
        LOG.debug("Duration since user became a K2 Kotlin user: " + durationSinceK2User.toDays() + " day(s)");
        return durationSinceK2User.compareTo(Duration.ofSeconds(Registry.intValue((String)"minimum.usage.time.before.showing.k2.survey"))) > 0;
    }

    public static final /* synthetic */ void access$setForced$p(K2UserTracker $this, boolean bl) {
        $this.forced = bl;
    }

    static {
        Logger logger = Logger.getInstance(K2UserTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTracker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTracker;", "kotlin.onboarding"})
    @SourceDebugExtension(value={"SMAP\nK2UserTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2UserTracker.kt\norg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTracker$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,128:1\n40#2,3:129\n*S KotlinDebug\n*F\n+ 1 K2UserTracker.kt\norg/jetbrains/kotlin/onboarding/k2/satisfaction/survey/K2UserTracker$Companion\n*L\n43#1:129,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final K2UserTracker getInstance() {
            boolean $i$f$service = false;
            Class<K2UserTracker> serviceClass$iv = K2UserTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (K2UserTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

