/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.compatibility.libraries;

import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.KotlinLibraryVersionProvider;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.libraries.CoroutinesLibraryCompatibilityStore;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.libraries.KotlinLibraryCompatibilityState;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataStorage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/compatibility/libraries/DefaultKotlinLibraryVersionProvider;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinLibraryVersionProvider;", "()V", "libraryStorages", "", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataStorage;", "Lorg/jetbrains/kotlin/tools/projectWizard/compatibility/libraries/KotlinLibraryCompatibilityState;", "getVersion", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "groupId", "", "artifactId", "projectKotlinVersion", "Lkotlin/KotlinVersion;", "kotlin.project-wizard.core"})
public final class DefaultKotlinLibraryVersionProvider
implements KotlinLibraryVersionProvider {
    @NotNull
    private final List<IdeVersionedDataStorage<KotlinLibraryCompatibilityState>> libraryStorages = new ArrayList();

    public DefaultKotlinLibraryVersionProvider() {
        this.libraryStorages.add(CoroutinesLibraryCompatibilityStore.Companion.getInstance());
    }

    @Override
    @Nullable
    public ExternalLibraryDescriptor getVersion(@NotNull String groupId2, @NotNull String artifactId2, @NotNull KotlinVersion projectKotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)groupId2, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)projectKotlinVersion, (String)"projectKotlinVersion");
        for (IdeVersionedDataStorage<KotlinLibraryCompatibilityState> storage : this.libraryStorages) {
            KotlinLibraryCompatibilityState currentState;
            if ((KotlinLibraryCompatibilityState)storage.getState() == null || !Intrinsics.areEqual((Object)currentState.getGroupId(), (Object)groupId2) || !Intrinsics.areEqual((Object)currentState.getArtifactId(), (Object)artifactId2)) continue;
            Map<String, String> versions = currentState.getVersions();
            String kotlinShortVersion = projectKotlinVersion.getMajor() + "." + projectKotlinVersion.getMinor();
            String string = versions.get(kotlinShortVersion);
            if (string == null) continue;
            String versionToUse = string;
            return new ExternalLibraryDescriptor(groupId2, artifactId2, versionToUse, versionToUse, versionToUse);
        }
        return null;
    }
}

