/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.terminal.TerminalUiSettingsManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalUtil;

@com.intellij.openapi.components.State(name="TerminalOptionsProvider", storages={@Storage(value="terminal.xml", roamingType=RoamingType.DISABLED)}, presentableName=PresentableNameGetter.class, category=SettingsCategory.TOOLS, exportable=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 D2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003DEFB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\b\u0010@\u001a\u00020\u001dH\u0002J\b\u0010A\u001a\u00020\u0002H\u0016J\u0010\u0010B\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020\u0002H\u0016R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\nR\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\b\"\u0004\b \u0010\nR$\u0010!\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\b\"\u0004\b#\u0010\nR$\u0010$\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\b\"\u0004\b&\u0010\nR$\u0010'\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010\b\"\u0004\b)\u0010\nR(\u0010+\u001a\u0004\u0018\u00010*2\b\u0010\u0004\u001a\u0004\u0018\u00010*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u00101\u001a\u00070*\u00a2\u0006\u0002\b22\r\b\u0001\u00101\u001a\u00070*\u00a2\u0006\u0002\b28F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b3\u0010-\"\u0004\b4\u0010/R$\u00105\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010\b\"\u0004\b7\u0010\nR*\u00108\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b9\u0010\u0003\u001a\u0004\b:\u0010\b\"\u0004\b;\u0010\n\u00a8\u0006G"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider$State;", "()V", "value", "", "audibleBell", "getAudibleBell", "()Z", "setAudibleBell", "(Z)V", "closeSessionOnLogout", "getCloseSessionOnLogout", "setCloseSessionOnLogout", "copyOnSelection", "getCopyOnSelection", "setCopyOnSelection", "Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "cursorShape", "getCursorShape", "()Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "setCursorShape", "(Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;)V", "highlightHyperlinks", "getHighlightHyperlinks", "setHighlightHyperlinks", "listeners", "", "Lkotlin/Function0;", "", "mouseReporting", "getMouseReporting", "setMouseReporting", "overrideIdeShortcuts", "getOverrideIdeShortcuts", "setOverrideIdeShortcuts", "pasteOnMiddleMouseButton", "getPasteOnMiddleMouseButton", "setPasteOnMiddleMouseButton", "shellIntegration", "getShellIntegration", "setShellIntegration", "", "shellPath", "getShellPath", "()Ljava/lang/String;", "setShellPath", "(Ljava/lang/String;)V", "state", "tabName", "Lorg/jetbrains/annotations/Nls;", "getTabName", "setTabName", "useOptionAsMetaKey", "getUseOptionAsMetaKey", "setUseOptionAsMetaKey", "useShellPrompt", "getUseShellPrompt$annotations", "getUseShellPrompt", "setUseShellPrompt", "addListener", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "fireSettingsChanged", "getState", "loadState", "newState", "Companion", "PresentableNameGetter", "State", "intellij.terminal"})
public final class TerminalOptionsProvider
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State state = new State();
    @NotNull
    private final List<Function0<Unit>> listeners = new CopyOnWriteArrayList();

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.state = newState;
    }

    public final void addListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        TerminalUtil.addItem(this.listeners, listener, disposable);
    }

    private final void fireSettingsChanged() {
        for (Function0<Unit> listener : this.listeners) {
            listener.invoke();
        }
    }

    @Nullable
    public final String getShellPath() {
        return this.state.getMyShellPath();
    }

    public final void setShellPath(@Nullable String value) {
        if (!Intrinsics.areEqual((Object)this.state.getMyShellPath(), (Object)value)) {
            this.state.setMyShellPath(value);
            this.fireSettingsChanged();
        }
    }

    @NotNull
    public final String getTabName() {
        return this.state.getMyTabName();
    }

    public final void setTabName(@Nls @NotNull String tabName) {
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        if (!Intrinsics.areEqual((Object)this.state.getMyTabName(), (Object)tabName)) {
            this.state.setMyTabName(tabName);
            this.fireSettingsChanged();
        }
    }

    public final boolean getCloseSessionOnLogout() {
        return this.state.getMyCloseSessionOnLogout();
    }

    public final void setCloseSessionOnLogout(boolean value) {
        if (this.state.getMyCloseSessionOnLogout() != value) {
            this.state.setMyCloseSessionOnLogout(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getMouseReporting() {
        return this.state.getMyReportMouse();
    }

    public final void setMouseReporting(boolean value) {
        if (this.state.getMyReportMouse() != value) {
            this.state.setMyReportMouse(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getAudibleBell() {
        return this.state.getMySoundBell();
    }

    public final void setAudibleBell(boolean value) {
        if (this.state.getMySoundBell() != value) {
            this.state.setMySoundBell(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getCopyOnSelection() {
        return this.state.getMyCopyOnSelection();
    }

    public final void setCopyOnSelection(boolean value) {
        if (this.state.getMyCopyOnSelection() != value) {
            this.state.setMyCopyOnSelection(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getPasteOnMiddleMouseButton() {
        return this.state.getMyPasteOnMiddleMouseButton();
    }

    public final void setPasteOnMiddleMouseButton(boolean value) {
        if (this.state.getMyPasteOnMiddleMouseButton() != value) {
            this.state.setMyPasteOnMiddleMouseButton(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getOverrideIdeShortcuts() {
        return this.state.getMyOverrideIdeShortcuts();
    }

    public final void setOverrideIdeShortcuts(boolean value) {
        if (this.state.getMyOverrideIdeShortcuts() != value) {
            this.state.setMyOverrideIdeShortcuts(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getShellIntegration() {
        return this.state.getMyShellIntegration();
    }

    public final void setShellIntegration(boolean value) {
        if (this.state.getMyShellIntegration() != value) {
            this.state.setMyShellIntegration(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getHighlightHyperlinks() {
        return this.state.getMyHighlightHyperlinks();
    }

    public final void setHighlightHyperlinks(boolean value) {
        if (this.state.getMyHighlightHyperlinks() != value) {
            this.state.setMyHighlightHyperlinks(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getUseOptionAsMetaKey() {
        return this.state.getUseOptionAsMetaKey();
    }

    public final void setUseOptionAsMetaKey(boolean value) {
        if (this.state.getUseOptionAsMetaKey() != value) {
            this.state.setUseOptionAsMetaKey(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getUseShellPrompt() {
        return this.state.getUseShellPrompt();
    }

    public final void setUseShellPrompt(boolean value) {
        if (this.state.getUseShellPrompt() != value) {
            this.state.setUseShellPrompt(value);
            this.fireSettingsChanged();
        }
    }

    @Deprecated(message="Use BlockTerminalOptions#promptStyle instead")
    public static /* synthetic */ void getUseShellPrompt$annotations() {
    }

    @NotNull
    public final TerminalUiSettingsManager.CursorShape getCursorShape() {
        return TerminalUiSettingsManager.Companion.getInstance().getCursorShape();
    }

    public final void setCursorShape(@NotNull TerminalUiSettingsManager.CursorShape value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TerminalUiSettingsManager uiSettings = TerminalUiSettingsManager.Companion.getInstance();
        if (uiSettings.getCursorShape() != value) {
            uiSettings.setCursorShape(value);
            this.fireSettingsChanged();
        }
    }

    @JvmStatic
    @NotNull
    public static final TerminalOptionsProvider getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider$Companion;", "", "()V", "instance", "Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider;", "getInstance", "()Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOptionsProvider.kt\norg/jetbrains/plugins/terminal/TerminalOptionsProvider$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,182:1\n40#2,3:183\n*S KotlinDebug\n*F\n+ 1 TerminalOptionsProvider.kt\norg/jetbrains/plugins/terminal/TerminalOptionsProvider$Companion\n*L\n175#1:183,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalOptionsProvider getInstance() {
            boolean $i$f$service = false;
            Class<TerminalOptionsProvider> serviceClass$iv = TerminalOptionsProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TerminalOptionsProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider$PresentableNameGetter;", "Lcom/intellij/openapi/components/State$NameGetter;", "()V", "get", "", "intellij.terminal"})
    public static final class PresentableNameGetter
    extends State.NameGetter {
        @NotNull
        public String get() {
            String string = TerminalBundle.message("toolwindow.stripe.Terminal", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0006\"\u0004\b#\u0010\bR\u001f\u0010$\u001a\u00070\u001c\u00a2\u0006\u0002\b%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001e\"\u0004\b'\u0010 R\u001a\u0010(\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0006\"\u0004\b*\u0010\bR\u001a\u0010+\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0006\"\u0004\b-\u0010\b\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider$State;", "", "()V", "myCloseSessionOnLogout", "", "getMyCloseSessionOnLogout", "()Z", "setMyCloseSessionOnLogout", "(Z)V", "myCopyOnSelection", "getMyCopyOnSelection", "setMyCopyOnSelection", "myHighlightHyperlinks", "getMyHighlightHyperlinks", "setMyHighlightHyperlinks", "myOverrideIdeShortcuts", "getMyOverrideIdeShortcuts", "setMyOverrideIdeShortcuts", "myPasteOnMiddleMouseButton", "getMyPasteOnMiddleMouseButton", "setMyPasteOnMiddleMouseButton", "myReportMouse", "getMyReportMouse", "setMyReportMouse", "myShellIntegration", "getMyShellIntegration", "setMyShellIntegration", "myShellPath", "", "getMyShellPath", "()Ljava/lang/String;", "setMyShellPath", "(Ljava/lang/String;)V", "mySoundBell", "getMySoundBell", "setMySoundBell", "myTabName", "Lorg/jetbrains/annotations/Nls;", "getMyTabName", "setMyTabName", "useOptionAsMetaKey", "getUseOptionAsMetaKey", "setUseOptionAsMetaKey", "useShellPrompt", "getUseShellPrompt", "setUseShellPrompt", "intellij.terminal"})
    public static final class State {
        @Nullable
        private String myShellPath;
        @NotNull
        private String myTabName;
        private boolean myCloseSessionOnLogout;
        private boolean myReportMouse;
        private boolean mySoundBell;
        private boolean myCopyOnSelection;
        private boolean myPasteOnMiddleMouseButton;
        private boolean myOverrideIdeShortcuts;
        private boolean myShellIntegration;
        private boolean myHighlightHyperlinks;
        private boolean useOptionAsMetaKey;
        private boolean useShellPrompt;

        public State() {
            String string = TerminalBundle.message("local.terminal.default.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.myTabName = string;
            this.myCloseSessionOnLogout = true;
            this.myReportMouse = true;
            this.mySoundBell = true;
            this.myCopyOnSelection = SystemInfo.isLinux;
            this.myPasteOnMiddleMouseButton = true;
            this.myOverrideIdeShortcuts = true;
            this.myShellIntegration = true;
            this.myHighlightHyperlinks = true;
        }

        @Nullable
        public final String getMyShellPath() {
            return this.myShellPath;
        }

        public final void setMyShellPath(@Nullable String string) {
            this.myShellPath = string;
        }

        @NotNull
        public final String getMyTabName() {
            return this.myTabName;
        }

        public final void setMyTabName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.myTabName = string;
        }

        public final boolean getMyCloseSessionOnLogout() {
            return this.myCloseSessionOnLogout;
        }

        public final void setMyCloseSessionOnLogout(boolean bl) {
            this.myCloseSessionOnLogout = bl;
        }

        public final boolean getMyReportMouse() {
            return this.myReportMouse;
        }

        public final void setMyReportMouse(boolean bl) {
            this.myReportMouse = bl;
        }

        public final boolean getMySoundBell() {
            return this.mySoundBell;
        }

        public final void setMySoundBell(boolean bl) {
            this.mySoundBell = bl;
        }

        public final boolean getMyCopyOnSelection() {
            return this.myCopyOnSelection;
        }

        public final void setMyCopyOnSelection(boolean bl) {
            this.myCopyOnSelection = bl;
        }

        public final boolean getMyPasteOnMiddleMouseButton() {
            return this.myPasteOnMiddleMouseButton;
        }

        public final void setMyPasteOnMiddleMouseButton(boolean bl) {
            this.myPasteOnMiddleMouseButton = bl;
        }

        public final boolean getMyOverrideIdeShortcuts() {
            return this.myOverrideIdeShortcuts;
        }

        public final void setMyOverrideIdeShortcuts(boolean bl) {
            this.myOverrideIdeShortcuts = bl;
        }

        public final boolean getMyShellIntegration() {
            return this.myShellIntegration;
        }

        public final void setMyShellIntegration(boolean bl) {
            this.myShellIntegration = bl;
        }

        public final boolean getMyHighlightHyperlinks() {
            return this.myHighlightHyperlinks;
        }

        public final void setMyHighlightHyperlinks(boolean bl) {
            this.myHighlightHyperlinks = bl;
        }

        public final boolean getUseOptionAsMetaKey() {
            return this.useOptionAsMetaKey;
        }

        public final void setUseOptionAsMetaKey(boolean bl) {
            this.useOptionAsMetaKey = bl;
        }

        public final boolean getUseShellPrompt() {
            return this.useShellPrompt;
        }

        public final void setUseShellPrompt(boolean bl) {
            this.useShellPrompt = bl;
        }
    }
}

