/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.hyperlinks;

import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.impl.ExpirableTokenProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.hyperlinks.CompositeFilterWrapper;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.CommandBlockImplKt;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0007J\b\u0010\u001e\u001a\u00020\u001cH\u0002R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/terminal/block/hyperlinks/TerminalHyperlinkHighlighter;", "", "project", "Lcom/intellij/openapi/project/Project;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;Lcom/intellij/openapi/Disposable;)V", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "getDocument", "()Lcom/intellij/openapi/editor/ex/DocumentEx;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "filterWrapper", "Lorg/jetbrains/plugins/terminal/block/hyperlinks/CompositeFilterWrapper;", "hyperlinkSupport", "Lcom/intellij/execution/impl/EditorHyperlinkSupport;", "getHyperlinkSupport", "()Lcom/intellij/execution/impl/EditorHyperlinkSupport;", "lastUpdatedBlockInfo", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/terminal/block/output/CommandBlock;", "Lcom/intellij/execution/impl/ExpirableTokenProvider;", "highlightHyperlinks", "", "block", "rehighlightAll", "intellij.terminal"})
public final class TerminalHyperlinkHighlighter {
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final CompositeFilterWrapper filterWrapper;
    @Nullable
    private Pair<? extends CommandBlock, ? extends ExpirableTokenProvider> lastUpdatedBlockInfo;

    public TerminalHyperlinkHighlighter(@NotNull Project project, @NotNull TerminalOutputModel outputModel, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.outputModel = outputModel;
        this.filterWrapper = new CompositeFilterWrapper(project, parentDisposable);
        this.filterWrapper.addFiltersUpdatedListener((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.rehighlightAll();
            }
        }));
    }

    private final EditorEx getEditor() {
        return this.outputModel.getEditor();
    }

    private final DocumentEx getDocument() {
        DocumentEx documentEx = this.outputModel.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        return documentEx;
    }

    private final EditorHyperlinkSupport getHyperlinkSupport() {
        EditorHyperlinkSupport editorHyperlinkSupport = EditorHyperlinkSupport.get((Editor)((Editor)this.getEditor()));
        Intrinsics.checkNotNullExpressionValue((Object)editorHyperlinkSupport, (String)"get(...)");
        return editorHyperlinkSupport;
    }

    private final void rehighlightAll() {
        for (CommandBlock block2 : this.outputModel.getBlocks()) {
            this.highlightHyperlinks(block2);
        }
    }

    @RequiresEdt
    public final void highlightHyperlinks(@NotNull CommandBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        CompositeFilter compositeFilter = this.filterWrapper.getFilter();
        if (compositeFilter == null) {
            return;
        }
        CompositeFilter filter = compositeFilter;
        Pair<? extends CommandBlock, ? extends ExpirableTokenProvider> pair = this.lastUpdatedBlockInfo;
        if (pair != null) {
            Pair<? extends CommandBlock, ? extends ExpirableTokenProvider> it = pair;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getFirst(), (Object)block2)) {
                ((ExpirableTokenProvider)it.getSecond()).invalidateAll();
            }
        }
        ExpirableTokenProvider expirableTokenProvider = new ExpirableTokenProvider();
        this.lastUpdatedBlockInfo = TuplesKt.to((Object)block2, (Object)expirableTokenProvider);
        this.getHyperlinkSupport().clearHyperlinks(block2.getOutputStartOffset(), block2.getEndOffset());
        if (CommandBlockImplKt.getWithOutput(block2)) {
            int startLine = this.getDocument().getLineNumber(block2.getOutputStartOffset());
            int endLine = this.getDocument().getLineNumber(block2.getEndOffset());
            this.getHyperlinkSupport().highlightHyperlinksLater((Filter)filter, startLine, endLine, expirableTokenProvider.createExpirable());
        }
    }
}

