/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.SimpleTerminalEventsHandler;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputController;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelKt;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionModel;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/BlockTerminalEventsHandler;", "Lorg/jetbrains/plugins/terminal/block/SimpleTerminalEventsHandler;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "outputController", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController;", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController;)V", "keyPressed", "", "e", "Ljava/awt/event/KeyEvent;", "keyTyped", "intellij.terminal"})
public final class BlockTerminalEventsHandler
extends SimpleTerminalEventsHandler {
    @NotNull
    private final TerminalOutputController outputController;

    public BlockTerminalEventsHandler(@NotNull BlockTerminalSession session2, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalOutputController outputController) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)outputController, (String)"outputController");
        super(session2, settings, outputController.getOutputModel());
        this.outputController = outputController;
    }

    @Override
    public void keyTyped(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TerminalSelectionModel selectionModel = this.outputController.getSelectionModel();
        if (selectionModel.getPrimarySelection() != null) {
            selectionModel.setSelectedBlocks(CollectionsKt.emptyList());
        }
        this.outputController.scrollToBottom();
        super.keyTyped(e);
    }

    @Override
    public void keyPressed(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CommandBlock selectedBlock = this.outputController.getSelectionModel().getPrimarySelection();
        if (selectedBlock == null || Intrinsics.areEqual((Object)selectedBlock, (Object)TerminalOutputModelKt.getActiveBlock(this.getOutputModel()))) {
            super.keyPressed(e);
        }
    }
}

