/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.terminal.TextStyle;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.TerminalFocusModel;
import org.jetbrains.plugins.terminal.block.hyperlinks.TerminalHyperlinkHighlighter;
import org.jetbrains.plugins.terminal.block.output.BlockTerminalEventsHandler;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.CommandBlockImplKt;
import org.jetbrains.plugins.terminal.block.output.CommandBlockInfo;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.output.TerminalBlocksDecorator;
import org.jetbrains.plugins.terminal.block.output.TerminalCaretModel;
import org.jetbrains.plugins.terminal.block.output.TerminalCaretPainter;
import org.jetbrains.plugins.terminal.block.output.TerminalEventDispatcherKt;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputController;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputEditorInputMethodSupport;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelImpl;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelKt;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionModel;
import org.jetbrains.plugins.terminal.block.output.TerminalTextHighlighter;
import org.jetbrains.plugins.terminal.block.output.TextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.TextStyleAdapter;
import org.jetbrains.plugins.terminal.block.output.TextWithHighlightings;
import org.jetbrains.plugins.terminal.block.output.highlighting.CompositeTerminalTextHighlighter;
import org.jetbrains.plugins.terminal.block.output.highlighting.TerminalCommandBlockHighlighter;
import org.jetbrains.plugins.terminal.block.output.highlighting.TerminalCommandBlockHighlighterProvider;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptRenderingInfo;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputListener;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraper;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperKt;
import org.jetbrains.plugins.terminal.block.session.StyleRange;
import org.jetbrains.plugins.terminal.block.session.StyledCommandOutput;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 Y2\u00020\u0001:\u0004YZ[\\B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.J\u0015\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u000201H\u0001\u00a2\u0006\u0002\b2J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u00020\u0019H\u0003J\u0016\u00109\u001a\u00020\u00192\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0007J!\u0010;\u001a\u0002H<\"\u0004\b\u0000\u0010<2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H<0\u0018H\u0003\u00a2\u0006\u0002\u0010>J\u000e\u0010?\u001a\u00020\u00192\u0006\u0010@\u001a\u000207J\b\u0010A\u001a\u00020\u0019H\u0007J\u0012\u0010B\u001a\u00020\u00192\b\u0010C\u001a\u0004\u0018\u00010DH\u0003J\b\u0010E\u001a\u000201H\u0007J\b\u0010F\u001a\u00020\u0019H\u0007J\u0010\u0010G\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.H\u0002J\u001c\u0010H\u001a\u00020\u00192\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010I\u001a\u0004\u0018\u00010JH\u0007J\u0018\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u000207H\u0002J \u0010P\u001a\u00020\u00192\u0006\u0010Q\u001a\u0002042\u0006\u0010M\u001a\u00020L2\u0006\u0010R\u001a\u000201H\u0002J\u0018\u0010S\u001a\u0002042\u0006\u0010T\u001a\u00020U2\u0006\u0010R\u001a\u000201H\u0003J\f\u0010V\u001a\u00020W*\u00020XH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0018\u00010!R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController;", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$TerminalListener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "focusModel", "Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;)V", "blockCreationAlarm", "Lcom/intellij/util/Alarm;", "blocksDecorator", "Lorg/jetbrains/plugins/terminal/block/output/TerminalBlocksDecorator;", "commandBlockHighlighters", "", "Lorg/jetbrains/plugins/terminal/block/output/highlighting/TerminalCommandBlockHighlighter;", "hyperlinkHighlighter", "Lorg/jetbrains/plugins/terminal/block/hyperlinks/TerminalHyperlinkHighlighter;", "nextBlockCanBeStartedQueue", "Ljava/util/Queue;", "Lkotlin/Function0;", "", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "getOutputModel", "()Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "runningCommandContext", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController$RunningCommandContext;", "runningCommandInteractivity", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController$RunningCommandInteractivity;", "scraper", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraper;", "selectionModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionModel;", "getSelectionModel", "()Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionModel;", "textHighlighter", "Lorg/jetbrains/plugins/terminal/block/output/TerminalTextHighlighter;", "addDocumentListener", "listener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "alternateBufferStateChanged", "enabled", "", "alternateBufferStateChanged$intellij_terminal", "createNewBlock", "Lorg/jetbrains/plugins/terminal/block/output/CommandBlock;", "context", "terminalWidth", "", "disposeRunningCommandInteractivity", "doWhenNextBlockCanBeStarted", "callback", "doWithScrollingAware", "T", "action", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "finishCommandBlock", "exitCode", "insertEmptyLine", "installRunningCommandInteractivity", "command", "", "isCommandRunning", "scrollToBottom", "setupContentListener", "startCommandBlock", "prompt", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "toHighlightedCommandOutput", "Lorg/jetbrains/plugins/terminal/block/output/TextWithHighlightings;", "output", "Lorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;", "baseOffset", "updateBlock", "block", "finished", "updateCommandOutput", "snapshot", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController$TerminalOutputSnapshot;", "toTextAttributesProvider", "Lorg/jetbrains/plugins/terminal/block/output/TextAttributesProvider;", "Lcom/jediterm/terminal/TextStyle;", "Companion", "RunningCommandContext", "RunningCommandInteractivity", "TerminalOutputSnapshot", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOutputController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputController.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 TerminalModel.kt\norg/jetbrains/plugins/terminal/block/session/TerminalModel\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1549#2:321\n1620#2,3:322\n1549#2:335\n1620#2,3:336\n23#3:325\n23#3:333\n23#3:334\n160#4,7:326\n1#5:339\n*S KotlinDebug\n*F\n+ 1 TerminalOutputController.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputController\n*L\n62#1:321\n62#1:322,3\n224#1:335\n224#1:336,3\n112#1:325\n168#1:333\n205#1:334\n127#1:326,7\n*E\n"})
public final class TerminalOutputController
implements TerminalModel.TerminalListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final ShellCommandOutputScraper scraper;
    @NotNull
    private final TerminalBlocksDecorator blocksDecorator;
    @NotNull
    private final TerminalTextHighlighter textHighlighter;
    @NotNull
    private final Alarm blockCreationAlarm;
    @Nullable
    private RunningCommandContext runningCommandContext;
    @Nullable
    private RunningCommandInteractivity runningCommandInteractivity;
    @NotNull
    private final TerminalHyperlinkHighlighter hyperlinkHighlighter;
    @NotNull
    private final Queue<Function0<Unit>> nextBlockCanBeStartedQueue;
    @NotNull
    private final List<TerminalCommandBlockHighlighter> commandBlockHighlighters;
    @NotNull
    private static final DataKey<TerminalOutputController> KEY = DataKey.Companion.create("TerminalOutputController");

    /*
     * WARNING - void declaration
     */
    public TerminalOutputController(@NotNull Project project, @NotNull EditorEx editor, @NotNull BlockTerminalSession session2, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalFocusModel focusModel) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)focusModel, (String)"focusModel");
        this.editor = editor;
        this.session = session2;
        this.settings = settings;
        this.outputModel = new TerminalOutputModelImpl(this.editor);
        this.selectionModel = new TerminalSelectionModel(this.outputModel);
        this.scraper = new ShellCommandOutputScraper(this.session);
        this.blocksDecorator = new TerminalBlocksDecorator(this.session.getColorPalette(), this.outputModel, focusModel, this.selectionModel, this.editor);
        this.textHighlighter = new TerminalTextHighlighter(this.outputModel);
        this.blockCreationAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.session);
        this.hyperlinkHighlighter = new TerminalHyperlinkHighlighter(project, this.outputModel, this.session);
        this.nextBlockCanBeStartedQueue = new LinkedList();
        Iterable iterable = TerminalCommandBlockHighlighterProvider.Companion.getCOMMAND_BLOCK_HIGHLIGHTER_PROVIDER_EP_NAME$intellij_terminal().getExtensionList();
        TerminalOutputController terminalOutputController = this;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TerminalCommandBlockHighlighterProvider terminalCommandBlockHighlighterProvider = (TerminalCommandBlockHighlighterProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            collection.add(it.getHighlighter(editorColorsScheme));
        }
        terminalOutputController.commandBlockHighlighters = (List)destination$iv$iv;
        this.editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_OUTPUT_EDITOR_KEY$intellij_terminal(), (Object)true);
        this.editor.setHighlighter((EditorHighlighter)new CompositeTerminalTextHighlighter(this.outputModel, this.textHighlighter, CollectionsKt.toMutableList((Collection)this.commandBlockHighlighters)));
        TerminalModel.addTerminalListener$default(this.session.getModel(), this, null, 2, null);
        BlockTerminalSession.addCommandListener$default(this.session, new ShellCommandListener(){

            @Override
            public void clearInvoked() {
                Disposable disposable = Disposer.newDisposable((Disposable)session);
                Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                Disposable disposable2 = disposable;
                session.addCommandListener(new ShellCommandListener(this, disposable2){
                    final /* synthetic */ TerminalOutputController this$0;
                    final /* synthetic */ Disposable $disposable;
                    {
                        this.this$0 = $receiver;
                        this.$disposable = $disposable;
                    }

                    public void commandFinished(@NotNull CommandFinishedEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Function0<Boolean> function0 = TerminalUiUtilsKt.getDisposed((Editor)TerminalOutputController.access$getEditor$p(this.this$0));
                        ModalityState modalityState = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                        TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> clearInvoked.1.commandFinished$lambda$0(this.this$0));
                        Disposer.dispose((Disposable)this.$disposable);
                    }

                    private static final void commandFinished$lambda$0(TerminalOutputController this$0) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        this$0.getOutputModel().clearBlocks();
                    }
                }, disposable2);
            }
        }, null, 2, null);
    }

    @NotNull
    public final TerminalOutputModel getOutputModel() {
        return this.outputModel;
    }

    @NotNull
    public final TerminalSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @RequiresEdt
    public final void startCommandBlock(@Nullable String command2, @Nullable TerminalPromptRenderingInfo prompt) {
        RunningCommandContext newRunningCommandContext;
        this.scrollToBottom();
        this.installRunningCommandInteractivity(command2);
        this.runningCommandContext = newRunningCommandContext = new RunningCommandContext(command2, prompt);
        Function0 createBlockRequest2 = (Function0)new Function0<Unit>(this, newRunningCommandContext){
            final /* synthetic */ TerminalOutputController this$0;
            final /* synthetic */ RunningCommandContext $newRunningCommandContext;
            {
                this.this$0 = $receiver;
                this.$newRunningCommandContext = $newRunningCommandContext;
                super(0);
            }

            public final void invoke() {
                TerminalOutputController.access$doWithScrollingAware(this.this$0, (Function0)new Function0<Unit>(this.this$0, this.$newRunningCommandContext){
                    final /* synthetic */ TerminalOutputController this$0;
                    final /* synthetic */ RunningCommandContext $newRunningCommandContext;
                    {
                        this.this$0 = $receiver;
                        this.$newRunningCommandContext = $newRunningCommandContext;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        int n;
                        void this_$iv;
                        TerminalModel terminalModel = TerminalOutputController.access$getSession$p(this.this$0).getModel();
                        TerminalOutputController terminalOutputController = this.this$0;
                        boolean $i$f$withContentLock = false;
                        this_$iv.lockContent();
                        try {
                            boolean bl = false;
                            n = TerminalOutputController.access$getSession$p(terminalOutputController).getModel().getWidth();
                        }
                        finally {
                            this_$iv.unlockContent();
                        }
                        int terminalWidth = n;
                        TerminalOutputController.access$createNewBlock(this.this$0, this.$newRunningCommandContext, terminalWidth);
                    }
                });
            }
        };
        this.blockCreationAlarm.addRequest(() -> TerminalOutputController.startCommandBlock$lambda$1(createBlockRequest2), 200);
    }

    @RequiresEdt(generateAssertion=false)
    private final void installRunningCommandInteractivity(String command2) {
        if (this.runningCommandInteractivity != null) {
            TerminalOutputController $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TerminalOutputController.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Running command interactivity is already installed");
            this.disposeRunningCommandInteractivity();
        }
        this.runningCommandInteractivity = new RunningCommandInteractivity(command2);
    }

    @RequiresEdt(generateAssertion=false)
    private final void disposeRunningCommandInteractivity() {
        if (this.runningCommandInteractivity == null) {
            throw new IllegalStateException("No running command interactivity".toString());
        }
        RunningCommandInteractivity runningCommandInteractivity = this.runningCommandInteractivity;
        Intrinsics.checkNotNull((Object)runningCommandInteractivity);
        Disposer.dispose((Disposable)runningCommandInteractivity.getDisposable());
        this.runningCommandInteractivity = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finishCommandBlock(int exitCode) {
        int n;
        StyledCommandOutput output = this.scraper.scrapeOutput();
        TerminalModel this_$iv = this.session.getModel();
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            n = this.session.getModel().getWidth();
        }
        finally {
            this_$iv.unlockContent();
        }
        int terminalWidth = n;
        Function0<Boolean> function0 = TerminalUiUtilsKt.getDisposed((Editor)this.editor);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> TerminalOutputController.finishCommandBlock$lambda$3(this, exitCode, terminalWidth, output));
    }

    @RequiresEdt
    public final void insertEmptyLine() {
        this.editor.getDocument().insertString(this.editor.getDocument().getTextLength(), (CharSequence)"\n");
        this.scrollToBottom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void scrollToBottom() {
        ScrollingModelEx scrollingModelEx = this.editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModelEx, (String)"getScrollingModel(...)");
        ScrollingModelEx scrollingModel = scrollingModelEx;
        scrollingModel.disableAnimation();
        try {
            Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            Rectangle visibleArea = rectangle;
            scrollingModel.scrollVertically(this.editor.getContentComponent().getHeight() - visibleArea.height);
        }
        finally {
            scrollingModel.enableAnimation();
        }
    }

    @RequiresEdt(generateAssertion=false)
    public final void alternateBufferStateChanged$intellij_terminal(boolean enabled) {
        if (this.runningCommandContext == null) {
            TerminalOutputController $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TerminalOutputController.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Alternate screen buffer changed (" + enabled + "), but no running command");
        }
        if (enabled) {
            if (this.runningCommandInteractivity != null) {
                this.disposeRunningCommandInteractivity();
            }
        } else {
            RunningCommandContext rcc = this.runningCommandContext;
            if (rcc != null && this.runningCommandInteractivity == null) {
                this.installRunningCommandInteractivity(rcc.getCommand());
            }
        }
    }

    private final void setupContentListener(Disposable disposable) {
        this.scraper.addListener(new ShellCommandOutputListener(this){
            final /* synthetic */ TerminalOutputController this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void commandOutputChanged(@NotNull StyledCommandOutput output) {
                int n;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                TerminalModel terminalModel = TerminalOutputController.access$getSession$p(this.this$0).getModel();
                TerminalOutputController terminalOutputController = this.this$0;
                boolean $i$f$withContentLock = false;
                this_$iv.lockContent();
                try {
                    boolean bl = false;
                    n = TerminalOutputController.access$getSession$p(terminalOutputController).getModel().getWidth();
                }
                finally {
                    this_$iv.unlockContent();
                }
                int terminalWidth = n;
                Function0<Boolean> function0 = TerminalUiUtilsKt.getDisposed((Editor)TerminalOutputController.access$getEditor$p(this.this$0));
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> setupContentListener.1.commandOutputChanged$lambda$1(this.this$0, terminalWidth, output));
            }

            private static final void commandOutputChanged$lambda$1(TerminalOutputController this$0, int $terminalWidth, StyledCommandOutput $output) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$output, (String)"$output");
                if (TerminalOutputController.access$getRunningCommandContext$p(this$0) != null) {
                    TerminalOutputController.access$doWithScrollingAware(this$0, (Function0)new Function0<CommandBlock>(this$0, $terminalWidth, $output){
                        final /* synthetic */ TerminalOutputController this$0;
                        final /* synthetic */ int $terminalWidth;
                        final /* synthetic */ StyledCommandOutput $output;
                        {
                            this.this$0 = $receiver;
                            this.$terminalWidth = $terminalWidth;
                            this.$output = $output;
                            super(0);
                        }

                        @NotNull
                        public final CommandBlock invoke() {
                            return TerminalOutputController.access$updateCommandOutput(this.this$0, new TerminalOutputSnapshot(this.$terminalWidth, this.$output), false);
                        }
                    });
                }
            }
        }, disposable, true);
    }

    @RequiresEdt(generateAssertion=false)
    private final CommandBlock updateCommandOutput(TerminalOutputSnapshot snapshot, boolean finished) {
        CommandBlock commandBlock = TerminalOutputModelKt.getActiveBlock(this.outputModel);
        if (commandBlock == null) {
            TerminalOutputController $this$updateCommandOutput_u24lambda_u245 = this;
            boolean bl = false;
            $this$updateCommandOutput_u24lambda_u245.blockCreationAlarm.cancelAllRequests();
            RunningCommandContext runningCommandContext = $this$updateCommandOutput_u24lambda_u245.runningCommandContext;
            if (runningCommandContext == null) {
                TerminalOutputController $this$updateCommandOutput_u24lambda_u245_u24lambda_u244 = $this$updateCommandOutput_u24lambda_u245;
                boolean bl2 = false;
                TerminalOutputController $this$thisLogger$iv = $this$updateCommandOutput_u24lambda_u245_u24lambda_u244;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(TerminalOutputController.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("No running command context");
                runningCommandContext = new RunningCommandContext(null, null);
            }
            RunningCommandContext context = runningCommandContext;
            commandBlock = $this$updateCommandOutput_u24lambda_u245.createNewBlock(context, snapshot.getWidth());
        }
        CommandBlock activeBlock = commandBlock;
        StyledCommandOutput output = finished ? ShellCommandOutputScraperKt.dropLastBlankLine(snapshot.getOutput(), this.session.getShellIntegration().getShellType()) : snapshot.getOutput();
        this.updateBlock(activeBlock, this.toHighlightedCommandOutput(output, activeBlock.getOutputStartOffset()), finished);
        return activeBlock;
    }

    private final CommandBlock createNewBlock(RunningCommandContext context, int terminalWidth) {
        CommandBlock block2 = this.outputModel.createBlock(context.getCommand(), context.getPrompt(), terminalWidth);
        if (!CommandBlockImplKt.getTextRange(block2).isEmpty()) {
            this.blocksDecorator.installDecoration(block2);
        }
        return block2;
    }

    /*
     * WARNING - void declaration
     */
    private final TextWithHighlightings toHighlightedCommandOutput(StyledCommandOutput output, int baseOffset) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = output.getStyleRanges();
        String string = output.getText();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StyleRange styleRange = (StyleRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HighlightingInfo(baseOffset + it.getStartOffset(), baseOffset + it.getEndOffset(), this.toTextAttributesProvider(it.getStyle())));
        }
        List list = (List)destination$iv$iv;
        String string2 = string;
        return new TextWithHighlightings(string2, list);
    }

    private final void updateBlock(CommandBlock block2, TextWithHighlightings output, boolean finished) {
        block1: {
            Object object;
            boolean isPostponedNewLine;
            List highlightings2 = SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.outputModel.getHighlightings(block2)), (Function1)((Function1)new Function1<HighlightingInfo, Boolean>(block2){
                final /* synthetic */ CommandBlock $block;
                {
                    this.$block = $block;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull HighlightingInfo it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getEndOffset() <= this.$block.getOutputStartOffset();
                }
            })), (Iterable)output.getHighlightings()));
            this.outputModel.putHighlightings(block2, highlightings2);
            boolean bl = isPostponedNewLine = CommandBlockImplKt.getWithPrompt(block2) || CommandBlockImplKt.getWithCommand(block2);
            String result2 = isPostponedNewLine && (!finished || ((CharSequence)output.getText()).length() > 0) ? "\n" + output.getText() : output.getText();
            this.editor.getDocument().replaceString(block2.getOutputStartOffset() - (isPostponedNewLine ? 1 : 0), block2.getEndOffset(), (CharSequence)result2);
            this.outputModel.trimOutput();
            this.hyperlinkHighlighter.highlightHyperlinks(block2);
            if (!StringsKt.isBlank((CharSequence)output.getText()) && !Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)output.getText())).toString(), (Object)"%")) {
                this.blocksDecorator.installDecoration(block2);
            }
            if ((object = this.runningCommandInteractivity) == null || (object = ((RunningCommandInteractivity)object).getCaretPainter()) == null) break block1;
            ((TerminalCaretPainter)object).repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt(generateAssertion=false)
    private final <T> T doWithScrollingAware(Function0<? extends T> action) {
        Rectangle it = this.editor.getScrollingModel().getVisibleArea();
        boolean bl = false;
        boolean wasAtBottom = it.y + it.height == this.editor.getContentComponent().getHeight();
        try {
            Object object = action.invoke();
            return (T)object;
        }
        finally {
            if (wasAtBottom) {
                this.scrollToBottom();
            }
        }
    }

    private final TextAttributesProvider toTextAttributesProvider(TextStyle $this$toTextAttributesProvider) {
        return new TextStyleAdapter($this$toTextAttributesProvider, this.session.getColorPalette());
    }

    public final void addDocumentListener(@NotNull DocumentListener listener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (disposable != null) {
            this.editor.getDocument().addDocumentListener(listener, disposable);
        } else {
            this.editor.getDocument().addDocumentListener(listener);
        }
    }

    public static /* synthetic */ void addDocumentListener$default(TerminalOutputController terminalOutputController, DocumentListener documentListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalOutputController.addDocumentListener(documentListener, disposable);
    }

    @RequiresEdt
    public final void doWhenNextBlockCanBeStarted(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (!this.isCommandRunning()) {
            callback.invoke();
        } else {
            this.nextBlockCanBeStartedQueue.offer(callback);
        }
    }

    @RequiresEdt(generateAssertion=true)
    public final boolean isCommandRunning() {
        return this.runningCommandContext != null || TerminalOutputModelKt.getActiveBlock(this.outputModel) != null;
    }

    private static final void startCommandBlock$lambda$1(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void finishCommandBlock$lambda$3(TerminalOutputController this$0, int $exitCode, int $terminalWidth, StyledCommandOutput $output) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$output, (String)"$output");
            CommandBlock block2 = (CommandBlock)this$0.doWithScrollingAware((Function0)new Function0<CommandBlock>(this$0, $terminalWidth, $output){
                final /* synthetic */ TerminalOutputController this$0;
                final /* synthetic */ int $terminalWidth;
                final /* synthetic */ StyledCommandOutput $output;
                {
                    this.this$0 = $receiver;
                    this.$terminalWidth = $terminalWidth;
                    this.$output = $output;
                    super(0);
                }

                @NotNull
                public final CommandBlock invoke() {
                    return TerminalOutputController.access$updateCommandOutput(this.this$0, new TerminalOutputSnapshot(this.$terminalWidth, this.$output), true);
                }
            });
            this$0.disposeRunningCommandInteractivity();
            String string = this$0.editor.getDocument().getText(CommandBlockImplKt.getTextRange(block2));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                this$0.outputModel.removeBlock(block2);
            } else {
                this$0.outputModel.setBlockInfo(block2, new CommandBlockInfo($exitCode));
                this$0.outputModel.finalizeBlock(block2);
            }
            this$0.runningCommandContext = null;
            Function0<Unit> function0 = this$0.nextBlockCanBeStartedQueue.poll();
            if (function0 == null) break block2;
            function0.invoke();
        }
    }

    public static final /* synthetic */ Object access$doWithScrollingAware(TerminalOutputController $this, Function0 action) {
        return $this.doWithScrollingAware(action);
    }

    public static final /* synthetic */ CommandBlock access$createNewBlock(TerminalOutputController $this, RunningCommandContext context, int terminalWidth) {
        return $this.createNewBlock(context, terminalWidth);
    }

    public static final /* synthetic */ RunningCommandContext access$getRunningCommandContext$p(TerminalOutputController $this) {
        return $this.runningCommandContext;
    }

    public static final /* synthetic */ CommandBlock access$updateCommandOutput(TerminalOutputController $this, TerminalOutputSnapshot snapshot, boolean finished) {
        return $this.updateCommandOutput(snapshot, finished);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalOutputController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController$RunningCommandContext;", "", "command", "", "prompt", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "(Ljava/lang/String;Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;)V", "getCommand", "()Ljava/lang/String;", "getPrompt", "()Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
    private static final class RunningCommandContext {
        @Nullable
        private final String command;
        @Nullable
        private final TerminalPromptRenderingInfo prompt;

        public RunningCommandContext(@Nullable String command2, @Nullable TerminalPromptRenderingInfo prompt) {
            this.command = command2;
            this.prompt = prompt;
        }

        @Nullable
        public final String getCommand() {
            return this.command;
        }

        @Nullable
        public final TerminalPromptRenderingInfo getPrompt() {
            return this.prompt;
        }

        @Nullable
        public final String component1() {
            return this.command;
        }

        @Nullable
        public final TerminalPromptRenderingInfo component2() {
            return this.prompt;
        }

        @NotNull
        public final RunningCommandContext copy(@Nullable String command2, @Nullable TerminalPromptRenderingInfo prompt) {
            return new RunningCommandContext(command2, prompt);
        }

        public static /* synthetic */ RunningCommandContext copy$default(RunningCommandContext runningCommandContext, String string, TerminalPromptRenderingInfo terminalPromptRenderingInfo, int n, Object object) {
            if ((n & 1) != 0) {
                string = runningCommandContext.command;
            }
            if ((n & 2) != 0) {
                terminalPromptRenderingInfo = runningCommandContext.prompt;
            }
            return runningCommandContext.copy(string, terminalPromptRenderingInfo);
        }

        @NotNull
        public String toString() {
            return "RunningCommandContext(command=" + this.command + ", prompt=" + this.prompt + ")";
        }

        public int hashCode() {
            int result2 = this.command == null ? 0 : this.command.hashCode();
            result2 = result2 * 31 + (this.prompt == null ? 0 : this.prompt.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RunningCommandContext)) {
                return false;
            }
            RunningCommandContext runningCommandContext = (RunningCommandContext)other;
            if (!Intrinsics.areEqual((Object)this.command, (Object)runningCommandContext.command)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.prompt, (Object)runningCommandContext.prompt);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController$RunningCommandInteractivity;", "", "command", "", "(Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController;Ljava/lang/String;)V", "caretModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel;", "getCaretModel", "()Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel;", "caretPainter", "Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretPainter;", "getCaretPainter", "()Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretPainter;", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "intellij.terminal"})
    private final class RunningCommandInteractivity {
        @NotNull
        private final Disposable disposable;
        @NotNull
        private final TerminalCaretModel caretModel;
        @NotNull
        private final TerminalCaretPainter caretPainter;

        public RunningCommandInteractivity(String command2) {
            Disposable disposable = Disposer.newDisposable((Disposable)TerminalOutputController.this.session, (String)("command " + command2));
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            this.disposable = disposable;
            this.caretModel = new TerminalCaretModel(TerminalOutputController.this.session, TerminalOutputController.this.getOutputModel(), TerminalOutputController.this.editor, this.disposable);
            this.caretPainter = new TerminalCaretPainter(this.caretModel, TerminalOutputController.this.getOutputModel(), TerminalOutputController.this.getSelectionModel(), TerminalOutputController.this.editor);
            Disposer.register((Disposable)this.disposable, (Disposable)this.caretPainter);
            BlockTerminalEventsHandler eventsHandler = new BlockTerminalEventsHandler(TerminalOutputController.this.session, TerminalOutputController.this.settings, TerminalOutputController.this);
            TerminalEventDispatcherKt.setupKeyEventDispatcher(TerminalOutputController.this.editor, eventsHandler, this.disposable);
            TerminalEventDispatcherKt.setupMouseListener(TerminalOutputController.this.editor, TerminalOutputController.this.settings, TerminalOutputController.this.session.getModel(), eventsHandler, this.disposable);
            new TerminalOutputEditorInputMethodSupport(TerminalOutputController.this.editor, TerminalOutputController.this.session, this.caretModel).install(this.disposable);
            TerminalOutputController.this.setupContentListener(this.disposable);
        }

        @NotNull
        public final Disposable getDisposable() {
            return this.disposable;
        }

        @NotNull
        public final TerminalCaretModel getCaretModel() {
            return this.caretModel;
        }

        @NotNull
        public final TerminalCaretPainter getCaretPainter() {
            return this.caretPainter;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputController$TerminalOutputSnapshot;", "", "width", "", "output", "Lorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;", "(ILorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;)V", "getOutput", "()Lorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;", "getWidth", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.terminal"})
    private static final class TerminalOutputSnapshot {
        private final int width;
        @NotNull
        private final StyledCommandOutput output;

        public TerminalOutputSnapshot(int width, @NotNull StyledCommandOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.width = width;
            this.output = output;
        }

        public final int getWidth() {
            return this.width;
        }

        @NotNull
        public final StyledCommandOutput getOutput() {
            return this.output;
        }

        public final int component1() {
            return this.width;
        }

        @NotNull
        public final StyledCommandOutput component2() {
            return this.output;
        }

        @NotNull
        public final TerminalOutputSnapshot copy(int width, @NotNull StyledCommandOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return new TerminalOutputSnapshot(width, output);
        }

        public static /* synthetic */ TerminalOutputSnapshot copy$default(TerminalOutputSnapshot terminalOutputSnapshot, int n, StyledCommandOutput styledCommandOutput, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = terminalOutputSnapshot.width;
            }
            if ((n2 & 2) != 0) {
                styledCommandOutput = terminalOutputSnapshot.output;
            }
            return terminalOutputSnapshot.copy(n, styledCommandOutput);
        }

        @NotNull
        public String toString() {
            return "TerminalOutputSnapshot(width=" + this.width + ", output=" + this.output + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.width);
            result2 = result2 * 31 + this.output.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TerminalOutputSnapshot)) {
                return false;
            }
            TerminalOutputSnapshot terminalOutputSnapshot = (TerminalOutputSnapshot)other;
            if (this.width != terminalOutputSnapshot.width) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.output, (Object)terminalOutputSnapshot.output);
        }
    }
}

