/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007J\u001e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/RightPromptManager;", "Lcom/intellij/openapi/Disposable;", "promptEditor", "Lcom/intellij/openapi/editor/Editor;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "inlayEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "dispose", "", "update", "commandStartOffset", "", "text", "", "highlightings", "", "Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "updateInlayEditor", "RightPromptRenderer", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nRightPromptManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RightPromptManager.kt\norg/jetbrains/plugins/terminal/block/prompt/RightPromptManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class RightPromptManager
implements Disposable {
    @NotNull
    private final Editor promptEditor;
    @NotNull
    private final EditorImpl inlayEditor;
    @Nullable
    private Inlay<?> inlay;

    public RightPromptManager(@NotNull Editor promptEditor, @NotNull JBTerminalSystemSettingsProviderBase settings) {
        EditorColorsScheme editorColorsScheme;
        Intrinsics.checkNotNullParameter((Object)promptEditor, (String)"promptEditor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.promptEditor = promptEditor;
        Editor editor = EditorFactory.getInstance().createEditor((Document)new DocumentImpl(""));
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        this.inlayEditor = (EditorImpl)editor;
        this.inlayEditor.setViewer(true);
        this.inlayEditor.getSettings().setCaretRowShown(false);
        EditorColorsScheme $this$_init__u24lambda_u240 = editorColorsScheme = this.inlayEditor.getColorsScheme();
        boolean bl = false;
        $this$_init__u24lambda_u240.setEditorFontName(settings.getTerminalFont().getFontName());
        $this$_init__u24lambda_u240.setEditorFontSize(settings.getTerminalFont().getSize());
        $this$_init__u24lambda_u240.setLineSpacing(1.0f);
    }

    @RequiresEdt
    public final void update(int commandStartOffset, @NotNull String text, @NotNull List<HighlightingInfo> highlightings2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(highlightings2, (String)"highlightings");
        this.updateInlayEditor(text, highlightings2);
        Inlay<?> inlay = this.inlay;
        if (inlay != null) {
            Inlay<?> it = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.inlay = this.promptEditor.getInlayModel().addAfterLineEndElement(commandStartOffset, false, (EditorCustomElementRenderer)new RightPromptRenderer((Editor)this.inlayEditor));
    }

    private final void updateInlayEditor(String text, List<HighlightingInfo> highlightings2) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> RightPromptManager.updateInlayEditor$lambda$2(this, text));
        this.inlayEditor.getMarkupModel().removeAllHighlighters();
        for (HighlightingInfo highlighting : highlightings2) {
            this.inlayEditor.getMarkupModel().addRangeHighlighter(highlighting.getStartOffset(), highlighting.getEndOffset(), 1000, highlighting.getTextAttributesProvider().getTextAttributes(), HighlighterTargetArea.EXACT_RANGE);
        }
    }

    public void dispose() {
        block0: {
            EditorFactory.getInstance().releaseEditor((Editor)this.inlayEditor);
            Inlay<?> inlay = this.inlay;
            if (inlay == null) break block0;
            Inlay<?> it = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
    }

    private static final void updateInlayEditor$lambda$2(RightPromptManager this$0, String $text) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        this$0.inlayEditor.getDocument().setText((CharSequence)$text);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J,\u0010\u0011\u001a\u00020\n2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/RightPromptManager$RightPromptRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "inlayEditor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "doPaint", "", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "paint", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.terminal"})
    private static final class RightPromptRenderer
    implements EditorCustomElementRenderer {
        @NotNull
        private final Editor inlayEditor;

        public RightPromptRenderer(@NotNull Editor inlayEditor) {
            Intrinsics.checkNotNullParameter((Object)inlayEditor, (String)"inlayEditor");
            this.inlayEditor = inlayEditor;
        }

        public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            EditorEx promptEditor = (EditorEx)editor;
            double columnWidth = TerminalUiUtilsKt.getCharSize((Editor)promptEditor).getWidth();
            Rectangle rectangle = promptEditor.getScrollingModel().getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            Rectangle visibleArea = rectangle;
            int scrollBarWidth = promptEditor.getScrollPane().getVerticalScrollBar().getWidth();
            int terminalColumns = (int)((double)(visibleArea.width - scrollBarWidth) / columnWidth);
            int textColumns = this.inlayEditor.getDocument().getTextLength();
            double textWidth = (double)textColumns * columnWidth;
            double textX = (double)terminalColumns * columnWidth - textWidth;
            int promptLine = promptEditor.offsetToLogicalPosition((int)inlay.getOffset()).line;
            int lineStartOffset = promptEditor.getDocument().getLineStartOffset(promptLine);
            int lineEndOffset = promptEditor.getDocument().getLineEndOffset(promptLine);
            if (lineEndOffset - lineStartOffset < terminalColumns - textColumns) {
                Graphics g2 = g.create();
                try {
                    Intrinsics.checkNotNull((Object)g2);
                    this.doPaint(g2, (int)textX, targetRegion.y, (int)Math.ceil(textWidth), promptEditor.getLineHeight());
                }
                finally {
                    g2.dispose();
                }
            }
        }

        private final void doPaint(Graphics g, int x, int y, int width, int height) {
            g.translate(x, y);
            g.clipRect(0, 0, width, height);
            this.inlayEditor.getContentComponent().paint(g);
        }
    }
}

