/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jna;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.sun.jna.Native;
import org.jetbrains.annotations.NotNull;

public final class JnaLoader {
    private static Boolean ourJnaLoaded = null;

    public static synchronized void load(@NotNull Logger logger) {
        if (logger == null) {
            JnaLoader.$$$reportNull$$$0(0);
        }
        if (ourJnaLoaded == null) {
            String winDir;
            ourJnaLoaded = Boolean.FALSE;
            if (OS.CURRENT == OS.Windows && Boolean.getBoolean("ide.native.launcher") && (winDir = System.getenv("SystemRoot")) != null) {
                String path = System.getProperty("jna.platform.library.path");
                path = (path == null ? "" : path + ';') + winDir + "\\System32";
                System.setProperty("jna.platform.library.path", path);
            }
            try {
                long t2 = System.currentTimeMillis();
                int ptrSize = Native.POINTER_SIZE;
                t2 = System.currentTimeMillis() - t2;
                logger.info("JNA library (" + (ptrSize << 3) + "-bit) loaded in " + t2 + " ms");
                ourJnaLoaded = Boolean.TRUE;
            }
            catch (Throwable t3) {
                logger.warn("Unable to load JNA library (os=" + SystemInfoRt.OS_NAME + " " + SystemInfoRt.OS_VERSION + ", jna.boot.library.path=" + System.getProperty("jna.boot.library.path") + ")", t3);
            }
        }
    }

    public static synchronized boolean isLoaded() {
        if (ourJnaLoaded == null) {
            JnaLoader.load(Logger.getInstance(JnaLoader.class));
        }
        return ourJnaLoaded;
    }

    public static boolean isSupportsDirectMapping() {
        return !SystemInfoRt.isMac || !CpuArch.isArm64();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/jna/JnaLoader", "load"));
    }
}

