/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FileSetLimiter {
    private static final Logger LOG = Logger.getInstance(FileSetLimiter.class);
    public static final int DEFAULT_FILES_TO_KEEP = 10;
    public static final String DEFAULT_DATETIME_FORMAT = "{0, date, yyyy-MM-dd-HH-mm-ss}";
    public static final Consumer<Collection<? extends Path>> DELETE_IMMEDIATELY = paths -> {
        for (Path path : paths) {
            File file2 = path.toFile();
            if (FileUtilRt.deleteFile((File)file2)) continue;
            file2.deleteOnExit();
            LOG.info("Can't delete " + path + " (scheduled for delete on exit)");
        }
    };
    public static final Consumer<Collection<? extends Path>> DELETE_ON_JVM_EXIT = paths -> {
        for (Path path : paths) {
            path.toFile().deleteOnExit();
        }
    };
    public static final Consumer<Collection<? extends Path>> DELETE_ASYNC = paths -> {
        if (!paths.isEmpty()) {
            ExecutorsKt.asExecutor(Dispatchers.getIO()).execute(() -> {
                Thread currentThread = Thread.currentThread();
                int priority = currentThread.getPriority();
                currentThread.setPriority(1);
                try {
                    DELETE_IMMEDIATELY.accept((Collection<? extends Path>)paths);
                }
                finally {
                    currentThread.setPriority(priority);
                }
            });
        }
    };
    @NotNull
    private final Path directory;
    @NotNull
    private final MessageFormat fileNameFormat;
    private final int maxFilesToKeep;
    private final Consumer<Collection<? extends Path>> filesDeleter;

    private FileSetLimiter(@NotNull Path directory, @NotNull MessageFormat fileNameFormat, int maxFilesToKeep, @NotNull Consumer<Collection<? extends Path>> deleter) {
        if (directory == null) {
            FileSetLimiter.$$$reportNull$$$0(0);
        }
        if (fileNameFormat == null) {
            FileSetLimiter.$$$reportNull$$$0(1);
        }
        if (deleter == null) {
            FileSetLimiter.$$$reportNull$$$0(2);
        }
        this.filesDeleter = deleter;
        if (maxFilesToKeep <= 1) {
            throw new IllegalArgumentException("maxFilesToKeep(=" + maxFilesToKeep + ") should be >=1");
        }
        this.directory = directory;
        this.fileNameFormat = fileNameFormat;
        this.maxFilesToKeep = maxFilesToKeep;
    }

    public static FileSetLimiter inDirectory(Path directory) {
        return new FileSetLimiter(directory, new MessageFormat(DEFAULT_DATETIME_FORMAT), 10, DELETE_IMMEDIATELY);
    }

    public FileSetLimiter withFileNameFormat(@NotNull String fileNameFormat) {
        if (fileNameFormat == null) {
            FileSetLimiter.$$$reportNull$$$0(3);
        }
        return this.withFileNameFormat(new MessageFormat(fileNameFormat));
    }

    public FileSetLimiter withFileNameFormat(@NotNull MessageFormat fileNameFormat) {
        if (fileNameFormat == null) {
            FileSetLimiter.$$$reportNull$$$0(4);
        }
        return new FileSetLimiter(this.directory, fileNameFormat, this.maxFilesToKeep, this.filesDeleter);
    }

    public FileSetLimiter withBaseNameAndDateFormatSuffix(@NotNull String baseFileName, @NotNull String suffixDateFormat) {
        if (baseFileName == null) {
            FileSetLimiter.$$$reportNull$$$0(5);
        }
        if (suffixDateFormat == null) {
            FileSetLimiter.$$$reportNull$$$0(6);
        }
        return this.withFileNameFormat(FileSetLimiter.fileNameFormatFromBaseFileNameAndDateFormat(baseFileName, suffixDateFormat));
    }

    public FileSetLimiter withMaxFilesToKeep(int maxFilesToKeep) {
        return this.withMaxFilesToKeep(maxFilesToKeep, this.filesDeleter);
    }

    public FileSetLimiter withMaxFilesToKeep(int maxFilesToKeep, Consumer<Collection<? extends Path>> excessiveFilesDeleter) {
        return new FileSetLimiter(this.directory, this.fileNameFormat, maxFilesToKeep, excessiveFilesDeleter);
    }

    public FileSetLimiter removeOldFilesBut(int maxFilesToKeep) throws IOException {
        return this.withMaxFilesToKeep(maxFilesToKeep, this.filesDeleter).removeOlderFiles();
    }

    public FileSetLimiter removeOldFilesBut(int maxFilesToKeep, Consumer<Collection<? extends Path>> excessiveFilesDeleter) throws IOException {
        return this.withMaxFilesToKeep(maxFilesToKeep, excessiveFilesDeleter).removeOlderFiles();
    }

    public FileSetLimiter removeOlderFiles() throws IOException {
        if (!Files.exists(this.directory, new LinkOption[0]) || !Files.isDirectory(this.directory, new LinkOption[0])) {
            return this;
        }
        try (Stream<Path> children2 = Files.list(this.directory);){
            Comparator<Pair> byDateOfCreation = Comparator.comparing(pair -> (Date)pair.second);
            List excessiveFilesToRemove = children2.map(this::tryParsePath).filter(pair -> pair.second != null).sorted(byDateOfCreation.reversed()).skip(this.maxFilesToKeep).map(pair -> (Path)pair.first).collect(Collectors.toList());
            this.filesDeleter.accept(excessiveFilesToRemove);
        }
        return this;
    }

    public Path createNewFile() throws IOException {
        return this.createNewFile(Clock.systemDefaultZone());
    }

    public Path createNewFile(@NotNull Clock clock) throws IOException {
        if (clock == null) {
            FileSetLimiter.$$$reportNull$$$0(7);
        }
        int maxTries = 1024;
        try {
            Path basePath;
            Path candidatePath = basePath = this.generatePath(clock);
            for (int tryNo = 0; tryNo < 1024; ++tryNo) {
                try {
                    Path createdPath;
                    if (Files.exists(candidatePath, new LinkOption[0])) {
                        String numeratedFileName = basePath.getFileName() + "." + tryNo;
                        candidatePath = basePath.resolveSibling(numeratedFileName);
                    }
                    Path path = createdPath = Files.createFile(candidatePath, new FileAttribute[0]);
                    return path;
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    continue;
                }
            }
            throw new IOException("Can't create new file like " + basePath + ".X in X=[0.." + 1024 + ") attempts");
        }
        finally {
            this.removeOlderFiles();
        }
    }

    public Path generatePath() throws IOException {
        return this.generatePath(Clock.systemDefaultZone());
    }

    public Path generatePath(@NotNull Clock clock) throws IOException {
        if (clock == null) {
            FileSetLimiter.$$$reportNull$$$0(8);
        }
        if (!Files.isDirectory(this.directory, new LinkOption[0])) {
            Files.createDirectories(this.directory, new FileAttribute[0]);
        }
        this.removeOlderFiles();
        String fileName = this.fileNameFormat.format(new Object[]{clock.millis()});
        return this.directory.resolve(fileName);
    }

    public List<Path> listExistentFiles() throws IOException {
        if (!Files.isDirectory(this.directory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (DirectoryStream<Path> children2 = Files.newDirectoryStream(this.directory);){
            ArrayList<Path> list = new ArrayList<Path>();
            for (Path child : children2) {
                Pair<Path, Date> pair = this.tryParsePath(child);
                if (pair.second == null) continue;
                list.add((Path)pair.first);
            }
            ArrayList<Path> arrayList = list;
            return arrayList;
        }
    }

    public Optional<Path> mostRecentFile() throws IOException {
        if (!Files.exists(this.directory, new LinkOption[0]) || !Files.isDirectory(this.directory, new LinkOption[0])) {
            return Optional.empty();
        }
        Comparator<Pair> byDateOfCreation = Comparator.comparing(pair -> (Date)pair.second);
        try (Stream<Path> children2 = Files.list(this.directory);){
            Optional<Path> optional = children2.map(this::tryParsePath).filter(pair -> pair.second != null).max(byDateOfCreation).map(pair -> (Path)pair.first);
            return optional;
        }
    }

    @NotNull
    private static String fileNameFormatFromBaseFileNameAndDateFormat(@NotNull String baseFileName, @NotNull String dateFormat) {
        if (baseFileName == null) {
            FileSetLimiter.$$$reportNull$$$0(9);
        }
        if (dateFormat == null) {
            FileSetLimiter.$$$reportNull$$$0(10);
        }
        String extension = FileUtilRt.getExtension((String)baseFileName);
        String unzippedExtension = "";
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)baseFileName);
        if (extension.equals("gz")) {
            unzippedExtension = FileUtilRt.getExtension((String)nameWithoutExtension) + ".";
            nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)nameWithoutExtension);
        }
        String string2 = extension.isEmpty() ? nameWithoutExtension + ".{0,date," + dateFormat + "}" : nameWithoutExtension + ".{0,date," + dateFormat + "}." + unzippedExtension + extension;
        if (string2 == null) {
            FileSetLimiter.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    private Pair<Path, Date> tryParsePath(Path path) {
        String fileName = this.directory.relativize(path).toString();
        try {
            Object[] results = this.fileNameFormat.parse(fileName);
            Date fileCreatedAt = (Date)results[0];
            return new Pair((Object)path, (Object)fileCreatedAt);
        }
        catch (ParseException e2) {
            return new Pair((Object)path, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFormat";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleter";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffixDateFormat";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clock";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dateFormat";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/FileSetLimiter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/FileSetLimiter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fileNameFormatFromBaseFileNameAndDateFormat";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withFileNameFormat";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withBaseNameAndDateFormatSuffix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNewFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generatePath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fileNameFormatFromBaseFileNameAndDateFormat";
                break;
            }
            case 11: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class FileRecord {
        @NotNull
        public final Path path;
        @Nullable
        public final Date date;
        public final int subMillisecondId;

        public FileRecord(@NotNull Path path, @Nullable Date date, int subMillisecondId) {
            if (path == null) {
                FileRecord.$$$reportNull$$$0(0);
            }
            this.path = path;
            this.date = date;
            this.subMillisecondId = subMillisecondId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileSetLimiter$FileRecord", "<init>"));
        }
    }
}

