/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;

public final class CodeWriter
extends PrintWriter {
    private final int myIndent;
    private int myIndentLevel = 0;
    private boolean myNewLineStarted = true;

    public CodeWriter(PrintWriter writer) {
        super(writer);
        this.myIndent = 2;
    }

    @Override
    public void print(@NonNls String s2) {
        this.possiblyIndent(s2);
        super.print(s2);
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (CodeWriter.isOpenBrace(s2, i2)) {
                ++this.myIndentLevel;
            }
            if (!CodeWriter.isCloseBrace(s2, i2)) continue;
            --this.myIndentLevel;
        }
    }

    private static boolean isCloseBrace(String s2, int index) {
        char c2 = s2.charAt(index);
        return c2 == ')' || c2 == ']' || c2 == '}';
    }

    private static boolean isOpenBrace(String s2, int index) {
        char c2 = s2.charAt(index);
        return c2 == '(' || c2 == '[' || c2 == '{';
    }

    @Override
    public void println() {
        ((PrintWriter)this.out).println();
        this.myNewLineStarted = true;
    }

    private void possiblyIndent(String s2) {
        if (this.myNewLineStarted) {
            int firstNonBlank;
            int i2;
            for (i2 = 0; i2 < s2.length() && s2.charAt(i2) == ' '; ++i2) {
            }
            int n2 = firstNonBlank = i2 < s2.length() && s2.charAt(i2) != ' ' ? i2 : -1;
            if (firstNonBlank >= 0) {
                if (CodeWriter.isCloseBrace(s2, firstNonBlank)) {
                    --this.myIndentLevel;
                }
                int blanksToPrint = this.myIndent * this.myIndentLevel - firstNonBlank;
                for (int j2 = 0; j2 < blanksToPrint; ++j2) {
                    this.write(" ");
                }
                if (CodeWriter.isCloseBrace(s2, firstNonBlank)) {
                    ++this.myIndentLevel;
                }
            }
            this.myNewLineStarted = false;
        }
    }

    @Override
    public void println(String s2) {
        StringTokenizer st = new StringTokenizer(s2, "\r\n", false);
        while (st.hasMoreTokens()) {
            super.println(st.nextToken());
        }
    }
}

