/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSpliterator;
import it.unimi.dsi.fastutil.ints.Y;
import it.unimi.dsi.fastutil.ints.q;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;

public class IntOpenHashSet
extends AbstractIntSet
implements Hash,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    protected transient int[] key;
    protected transient int mask;
    protected transient boolean containsNull;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(int expected, float f2) {
        void var2_2;
        void var1_1;
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        IntOpenHashSet intOpenHashSet = this;
        intOpenHashSet.minN = intOpenHashSet.n = HashCommon.arraySize((int)var1_1, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, (float)var2_2);
        this.key = new int[this.n + 1];
    }

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(int expected) {
        this((int)var1_1, 0.75f);
        void var1_1;
    }

    public IntOpenHashSet() {
        this(16, 0.75f);
    }

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(Collection<? extends Integer> c2, float f2) {
        this(c2.size(), (float)var2_2);
        void var1_1;
        void var2_2;
        ((q)this).addAll((Collection<? extends Integer>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(Collection<? extends Integer> c2) {
        this((Collection<? extends Integer>)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(IntCollection c2, float f2) {
        this(c2.size(), (float)var2_2);
        void var1_1;
        void var2_2;
        ((q)this).addAll((IntCollection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(IntCollection c2) {
        this((IntCollection)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(IntIterator i2, float f2) {
        this(16, (float)var2_2);
        void var2_2;
        while (i2.hasNext()) {
            ((q)this).add(i2.nextInt());
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(IntIterator i2) {
        this((IntIterator)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(Iterator<?> i2, float f2) {
        this(IntIterators.asIntIterator((Iterator)var1_1), (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(Iterator<?> i2) {
        this(IntIterators.asIntIterator((Iterator)var1_1));
        void var1_1;
    }

    public IntOpenHashSet(int[] a2, int offset, int length, float f2) {
        this(length < 0 ? 0 : length, f2);
        IntArrays.ensureOffsetLength(a2, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            ((q)this).add(a2[offset + i2]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(int[] a2, int offset, int length) {
        this((int[])var1_1, (int)var2_2, (int)var3_3, 0.75f);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(int[] a2, float f2) {
        this(a2, 0, ((void)var1_1).length, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntOpenHashSet(int[] a2) {
        this((int[])var1_1, 0.75f);
        void var1_1;
    }

    public static IntOpenHashSet of() {
        return new IntOpenHashSet();
    }

    public static IntOpenHashSet of(int e2) {
        int n2;
        IntOpenHashSet intOpenHashSet = new IntOpenHashSet(1, 0.75f);
        ((q)intOpenHashSet).add(n2);
        return intOpenHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public static IntOpenHashSet of(int e0, int e1) {
        int n2;
        IntOpenHashSet intOpenHashSet = new IntOpenHashSet(2, 0.75f);
        ((q)intOpenHashSet).add(n2);
        if (!((q)intOpenHashSet).add(e1)) {
            void var1_1;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf((int)var1_1)));
        }
        return intOpenHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public static IntOpenHashSet of(int e0, int e1, int e2) {
        int n2;
        IntOpenHashSet intOpenHashSet = new IntOpenHashSet(3, 0.75f);
        ((q)intOpenHashSet).add(n2);
        if (!((q)intOpenHashSet).add(e1)) {
            void var1_1;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf((int)var1_1)));
        }
        if (!((q)intOpenHashSet).add(e2)) {
            void var2_2;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf((int)var2_2)));
        }
        return intOpenHashSet;
    }

    public static IntOpenHashSet of(int ... a2) {
        int[] nArray;
        IntOpenHashSet intOpenHashSet = new IntOpenHashSet(a2.length, 0.75f);
        for (int n2 : nArray) {
            if (((q)intOpenHashSet).add(n2)) continue;
            throw new IllegalArgumentException("Duplicate element ".concat(String.valueOf(n2)));
        }
        return intOpenHashSet;
    }

    public static IntOpenHashSet toSet(IntStream stream) {
        return stream.collect(IntOpenHashSet::new, IntOpenHashSet::add, IntOpenHashSet::addAll);
    }

    /*
     * WARNING - void declaration
     */
    public static IntOpenHashSet toSetWithExpectedSize(IntStream stream, int expectedSize) {
        void var1_1;
        IntStream intStream;
        if (expectedSize <= 16) {
            return IntOpenHashSet.toSet(stream);
        }
        return intStream.collect(new Y.b<IntOpenHashSet>((int)var1_1, n2 -> {
            if (n2 <= 16) {
                return new IntOpenHashSet();
            }
            return new IntOpenHashSet(n2);
        }), IntOpenHashSet::add, IntOpenHashSet::addAll);
    }

    private int a() {
        if (this.containsNull) {
            return this.size - 1;
        }
        return this.size;
    }

    public void ensureCapacity(int capacity) {
        int n2 = HashCommon.arraySize(capacity, this.f);
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private void a(long l2) {
        int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / this.f))));
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(IntCollection c2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            IntOpenHashSet intOpenHashSet = this;
            intOpenHashSet.a((long)(intOpenHashSet.size() + c2.size()));
        }
        return super.addAll((IntCollection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends Integer> c2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            IntOpenHashSet intOpenHashSet = this;
            intOpenHashSet.a((long)(intOpenHashSet.size() + c2.size()));
        }
        return super.addAll((Collection<? extends Integer>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(int k2) {
        if (k2 == 0) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            void var1_1;
            int[] nArray = this.key;
            int n2 = HashCommon.mix(k2) & this.mask;
            int n3 = this.key[n2];
            if (n3 != 0) {
                if (n3 == k2) {
                    return false;
                }
                while ((n3 = nArray[n2 = n2 + 1 & this.mask]) != 0) {
                    if (n3 != k2) continue;
                    return false;
                }
            }
            nArray[n2] = var1_1;
        }
        if (this.size++ >= this.maxFill) {
            IntOpenHashSet intOpenHashSet = this;
            intOpenHashSet.rehash(HashCommon.arraySize(intOpenHashSet.size + 1, this.f));
        }
        return true;
    }

    private boolean a(int n2) {
        --this.size;
        int n3 = n2;
        IntOpenHashSet intOpenHashSet = this;
        int[] nArray = intOpenHashSet.key;
        block0: while (true) {
            int n4;
            int n5 = n3;
            n3 = n5 + 1 & intOpenHashSet.mask;
            while (true) {
                if ((n4 = nArray[n3]) == 0) break block0;
                int n6 = HashCommon.mix(n4) & intOpenHashSet.mask;
                if (n5 > n3 ? n5 >= n6 && n6 > n3 : n5 >= n6 || n6 > n3) break;
                n3 = n3 + 1 & intOpenHashSet.mask;
            }
            nArray[n5] = n4;
        }
        nArray[n5] = 0;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            IntOpenHashSet intOpenHashSet2 = this;
            intOpenHashSet2.rehash(intOpenHashSet2.n / 2);
        }
        return true;
    }

    @Override
    public boolean remove(int k222) {
        int k222;
        if (k222 == 0) {
            if (this.containsNull) {
                IntOpenHashSet k222 = this;
                this.containsNull = false;
                k222.key[k222.n] = 0;
                --k222.size;
                if (k222.n > k222.minN && k222.size < k222.maxFill / 4 && k222.n > 16) {
                    IntOpenHashSet intOpenHashSet = k222;
                    intOpenHashSet.rehash(intOpenHashSet.n / 2);
                }
                return true;
            }
            return false;
        }
        int[] nArray = this.key;
        int n2 = HashCommon.mix(k222) & this.mask;
        int n3 = this.key[n2];
        if (n3 == 0) {
            return false;
        }
        if (k222 == n3) {
            return this.a(n2);
        }
        do {
            if ((n3 = nArray[n2 = n2 + 1 & this.mask]) != 0) continue;
            return false;
        } while (k222 != n3);
        return this.a(n2);
    }

    @Override
    public boolean contains(int k2) {
        if (k2 == 0) {
            return this.containsNull;
        }
        int[] nArray = this.key;
        int n2 = HashCommon.mix(k2) & this.mask;
        int n3 = this.key[n2];
        if (n3 == 0) {
            return false;
        }
        if (k2 == n3) {
            return true;
        }
        do {
            if ((n3 = nArray[n2 = n2 + 1 & this.mask]) != 0) continue;
            return false;
        } while (k2 != n3);
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.key, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public IntIterator iterator() {
        return new a(this, 0);
    }

    @Override
    public IntSpliterator spliterator() {
        return new b(this);
    }

    @Override
    public void forEach(IntConsumer action) {
        if (this.containsNull) {
            action.accept(this.key[this.n]);
        }
        int[] nArray = this.key;
        int n2 = this.n;
        while (n2-- != 0) {
            if (nArray[n2] == 0) continue;
            action.accept(nArray[n2]);
        }
    }

    public boolean trim() {
        IntOpenHashSet intOpenHashSet = this;
        return intOpenHashSet.trim(intOpenHashSet.size);
    }

    public boolean trim(int n2) {
        int n3 = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (n3 >= this.n || this.size > HashCommon.maxFill(n3, this.f)) {
            return true;
        }
        try {
            this.rehash(n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newN) {
        void var1_1;
        int[] nArray = this.key;
        int n2 = newN - 1;
        int[] nArray2 = new int[newN + 1];
        int n3 = this.n;
        int n4 = this.a();
        while (n4-- != 0) {
            while (nArray[--n3] == 0) {
            }
            int n5 = HashCommon.mix(nArray[n3]) & n2;
            if (nArray2[n5] != 0) {
                while (nArray2[n5 = n5 + 1 & n2] != 0) {
                }
            }
            nArray2[n5] = nArray[n3];
        }
        this.n = var1_1;
        this.mask = n2;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = nArray2;
    }

    public IntOpenHashSet clone() {
        IntOpenHashSet intOpenHashSet;
        try {
            intOpenHashSet = (IntOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        intOpenHashSet.key = (int[])this.key.clone();
        intOpenHashSet.containsNull = this.containsNull;
        return intOpenHashSet;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.a();
        int n4 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == 0) {
                ++n4;
            }
            n2 += this.key[n4];
            ++n4;
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        IntIterator intIterator = ((q)this).iterator();
        s2.defaultWriteObject();
        int n2 = this.size;
        while (n2-- != 0) {
            s2.writeInt(intIterator.nextInt());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new int[this.n + 1];
        int[] nArray = this.key;
        int n2 = this.size;
        while (n2-- != 0) {
            int n3;
            int n4 = s2.readInt();
            if (n4 == 0) {
                n3 = this.n;
                this.containsNull = true;
            } else {
                n3 = HashCommon.mix(n4) & this.mask;
                if (nArray[n3] != 0) {
                    while (nArray[n3 = n3 + 1 & this.mask] != 0) {
                    }
                }
            }
            nArray[n3] = n4;
        }
    }

    private final class a
    implements IntIterator {
        private int a;
        private int b;
        private int c;
        private boolean d;
        private IntArrayList e;
        private /* synthetic */ IntOpenHashSet f;

        private a(IntOpenHashSet intOpenHashSet) {
            this.f = intOpenHashSet;
            this.a = this.f.n;
            this.b = -1;
            this.c = this.f.size;
            this.d = this.f.containsNull;
        }

        @Override
        public final boolean hasNext() {
            return this.c != 0;
        }

        @Override
        public final int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.d) {
                this.d = false;
                this.b = this.f.n;
                return this.f.key[this.f.n];
            }
            int[] nArray = this.f.key;
            do {
                if (--this.a >= 0) continue;
                this.b = Integer.MIN_VALUE;
                return this.e.getInt(-this.a - 1);
            } while (nArray[this.a] == 0);
            this.b = this.a;
            return nArray[this.b];
        }

        @Override
        public final void remove() {
            block9: {
                if (this.b == -1) {
                    throw new IllegalStateException();
                }
                if (this.b == this.f.n) {
                    this.f.containsNull = false;
                    this.f.key[this.f.n] = 0;
                } else {
                    if (this.a >= 0) {
                        a a2 = this;
                        int n2 = a2.b;
                        a a3 = a2;
                        int[] nArray = a2.f.key;
                        while (true) {
                            int n3;
                            int n4 = n2;
                            n2 = n4 + 1 & a3.f.mask;
                            while (true) {
                                if ((n3 = nArray[n2]) == 0) {
                                    nArray[n4] = 0;
                                    break block9;
                                }
                                int n5 = HashCommon.mix(n3) & a3.f.mask;
                                if (n4 > n2 ? n4 >= n5 && n5 > n2 : n4 >= n5 || n5 > n2) break;
                                n2 = n2 + 1 & a3.f.mask;
                            }
                            if (n2 < n4) {
                                if (a3.e == null) {
                                    a3.e = new IntArrayList(2);
                                }
                                ((q)a3.e).add(nArray[n2]);
                            }
                            nArray[n4] = n3;
                        }
                    }
                    ((AbstractIntSet)this.f).remove(this.e.getInt(-this.a - 1));
                    this.b = -1;
                    return;
                }
            }
            --this.f.size;
            this.b = -1;
        }

        @Override
        public final void forEachRemaining(IntConsumer action) {
            int[] nArray = this.f.key;
            if (this.d) {
                this.d = false;
                this.b = this.f.n;
                action.accept(nArray[this.f.n]);
                --this.c;
            }
            while (this.c != 0) {
                if (--this.a < 0) {
                    this.b = Integer.MIN_VALUE;
                    action.accept(this.e.getInt(-this.a - 1));
                    --this.c;
                    continue;
                }
                if (nArray[this.a] == 0) continue;
                this.b = this.a;
                action.accept(nArray[this.b]);
                --this.c;
            }
        }

        /* synthetic */ a(IntOpenHashSet intOpenHashSet, byte by) {
            this(intOpenHashSet);
        }
    }

    private final class b
    implements IntSpliterator {
        private int a = 0;
        private int b;
        private int c;
        private boolean d;
        private boolean e;
        private /* synthetic */ IntOpenHashSet f;

        b(IntOpenHashSet intOpenHashSet) {
            this.f = intOpenHashSet;
            this.b = this.f.n;
            this.c = 0;
            this.d = this.f.containsNull;
            this.e = false;
        }

        private b(IntOpenHashSet intOpenHashSet, int n2, int n3, boolean bl2) {
            this.f = intOpenHashSet;
            this.b = this.f.n;
            this.c = 0;
            this.d = this.f.containsNull;
            this.e = false;
            this.a = n2;
            this.b = n3;
            this.d = bl2;
            this.e = true;
        }

        @Override
        public final boolean tryAdvance(IntConsumer action) {
            if (this.d) {
                this.d = false;
                ++this.c;
                action.accept(this.f.key[this.f.n]);
                return true;
            }
            int[] nArray = this.f.key;
            while (this.a < this.b) {
                if (nArray[this.a] != 0) {
                    ++this.c;
                    action.accept(nArray[this.a++]);
                    return true;
                }
                ++this.a;
            }
            return false;
        }

        @Override
        public final void forEachRemaining(IntConsumer action) {
            int[] nArray = this.f.key;
            if (this.d) {
                this.d = false;
                action.accept(nArray[this.f.n]);
                ++this.c;
            }
            while (this.a < this.b) {
                if (nArray[this.a] != 0) {
                    action.accept(nArray[this.a]);
                    ++this.c;
                }
                ++this.a;
            }
        }

        @Override
        public final int characteristics() {
            if (this.e) {
                return 257;
            }
            return 321;
        }

        @Override
        public final long estimateSize() {
            if (!this.e) {
                return this.f.size - this.c;
            }
            return Math.min((long)(this.f.size - this.c), (long)((double)this.f.a() / (double)this.f.n * (double)(this.b - this.a)) + (long)(this.d ? 1 : 0));
        }

        private b c() {
            if (this.a >= this.b - 1) {
                return null;
            }
            int n2 = this.b - this.a >> 1;
            if (n2 <= 1) {
                return null;
            }
            n2 = this.a + n2;
            int n3 = this.a;
            int n4 = n2;
            b b2 = new b(this.f, n3, n4, this.d);
            this.a = n2;
            this.d = false;
            this.e = true;
            return b2;
        }

        @Override
        public final /* synthetic */ IntSpliterator m_() {
            return this.c();
        }

        @Override
        public final /* synthetic */ Spliterator.OfInt trySplit() {
            return this.c();
        }

        @Override
        public final /* synthetic */ Spliterator.OfPrimitive trySplit() {
            return this.c();
        }

        @Override
        public final /* synthetic */ Spliterator trySplit() {
            return this.c();
        }
    }
}

