/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.CharEncoding;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;

public class Hex
implements BinaryEncoder,
BinaryDecoder {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String DEFAULT_CHARSET_NAME = CharEncoding.UTF_8;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Charset charset;

    public static byte[] decodeHex(char[] data2) throws DecoderException {
        byte[] out = new byte[data2.length >> 1];
        Hex.decodeHex(data2, out, 0);
        return out;
    }

    public static int decodeHex(char[] data2, byte[] out, int outOffset) throws DecoderException {
        int len = data2.length;
        if ((len & 1) != 0) {
            throw new DecoderException("Odd number of characters.");
        }
        int outLen = len >> 1;
        if (out.length - outOffset < outLen) {
            throw new DecoderException("Output array is not large enough to accommodate decoded data.");
        }
        int i2 = outOffset;
        int j2 = 0;
        while (j2 < len) {
            int f2 = Hex.toDigit(data2[j2], j2) << 4;
            f2 |= Hex.toDigit(data2[++j2], j2);
            ++j2;
            out[i2] = (byte)(f2 & 0xFF);
            ++i2;
        }
        return outLen;
    }

    public static byte[] decodeHex(String data2) throws DecoderException {
        return Hex.decodeHex(data2.toCharArray());
    }

    public static char[] encodeHex(byte[] data2) {
        return Hex.encodeHex(data2, true);
    }

    public static char[] encodeHex(byte[] data2, boolean toLowerCase) {
        return Hex.encodeHex(data2, Hex.toAlphabet(toLowerCase));
    }

    protected static char[] encodeHex(byte[] data2, char[] toDigits) {
        int dataLength = data2.length;
        return Hex.encodeHex(data2, 0, dataLength, toDigits, new char[dataLength << 1], 0);
    }

    public static char[] encodeHex(byte[] data2, int dataOffset, int dataLen, boolean toLowerCase) {
        return Hex.encodeHex(data2, dataOffset, dataLen, Hex.toAlphabet(toLowerCase), new char[dataLen << 1], 0);
    }

    public static void encodeHex(byte[] data2, int dataOffset, int dataLen, boolean toLowerCase, char[] out, int outOffset) {
        Hex.encodeHex(data2, dataOffset, dataLen, Hex.toAlphabet(toLowerCase), out, outOffset);
    }

    private static char[] encodeHex(byte[] data2, int dataOffset, int dataLen, char[] toDigits, char[] out, int outOffset) {
        int j2 = outOffset;
        for (int i2 = dataOffset; i2 < dataOffset + dataLen; ++i2) {
            out[j2++] = toDigits[(0xF0 & data2[i2]) >>> 4];
            out[j2++] = toDigits[0xF & data2[i2]];
        }
        return out;
    }

    public static char[] encodeHex(ByteBuffer data2) {
        return Hex.encodeHex(data2, true);
    }

    public static char[] encodeHex(ByteBuffer data2, boolean toLowerCase) {
        return Hex.encodeHex(data2, Hex.toAlphabet(toLowerCase));
    }

    protected static char[] encodeHex(ByteBuffer byteBuffer, char[] toDigits) {
        return Hex.encodeHex(Hex.toByteArray(byteBuffer), toDigits);
    }

    public static String encodeHexString(byte[] data2) {
        return new String(Hex.encodeHex(data2));
    }

    public static String encodeHexString(byte[] data2, boolean toLowerCase) {
        return new String(Hex.encodeHex(data2, toLowerCase));
    }

    public static String encodeHexString(ByteBuffer data2) {
        return new String(Hex.encodeHex(data2));
    }

    public static String encodeHexString(ByteBuffer data2, boolean toLowerCase) {
        return new String(Hex.encodeHex(data2, toLowerCase));
    }

    private static char[] toAlphabet(boolean toLowerCase) {
        return toLowerCase ? DIGITS_LOWER : DIGITS_UPPER;
    }

    private static byte[] toByteArray(ByteBuffer byteBuffer) {
        byte[] byteArray;
        int remaining = byteBuffer.remaining();
        if (byteBuffer.hasArray() && remaining == (byteArray = byteBuffer.array()).length) {
            byteBuffer.position(remaining);
            return byteArray;
        }
        byteArray = new byte[remaining];
        byteBuffer.get(byteArray);
        return byteArray;
    }

    protected static int toDigit(char ch, int index) throws DecoderException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new DecoderException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public Hex() {
        this.charset = DEFAULT_CHARSET;
    }

    public Hex(Charset charset) {
        this.charset = charset;
    }

    public Hex(String charsetName) {
        this(Charset.forName(charsetName));
    }

    @Override
    public byte[] decode(byte[] array) throws DecoderException {
        return Hex.decodeHex(new String(array, this.getCharset()).toCharArray());
    }

    public byte[] decode(ByteBuffer buffer) throws DecoderException {
        return Hex.decodeHex(new String(Hex.toByteArray(buffer), this.getCharset()).toCharArray());
    }

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object instanceof String) {
            return this.decode(((String)object).toCharArray());
        }
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof ByteBuffer) {
            return this.decode((ByteBuffer)object);
        }
        try {
            return Hex.decodeHex((char[])object);
        }
        catch (ClassCastException e2) {
            throw new DecoderException(e2.getMessage(), e2);
        }
    }

    @Override
    public byte[] encode(byte[] array) {
        return Hex.encodeHexString(array).getBytes(this.getCharset());
    }

    public byte[] encode(ByteBuffer array) {
        return Hex.encodeHexString(array).getBytes(this.getCharset());
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        byte[] byteArray;
        if (object instanceof String) {
            byteArray = ((String)object).getBytes(this.getCharset());
        } else if (object instanceof ByteBuffer) {
            byteArray = Hex.toByteArray((ByteBuffer)object);
        } else {
            try {
                byteArray = (byte[])object;
            }
            catch (ClassCastException e2) {
                throw new EncoderException(e2.getMessage(), e2);
            }
        }
        return Hex.encodeHex(byteArray);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getCharsetName() {
        return this.charset.name();
    }

    public String toString() {
        return super.toString() + "[charsetName=" + this.charset + "]";
    }
}

