/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.BitSet;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class LaxExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    static final TimeZone UTC;
    private static final BitSet DELIMS;
    private static final Map<String, Integer> MONTHS;
    private static final Pattern TIME_PATTERN;
    private static final Pattern DAY_OF_MONTH_PATTERN;
    private static final Pattern MONTH_PATTERN;
    private static final Pattern YEAR_PATTERN;

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (TextUtils.isBlank(value)) {
            return;
        }
        ParserCursor cursor = new ParserCursor(0, value.length());
        StringBuilder content = new StringBuilder();
        int second2 = 0;
        int minute = 0;
        int hour = 0;
        int day = 0;
        int month = 0;
        int year = 0;
        boolean foundTime = false;
        boolean foundDayOfMonth = false;
        boolean foundMonth = false;
        boolean foundYear = false;
        try {
            while (!cursor.atEnd()) {
                this.skipDelims(value, cursor);
                content.setLength(0);
                this.copyContent(value, cursor, content);
                if (content.length() != 0) {
                    Matcher matcher;
                    if (!foundTime && (matcher = TIME_PATTERN.matcher(content)).matches()) {
                        foundTime = true;
                        hour = Integer.parseInt(matcher.group(1));
                        minute = Integer.parseInt(matcher.group(2));
                        second2 = Integer.parseInt(matcher.group(3));
                        continue;
                    }
                    if (!foundDayOfMonth && (matcher = DAY_OF_MONTH_PATTERN.matcher(content)).matches()) {
                        foundDayOfMonth = true;
                        day = Integer.parseInt(matcher.group(1));
                        continue;
                    }
                    if (!foundMonth && (matcher = MONTH_PATTERN.matcher(content)).matches()) {
                        foundMonth = true;
                        month = MONTHS.get(matcher.group(1).toLowerCase(Locale.ROOT));
                        continue;
                    }
                    if (foundYear || !(matcher = YEAR_PATTERN.matcher(content)).matches()) continue;
                    foundYear = true;
                    year = Integer.parseInt(matcher.group(1));
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException ignore) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        if (!(foundTime && foundDayOfMonth && foundMonth && foundYear)) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        if (year >= 70 && year <= 99) {
            year = 1900 + year;
        }
        if (year >= 0 && year <= 69) {
            year = 2000 + year;
        }
        if (day < 1 || day > 31 || year < 1601 || hour > 23 || minute > 59 || second2 > 59) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        Calendar c2 = Calendar.getInstance();
        c2.setTimeZone(UTC);
        c2.setTimeInMillis(0L);
        c2.set(13, second2);
        c2.set(12, minute);
        c2.set(11, hour);
        c2.set(5, day);
        c2.set(2, month);
        c2.set(1, year);
        cookie.setExpiryDate(c2.getTime());
    }

    private void skipDelims(CharSequence buf, ParserCursor cursor) {
        char current;
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i2 = indexFrom; i2 < indexTo && DELIMS.get(current = buf.charAt(i2)); ++i2) {
            ++pos;
        }
        cursor.updatePos(pos);
    }

    private void copyContent(CharSequence buf, ParserCursor cursor, StringBuilder dst) {
        char current;
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i2 = indexFrom; i2 < indexTo && !DELIMS.get(current = buf.charAt(i2)); ++i2) {
            ++pos;
            dst.append(current);
        }
        cursor.updatePos(pos);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }

    static {
        int b2;
        UTC = TimeZone.getTimeZone("UTC");
        BitSet bitSet = new BitSet();
        bitSet.set(9);
        for (b2 = 32; b2 <= 47; ++b2) {
            bitSet.set(b2);
        }
        for (b2 = 59; b2 <= 64; ++b2) {
            bitSet.set(b2);
        }
        for (b2 = 91; b2 <= 96; ++b2) {
            bitSet.set(b2);
        }
        for (b2 = 123; b2 <= 126; ++b2) {
            bitSet.set(b2);
        }
        DELIMS = bitSet;
        ConcurrentHashMap<String, Integer> map2 = new ConcurrentHashMap<String, Integer>(12);
        map2.put("jan", 0);
        map2.put("feb", 1);
        map2.put("mar", 2);
        map2.put("apr", 3);
        map2.put("may", 4);
        map2.put("jun", 5);
        map2.put("jul", 6);
        map2.put("aug", 7);
        map2.put("sep", 8);
        map2.put("oct", 9);
        map2.put("nov", 10);
        map2.put("dec", 11);
        MONTHS = map2;
        TIME_PATTERN = Pattern.compile("^([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})([^0-9].*)?$");
        DAY_OF_MONTH_PATTERN = Pattern.compile("^([0-9]{1,2})([^0-9].*)?$");
        MONTH_PATTERN = Pattern.compile("^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)(.*)?$", 2);
        YEAR_PATTERN = Pattern.compile("^([0-9]{2,4})([^0-9].*)?$");
    }
}

