/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.versioning;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class ComparableVersion
implements Comparable<ComparableVersion> {
    private static final int MAX_INTITEM_LENGTH = 9;
    private static final int MAX_LONGITEM_LENGTH = 18;
    private String value;
    private String canonical;
    private ListItem items;

    public ComparableVersion(String version) {
        this.parseVersion(version);
    }

    public final void parseVersion(String version) {
        this.value = version;
        this.items = new ListItem();
        version = version.toLowerCase(Locale.ENGLISH);
        ListItem list = this.items;
        ArrayDeque<ListItem> stack = new ArrayDeque<ListItem>();
        stack.push(list);
        boolean isDigit = false;
        int startIndex = 0;
        for (int i2 = 0; i2 < version.length(); ++i2) {
            char c2 = version.charAt(i2);
            if (c2 == '.') {
                if (i2 == startIndex) {
                    list.add(IntItem.ZERO);
                } else {
                    list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex, i2)));
                }
                startIndex = i2 + 1;
                continue;
            }
            if (c2 == '-') {
                if (i2 == startIndex) {
                    list.add(IntItem.ZERO);
                } else {
                    list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex, i2)));
                }
                startIndex = i2 + 1;
                ListItem listItem = list;
                list = new ListItem();
                listItem.add(list);
                stack.push(list);
                continue;
            }
            if (Character.isDigit(c2)) {
                if (!isDigit && i2 > startIndex) {
                    if (!list.isEmpty()) {
                        ListItem listItem = list;
                        list = new ListItem();
                        listItem.add(list);
                        stack.push(list);
                    }
                    list.add(new StringItem(version.substring(startIndex, i2), true));
                    startIndex = i2;
                    ListItem listItem = list;
                    list = new ListItem();
                    listItem.add(list);
                    stack.push(list);
                }
                isDigit = true;
                continue;
            }
            if (isDigit && i2 > startIndex) {
                list.add(ComparableVersion.parseItem(true, version.substring(startIndex, i2)));
                startIndex = i2;
                ListItem listItem = list;
                list = new ListItem();
                listItem.add(list);
                stack.push(list);
            }
            isDigit = false;
        }
        if (version.length() > startIndex) {
            if (!isDigit && !list.isEmpty()) {
                ListItem listItem = list;
                list = new ListItem();
                listItem.add(list);
                stack.push(list);
            }
            list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex)));
        }
        while (!stack.isEmpty()) {
            list = (ListItem)stack.pop();
            list.normalize();
        }
    }

    private static Item parseItem(boolean isDigit, String buf) {
        if (isDigit) {
            if ((buf = ComparableVersion.stripLeadingZeroes(buf)).length() <= 9) {
                return new IntItem(buf);
            }
            if (buf.length() <= 18) {
                return new LongItem(buf);
            }
            return new BigIntegerItem(buf);
        }
        return new StringItem(buf, false);
    }

    private static String stripLeadingZeroes(String buf) {
        if (buf == null || buf.isEmpty()) {
            return "0";
        }
        for (int i2 = 0; i2 < buf.length(); ++i2) {
            char c2 = buf.charAt(i2);
            if (c2 == '0') continue;
            return buf.substring(i2);
        }
        return buf;
    }

    @Override
    public int compareTo(ComparableVersion o2) {
        return this.items.compareTo(o2.items);
    }

    public String toString() {
        return this.value;
    }

    public String getCanonical() {
        if (this.canonical == null) {
            this.canonical = this.items.toString();
        }
        return this.canonical;
    }

    public boolean equals(Object o2) {
        return o2 instanceof ComparableVersion && this.items.equals(((ComparableVersion)o2).items);
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    public static void main(String ... args2) {
        System.out.println("Display parameters as parsed by Maven (in canonical form and as a list of tokens) and comparison result:");
        if (args2.length == 0) {
            return;
        }
        ComparableVersion prev = null;
        int i2 = 1;
        for (String version : args2) {
            ComparableVersion c2 = new ComparableVersion(version);
            if (prev != null) {
                int compare = prev.compareTo(c2);
                System.out.println("   " + prev.toString() + ' ' + (compare == 0 ? "==" : (compare < 0 ? "<" : ">")) + ' ' + version);
            }
            System.out.println(i2++ + ". " + version + " -> " + c2.getCanonical() + "; tokens: " + c2.items.toListString());
            prev = c2;
        }
    }

    private static class ListItem
    extends ArrayList<Item>
    implements Item {
        private ListItem() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public boolean isNull() {
            return this.size() == 0;
        }

        void normalize() {
            for (int i2 = this.size() - 1; i2 >= 0; --i2) {
                Item lastItem = (Item)this.get(i2);
                if (lastItem.isNull()) {
                    this.remove(i2);
                    continue;
                }
                if (!(lastItem instanceof ListItem)) break;
            }
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                if (this.size() == 0) {
                    return 0;
                }
                for (Item i2 : this) {
                    int result2 = i2.compareTo(null);
                    if (result2 == 0) continue;
                    return result2;
                }
                return 0;
            }
            switch (item.getType()) {
                case 0: 
                case 3: 
                case 4: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    Iterator left = this.iterator();
                    Iterator right = ((ListItem)item).iterator();
                    while (left.hasNext() || right.hasNext()) {
                        Item r2;
                        Item l2 = left.hasNext() ? (Item)left.next() : null;
                        Item item2 = r2 = right.hasNext() ? (Item)right.next() : null;
                        int result3 = l2 == null ? (r2 == null ? 0 : -1 * r2.compareTo(l2)) : l2.compareTo(r2);
                        if (result3 == 0) continue;
                        return result3;
                    }
                    return 0;
                }
            }
            throw new IllegalStateException("invalid item: " + item.getClass());
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            for (Item item : this) {
                if (buffer.length() > 0) {
                    buffer.append(item instanceof ListItem ? (char)'-' : '.');
                }
                buffer.append(item);
            }
            return buffer.toString();
        }

        private String toListString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("[");
            for (Item item : this) {
                if (buffer.length() > 1) {
                    buffer.append(", ");
                }
                if (item instanceof ListItem) {
                    buffer.append(((ListItem)item).toListString());
                    continue;
                }
                buffer.append(item);
            }
            buffer.append("]");
            return buffer.toString();
        }
    }

    private static class StringItem
    implements Item {
        private static final List<String> QUALIFIERS = Arrays.asList("alpha", "beta", "milestone", "rc", "snapshot", "", "sp");
        private static final Properties ALIASES = new Properties();
        private static final String RELEASE_VERSION_INDEX;
        private final String value;

        StringItem(String value, boolean followedByDigit) {
            if (followedByDigit && value.length() == 1) {
                switch (value.charAt(0)) {
                    case 'a': {
                        value = "alpha";
                        break;
                    }
                    case 'b': {
                        value = "beta";
                        break;
                    }
                    case 'm': {
                        value = "milestone";
                        break;
                    }
                }
            }
            this.value = ALIASES.getProperty(value, value);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean isNull() {
            return StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX) == 0;
        }

        public static String comparableQualifier(String qualifier) {
            int i2 = QUALIFIERS.indexOf(qualifier);
            return i2 == -1 ? QUALIFIERS.size() + "-" + qualifier : String.valueOf(i2);
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX);
            }
            switch (item.getType()) {
                case 0: 
                case 3: 
                case 4: {
                    return -1;
                }
                case 1: {
                    return StringItem.comparableQualifier(this.value).compareTo(StringItem.comparableQualifier(((StringItem)item).value));
                }
                case 2: {
                    return -1;
                }
            }
            throw new IllegalStateException("invalid item: " + item.getClass());
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            StringItem that = (StringItem)o2;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value;
        }

        static {
            ALIASES.put("ga", "");
            ALIASES.put("final", "");
            ALIASES.put("release", "");
            ALIASES.put("cr", "rc");
            RELEASE_VERSION_INDEX = String.valueOf(QUALIFIERS.indexOf(""));
        }
    }

    private static class BigIntegerItem
    implements Item {
        private final BigInteger value;

        BigIntegerItem(String str) {
            this.value = new BigInteger(str);
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public boolean isNull() {
            return BigInteger.ZERO.equals(this.value);
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return BigInteger.ZERO.equals(this.value) ? 0 : 1;
            }
            switch (item.getType()) {
                case 3: 
                case 4: {
                    return 1;
                }
                case 0: {
                    return this.value.compareTo(((BigIntegerItem)item).value);
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
            }
            throw new IllegalStateException("invalid item: " + item.getClass());
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            BigIntegerItem that = (BigIntegerItem)o2;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static class LongItem
    implements Item {
        private final long value;

        LongItem(String str) {
            this.value = Long.parseLong(str);
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public boolean isNull() {
            return this.value == 0L;
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return this.value == 0L ? 0 : 1;
            }
            switch (item.getType()) {
                case 3: {
                    return 1;
                }
                case 4: {
                    long itemValue = ((LongItem)item).value;
                    return this.value < itemValue ? -1 : (this.value == itemValue ? 0 : 1);
                }
                case 0: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
            }
            throw new IllegalStateException("invalid item: " + item.getClass());
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            LongItem longItem = (LongItem)o2;
            return this.value == longItem.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    private static class IntItem
    implements Item {
        private final int value;
        public static final IntItem ZERO = new IntItem();

        private IntItem() {
            this.value = 0;
        }

        IntItem(String str) {
            this.value = Integer.parseInt(str);
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public boolean isNull() {
            return this.value == 0;
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return this.value == 0 ? 0 : 1;
            }
            switch (item.getType()) {
                case 3: {
                    int itemValue = ((IntItem)item).value;
                    return this.value < itemValue ? -1 : (this.value == itemValue ? 0 : 1);
                }
                case 0: 
                case 4: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
            }
            throw new IllegalStateException("invalid item: " + item.getClass());
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            IntItem intItem = (IntItem)o2;
            return this.value == intItem.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    private static interface Item {
        public static final int INT_ITEM = 3;
        public static final int LONG_ITEM = 4;
        public static final int BIGINTEGER_ITEM = 0;
        public static final int STRING_ITEM = 1;
        public static final int LIST_ITEM = 2;

        public int compareTo(Item var1);

        public int getType();

        public boolean isNull();
    }
}

