/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.StringSubstitution;

public class Perl5Substitution
extends StringSubstitution {
    public static final int INTERPOLATE_ALL = 0;
    public static final int INTERPOLATE_NONE = -1;
    private static final int __OPCODE_STORAGE_SIZE = 32;
    private static final int __MAX_GROUPS = 65535;
    static final int _OPCODE_COPY = -1;
    static final int _OPCODE_LOWERCASE_CHAR = -2;
    static final int _OPCODE_UPPERCASE_CHAR = -3;
    static final int _OPCODE_LOWERCASE_MODE = -4;
    static final int _OPCODE_UPPERCASE_MODE = -5;
    static final int _OPCODE_ENDCASE_MODE = -6;
    int _numInterpolations;
    int[] _subOpcodes;
    int _subOpcodesCount;
    char[] _substitutionChars;
    transient String _lastInterpolation;

    private static final boolean __isInterpolationCharacter(char c2) {
        return Character.isDigit(c2) || c2 == '&';
    }

    private void __addElement(int n2) {
        int n3 = this._subOpcodes.length;
        if (this._subOpcodesCount == n3) {
            int[] nArray = new int[n3 + 32];
            System.arraycopy(this._subOpcodes, 0, nArray, 0, n3);
            this._subOpcodes = nArray;
        }
        this._subOpcodes[this._subOpcodesCount++] = n2;
    }

    private void __parseSubs(String string2) {
        this._substitutionChars = string2.toCharArray();
        char[] cArray = this._substitutionChars;
        int n2 = cArray.length;
        this._subOpcodes = new int[32];
        this._subOpcodesCount = 0;
        int n3 = 0;
        int n4 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            int n5 = i2 + 1;
            if (bl2) {
                int n6 = Character.digit(c2, 10);
                if (n6 > -1) {
                    if (n3 <= 65535) {
                        n3 *= 10;
                        n3 += n6;
                    }
                    if (n5 != n2) continue;
                    this.__addElement(n3);
                    continue;
                }
                if (c2 == '&' && cArray[i2 - 1] == '$') {
                    this.__addElement(0);
                    n3 = 0;
                    bl2 = false;
                    continue;
                }
                this.__addElement(n3);
                n3 = 0;
                bl2 = false;
            }
            if (c2 != '$' && c2 != '\\' || bl3) {
                bl3 = false;
                if (n4 < 0) {
                    n4 = i2;
                    this.__addElement(-1);
                    this.__addElement(n4);
                }
                if (n5 != n2) continue;
                this.__addElement(n5 - n4);
                continue;
            }
            if (n4 >= 0) {
                this.__addElement(i2 - n4);
                n4 = -1;
            }
            if (n5 == n2) continue;
            char c3 = cArray[n5];
            if (c2 == '$') {
                bl2 = Perl5Substitution.__isInterpolationCharacter(c3);
                continue;
            }
            if (c2 != '\\') continue;
            if (c3 == 'l') {
                if (bl4) continue;
                this.__addElement(-2);
                ++i2;
                continue;
            }
            if (c3 == 'u') {
                if (bl4) continue;
                this.__addElement(-3);
                ++i2;
                continue;
            }
            if (c3 == 'L') {
                this.__addElement(-4);
                ++i2;
                bl4 = true;
                continue;
            }
            if (c3 == 'U') {
                this.__addElement(-5);
                ++i2;
                bl4 = true;
                continue;
            }
            if (c3 == 'E') {
                this.__addElement(-6);
                ++i2;
                bl4 = false;
                continue;
            }
            bl3 = true;
        }
    }

    String _finalInterpolatedSub(MatchResult matchResult) {
        StringBuffer stringBuffer = new StringBuffer(10);
        this._calcSub(stringBuffer, matchResult);
        return stringBuffer.toString();
    }

    void _calcSub(StringBuffer stringBuffer, MatchResult matchResult) {
        int[] nArray = this._subOpcodes;
        int n2 = 0;
        char[] cArray = this._substitutionChars;
        char[] cArray2 = matchResult.group(0).toCharArray();
        int n3 = this._subOpcodesCount;
        for (int i2 = 0; i2 < n3; ++i2) {
            char[] cArray3;
            int n4;
            int n5;
            int n6;
            int n7 = nArray[i2];
            if (n7 >= 0 && n7 < matchResult.groups()) {
                int n8;
                n6 = matchResult.begin(n7);
                if (n6 < 0 || (n5 = matchResult.end(n7)) < 0 || n6 >= (n8 = matchResult.length()) || n5 > n8 || n6 >= n5) continue;
                n4 = n5 - n6;
                cArray3 = cArray2;
            } else if (n7 == -1) {
                if (++i2 >= n3) continue;
                n6 = nArray[i2];
                if (++i2 >= n3) continue;
                n4 = nArray[i2];
                cArray3 = cArray;
            } else {
                if (n7 == -2 || n7 == -3) {
                    if (n2 == -4 || n2 == -5) continue;
                    n2 = n7;
                    continue;
                }
                if (n7 == -4 || n7 == -5) {
                    n2 = n7;
                    continue;
                }
                if (n7 != -6) continue;
                n2 = 0;
                continue;
            }
            if (n2 == -2) {
                stringBuffer.append(Character.toLowerCase(cArray3[n6++]));
                stringBuffer.append(cArray3, n6, --n4);
                n2 = 0;
                continue;
            }
            if (n2 == -3) {
                stringBuffer.append(Character.toUpperCase(cArray3[n6++]));
                stringBuffer.append(cArray3, n6, --n4);
                n2 = 0;
                continue;
            }
            if (n2 == -4) {
                n5 = n6 + n4;
                while (n6 < n5) {
                    stringBuffer.append(Character.toLowerCase(cArray3[n6++]));
                }
                continue;
            }
            if (n2 == -5) {
                n5 = n6 + n4;
                while (n6 < n5) {
                    stringBuffer.append(Character.toUpperCase(cArray3[n6++]));
                }
                continue;
            }
            stringBuffer.append(cArray3, n6, n4);
        }
    }

    public Perl5Substitution() {
        this("", 0);
    }

    public Perl5Substitution(String string2) {
        this(string2, 0);
    }

    public Perl5Substitution(String string2, int n2) {
        this.setSubstitution(string2, n2);
    }

    public void setSubstitution(String string2) {
        this.setSubstitution(string2, 0);
    }

    public void setSubstitution(String string2, int n2) {
        super.setSubstitution(string2);
        this._numInterpolations = n2;
        if (n2 != -1 && (string2.indexOf(36) != -1 || string2.indexOf(92) != -1)) {
            this.__parseSubs(string2);
        } else {
            this._subOpcodes = null;
        }
        this._lastInterpolation = null;
    }

    public void appendSubstitution(StringBuffer stringBuffer, MatchResult matchResult, int n2, PatternMatcherInput patternMatcherInput, PatternMatcher patternMatcher, Pattern pattern) {
        if (this._subOpcodes == null) {
            super.appendSubstitution(stringBuffer, matchResult, n2, patternMatcherInput, patternMatcher, pattern);
            return;
        }
        if (this._numInterpolations < 1 || n2 < this._numInterpolations) {
            this._calcSub(stringBuffer, matchResult);
        } else {
            if (n2 == this._numInterpolations) {
                this._lastInterpolation = this._finalInterpolatedSub(matchResult);
            }
            stringBuffer.append(this._lastInterpolation);
        }
    }
}

