/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import org.eclipse.sisu.Hidden;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.Sources;
import org.eclipse.sisu.inject.TypeArguments;

final class ImplicitBindings {
    private final Iterable<BindingPublisher> publishers;

    ImplicitBindings(Iterable<BindingPublisher> publishers) {
        this.publishers = publishers;
    }

    public <T> Binding<T> get(TypeLiteral<T> type2) {
        Key implicitKey = TypeArguments.implicitKey(type2.getRawType());
        for (BindingPublisher p2 : this.publishers) {
            Injector i2;
            Binding binding;
            if (!(p2 instanceof InjectorBindings) || (binding = (Binding)(i2 = ((InjectorBindings)p2).getInjector()).getBindings().get(implicitKey)) == null) continue;
            Logs.trace("Using implicit binding: {} from: <>", binding, i2);
            return binding;
        }
        Key justInTimeKey = Key.get(type2);
        for (BindingPublisher p3 : this.publishers) {
            if (!(p3 instanceof InjectorBindings)) continue;
            Injector i3 = ((InjectorBindings)p3).getInjector();
            try {
                Binding binding = i3.getBinding(justInTimeKey);
                if (Sources.getAnnotation(binding, Hidden.class) != null) continue;
                Logs.trace("Using just-in-time binding: {} from: <>", binding, i3);
                return binding;
            }
            catch (RuntimeException e2) {
                Logs.trace("Problem with just-in-time binding: {}", justInTimeKey, e2);
            }
            catch (LinkageError e3) {
                Logs.trace("Problem with just-in-time binding: {}", justInTimeKey, e3);
            }
        }
        return null;
    }
}

