/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ElementVisitor;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import org.eclipse.sisu.inject.BindingSubscriber;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

final class ServiceBinding<T>
implements Binding<T>,
Provider<T> {
    private final Key<T> key;
    private final T instance;
    private final int rank;

    ServiceBinding(BundleContext context, String clazzName, int maxRank, ServiceReference<T> reference) throws ClassNotFoundException {
        int serviceRanking;
        Class clazz = reference.getBundle().loadClass(clazzName);
        Object name = reference.getProperty("name");
        this.key = name instanceof String && ((String)name).length() > 0 ? Key.get((Class)clazz, (Annotation)Names.named((String)((String)name))) : Key.get((Class)clazz);
        this.instance = context.getService(reference);
        this.rank = maxRank > Integer.MIN_VALUE ? ((serviceRanking = ServiceBinding.getServiceRanking(reference)) < maxRank ? serviceRanking : maxRank) : Integer.MIN_VALUE;
    }

    public Key<T> getKey() {
        return this.key;
    }

    public Provider<T> getProvider() {
        return this;
    }

    public T get() {
        return this.instance;
    }

    public Object getSource() {
        return "OSGi service registry";
    }

    public void applyTo(Binder binder) {
    }

    public <V> V acceptVisitor(ElementVisitor<V> visitor2) {
        return (V)visitor2.visit((Binding)this);
    }

    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor2) {
        return null;
    }

    public <V> V acceptScopingVisitor(BindingScopingVisitor<V> visitor2) {
        return (V)visitor2.visitScopeAnnotation(Singleton.class);
    }

    boolean isCompatibleWith(BindingSubscriber<T> subscriber) {
        return this.key.getTypeLiteral().getRawType().equals(subscriber.type().getRawType());
    }

    int rank() {
        return this.rank;
    }

    private static int getServiceRanking(ServiceReference<?> reference) {
        Object ranking = reference.getProperty("service.ranking");
        return ranking instanceof Integer ? (Integer)ranking : 0;
    }
}

