/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.AttributeType;
import org.jdom.CloneBase;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.Verifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class Attribute
extends CloneBase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 200L;
    protected String name;
    protected Namespace namespace;
    protected String value;
    protected AttributeType type;
    protected boolean specified;
    protected transient Element parent;

    protected Attribute() {
        this.type = AttributeType.UNDECLARED;
        this.specified = true;
    }

    public Attribute(String name, String value, Namespace namespace) {
        this(name, value, AttributeType.UNDECLARED, namespace);
    }

    public Attribute(@NotNull String name, @NotNull String value, AttributeType type2, Namespace namespace) {
        if (name == null) {
            Attribute.$$$reportNull$$$0(0);
        }
        if (value == null) {
            Attribute.$$$reportNull$$$0(1);
        }
        this.type = AttributeType.UNDECLARED;
        this.specified = true;
        this.setName(name);
        this.setValue(value);
        this.setAttributeType(type2);
        this.setNamespace(namespace);
    }

    @ApiStatus.Internal
    public Attribute(boolean ignored, @NotNull String name, @NotNull String value, @NotNull Namespace namespace) {
        if (name == null) {
            Attribute.$$$reportNull$$$0(2);
        }
        if (value == null) {
            Attribute.$$$reportNull$$$0(3);
        }
        if (namespace == null) {
            Attribute.$$$reportNull$$$0(4);
        }
        this.type = AttributeType.UNDECLARED;
        this.specified = true;
        this.name = name;
        this.value = value;
        this.namespace = namespace;
    }

    public Attribute(@NotNull String name, @NotNull String value) {
        if (name == null) {
            Attribute.$$$reportNull$$$0(5);
        }
        if (value == null) {
            Attribute.$$$reportNull$$$0(6);
        }
        this(name, value, AttributeType.UNDECLARED, Namespace.NO_NAMESPACE);
    }

    public Attribute(String name, String value, AttributeType type2) {
        this(name, value, type2, Namespace.NO_NAMESPACE);
    }

    public Element getParent() {
        return this.parent;
    }

    public Document getDocument() {
        return this.parent == null ? null : this.parent.getDocument();
    }

    public String getName() {
        return this.name;
    }

    public Attribute setName(String name) {
        if (name == null) {
            throw new NullPointerException("Can not set a null name for an Attribute.");
        }
        String reason = Verifier.checkAttributeName(name);
        if (reason != null) {
            throw new IllegalNameException(name, "attribute", reason);
        }
        this.name = name;
        this.specified = true;
        return this;
    }

    public String getQualifiedName() {
        String prefix = this.namespace.getPrefix();
        if ("".equals(prefix)) {
            return this.getName();
        }
        return prefix + ':' + this.getName();
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Attribute setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        if (namespace != Namespace.NO_NAMESPACE && "".equals(namespace.getPrefix())) {
            throw new IllegalNameException("", "attribute namespace", "An attribute namespace without a prefix can only be the NO_NAMESPACE namespace");
        }
        this.namespace = namespace;
        this.specified = true;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Attribute setValue(@NotNull String value) {
        String reason;
        if (value == null) {
            Attribute.$$$reportNull$$$0(7);
        }
        if ((reason = Verifier.checkCharacterData(value)) != null) {
            throw new IllegalDataException(value, "attribute", reason);
        }
        this.value = value;
        this.specified = true;
        return this;
    }

    public AttributeType getAttributeType() {
        return this.type;
    }

    public Attribute setAttributeType(AttributeType type2) {
        this.type = type2 == null ? AttributeType.UNDECLARED : type2;
        this.specified = true;
        return this;
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public void setSpecified(boolean specified) {
        this.specified = specified;
    }

    public String toString() {
        return "[Attribute: " + this.getQualifiedName() + "=\"" + this.value + "\"]";
    }

    @Override
    public Attribute clone() {
        Attribute clone = (Attribute)super.clone();
        clone.parent = null;
        return clone;
    }

    public Attribute detach() {
        if (this.parent != null) {
            this.parent.removeAttribute(this);
        }
        return this;
    }

    protected Attribute setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public int getIntValue() throws DataConversionException {
        try {
            return Integer.parseInt(this.value.trim());
        }
        catch (NumberFormatException e2) {
            throw new DataConversionException(this.name, "int");
        }
    }

    public long getLongValue() throws DataConversionException {
        try {
            return Long.parseLong(this.value.trim());
        }
        catch (NumberFormatException e2) {
            throw new DataConversionException(this.name, "long");
        }
    }

    public float getFloatValue() throws DataConversionException {
        try {
            return Float.valueOf(this.value.trim()).floatValue();
        }
        catch (NumberFormatException e2) {
            throw new DataConversionException(this.name, "float");
        }
    }

    public double getDoubleValue() throws DataConversionException {
        try {
            return Double.valueOf(this.value.trim());
        }
        catch (NumberFormatException e2) {
            String v2 = this.value.trim();
            if ("INF".equals(v2)) {
                return Double.POSITIVE_INFINITY;
            }
            if ("-INF".equals(v2)) {
                return Double.NEGATIVE_INFINITY;
            }
            throw new DataConversionException(this.name, "double");
        }
    }

    public boolean getBooleanValue() throws DataConversionException {
        String valueTrim = this.value.trim();
        if (valueTrim.equalsIgnoreCase("true") || valueTrim.equalsIgnoreCase("on") || valueTrim.equalsIgnoreCase("1") || valueTrim.equalsIgnoreCase("yes")) {
            return true;
        }
        if (valueTrim.equalsIgnoreCase("false") || valueTrim.equalsIgnoreCase("off") || valueTrim.equalsIgnoreCase("0") || valueTrim.equalsIgnoreCase("no")) {
            return false;
        }
        throw new DataConversionException(this.name, "boolean");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        objectArray2[1] = "org/jdom/Attribute";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

