/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Dsn;
import io.sentry.SentryOptions;
import java.net.URI;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DsnUtil {
    public static boolean urlContainsDsnHost(@Nullable SentryOptions options2, @Nullable String url) {
        if (options2 == null) {
            return false;
        }
        if (url == null) {
            return false;
        }
        @Nullable String dsnString = options2.getDsn();
        if (dsnString == null) {
            return false;
        }
        @NotNull Dsn dsn = new Dsn(dsnString);
        @NotNull URI sentryUri = dsn.getSentryUri();
        @Nullable String dsnHost = sentryUri.getHost();
        if (dsnHost == null) {
            return false;
        }
        return url.toLowerCase(Locale.ROOT).contains(dsnHost.toLowerCase(Locale.ROOT));
    }
}

