/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.health;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ice4j.ice.harvest.MappingCandidateHarvester;
import org.ice4j.ice.harvest.MappingCandidateHarvesters;
import org.ice4j.ice.harvest.SinglePortUdpHarvester;
import org.jetbrains.annotations.NotNull;
import org.jitsi.health.HealthCheckService;
import org.jitsi.health.HealthChecker;
import org.jitsi.health.Result;
import org.jitsi.metrics.BooleanMetric;
import org.jitsi.videobridge.health.config.HealthConfig;
import org.jitsi.videobridge.ice.Harvesters;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jitsi/videobridge/health/JvbHealthChecker;", "Lorg/jitsi/health/HealthCheckService;", "<init>", "()V", "healthChecker", "Lorg/jitsi/health/HealthChecker;", "start", "", "stop", "checkAndUpdateMetric", "Lorg/jitsi/health/Result;", "check", "isValid", "", "Ljava/net/InetAddress;", "hasValidAddress", "result", "getResult", "()Lorg/jitsi/health/Result;", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nJvbHealthChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvbHealthChecker.kt\norg/jitsi/videobridge/health/JvbHealthChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,85:1\n1747#2,3:86\n12474#3,2:89\n*S KotlinDebug\n*F\n+ 1 JvbHealthChecker.kt\norg/jitsi/videobridge/health/JvbHealthChecker\n*L\n65#1:86,3\n68#1:89,2\n*E\n"})
public final class JvbHealthChecker
implements HealthCheckService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HealthChecker healthChecker = new HealthChecker(HealthConfig.config.getInterval(), HealthConfig.config.getTimeout(), HealthConfig.config.getMaxCheckDuration(), HealthConfig.config.getStickyFailures(), null, new Function0<Result>((Object)this){

        public final Result invoke() {
            return JvbHealthChecker.access$checkAndUpdateMetric((JvbHealthChecker)this.receiver);
        }
    }, null, 80, null);
    @NotNull
    private static final BooleanMetric healthyMetric = VideobridgeMetricsContainer.Companion.getInstance().registerBooleanMetric("healthy", "Whether the Videobridge instance is healthy or not.", true);

    public final void start() {
        this.healthChecker.start();
    }

    public final void stop() {
        this.healthChecker.stop();
    }

    private final Result checkAndUpdateMetric() {
        Result result;
        Result it = result = this.check();
        boolean bl = false;
        healthyMetric.set(it.getSuccess());
        return result;
    }

    private final Result check() {
        if (HealthConfig.config.getRequireValidAddress() && !this.hasValidAddress()) {
            return new Result(false, false, null, false, "No valid IP addresses available for harvesting.", 14, null);
        }
        if (HealthConfig.config.getRequireStun() && MappingCandidateHarvesters.stunDiscoveryFailed) {
            return new Result(false, false, null, false, "Address discovery through STUN failed", 14, null);
        }
        if (!Harvesters.Companion.getINSTANCE().getHealthy()) {
            return new Result(false, false, null, false, "Failed to bind single-port", 14, null);
        }
        return new Result(true, false, null, false, null, 30, null);
    }

    private final boolean isValid(InetAddress $this$isValid) {
        return !$this$isValid.isSiteLocalAddress() && !$this$isValid.isLinkLocalAddress() && !$this$isValid.isLoopbackAddress();
    }

    private final boolean hasValidAddress() {
        boolean bl;
        block6: {
            boolean bl2;
            boolean $i$f$any;
            Object[] $this$any$iv;
            block5: {
                $this$any$iv = (Object[])Harvesters.Companion.getINSTANCE().getSinglePortHarvesters();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object t2 : $this$any$iv) {
                        SinglePortUdpHarvester it = (SinglePortUdpHarvester)t2;
                        boolean bl3 = false;
                        InetAddress inetAddress = it.getLocalAddress().getAddress();
                        Intrinsics.checkNotNullExpressionValue(inetAddress, "getAddress(...)");
                        if (!this.isValid(inetAddress)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return true;
            }
            MappingCandidateHarvester[] mappingCandidateHarvesterArray = MappingCandidateHarvesters.getHarvesters();
            Intrinsics.checkNotNullExpressionValue(mappingCandidateHarvesterArray, "getHarvesters(...)");
            $this$any$iv = mappingCandidateHarvesterArray;
            $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                MappingCandidateHarvester it = (MappingCandidateHarvester)element$iv;
                boolean bl4 = false;
                Serializable serializable = it.getMask();
                boolean bl3 = serializable != null && (serializable = serializable.getAddress()) != null ? this.isValid((InetAddress)serializable) : false;
                if (!bl3) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public Result getResult() {
        return this.healthChecker.getResult();
    }

    public static final /* synthetic */ Result access$checkAndUpdateMetric(JvbHealthChecker $this) {
        return $this.checkAndUpdateMetric();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/health/JvbHealthChecker$Companion;", "", "<init>", "()V", "healthyMetric", "Lorg/jitsi/metrics/BooleanMetric;", "getHealthyMetric", "()Lorg/jitsi/metrics/BooleanMetric;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanMetric getHealthyMetric() {
            return healthyMetric;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

