/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.provider;

import java.io.IOException;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.parsing.StandardExtensionElementProvider;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleContentDescription;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.element.JingleReason;
import org.jivesoftware.smackx.jingle.element.UnknownJingleContentDescription;
import org.jivesoftware.smackx.jingle.element.UnknownJingleContentTransport;
import org.jivesoftware.smackx.jingle.provider.JingleContentProviderManager;
import org.jxmpp.jid.EntityFullJid;

public class JingleProvider
extends IqProvider<Jingle> {
    private static final Logger LOGGER = Logger.getLogger(JingleProvider.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Jingle parse(XmlPullParser parser2, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        Jingle.Builder builder2 = Jingle.builder(iqData);
        String actionString = parser2.getAttributeValue("", "action");
        if (actionString != null) {
            JingleAction action = JingleAction.fromString(actionString);
            builder2.setAction(action);
        }
        EntityFullJid initiator = ParserUtils.getFullJidAttribute(parser2, "initiator");
        builder2.setInitiator(initiator);
        EntityFullJid responder = ParserUtils.getFullJidAttribute(parser2, "responder");
        builder2.setResponder(responder);
        String sessionId = parser2.getAttributeValue("", "sid");
        builder2.setSessionId(sessionId);
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String tagName;
                    switch (tagName = parser2.getName()) {
                        case "content": {
                            JingleContent content = JingleProvider.parseJingleContent(parser2, parser2.getDepth());
                            builder2.addJingleContent(content);
                            break block0;
                        }
                        case "reason": {
                            JingleReason reason = JingleProvider.parseJingleReason(parser2);
                            builder2.setReason(reason);
                            break block0;
                        }
                    }
                    LOGGER.severe("Unknown Jingle element: " + tagName);
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return builder2.build();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static JingleContent parseJingleContent(XmlPullParser parser2, int initialDepth) throws XmlPullParserException, IOException, SmackParsingException {
        JingleContent.Builder builder2 = JingleContent.getBuilder();
        String creatorString = parser2.getAttributeValue("", "creator");
        JingleContent.Creator creator = JingleContent.Creator.valueOf(creatorString);
        builder2.setCreator(creator);
        String disposition = parser2.getAttributeValue("", "disposition");
        builder2.setDisposition(disposition);
        String name = parser2.getAttributeValue("", "name");
        builder2.setName(name);
        String sendersString = parser2.getAttributeValue("", "senders");
        if (sendersString != null) {
            JingleContent.Senders senders = JingleContent.Senders.valueOf(sendersString);
            builder2.setSenders(senders);
        }
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String tagName = parser2.getName();
                    String namespace = parser2.getNamespace();
                    switch (tagName) {
                        case "description": {
                            JingleContentDescription description;
                            StandardExtensionElement standardExtensionElement;
                            ExtensionElementProvider provider = JingleContentProviderManager.getJingleContentDescriptionProvider(namespace);
                            if (provider == null) {
                                standardExtensionElement = (StandardExtensionElement)StandardExtensionElementProvider.INSTANCE.parse(parser2);
                                description = new UnknownJingleContentDescription(standardExtensionElement);
                            } else {
                                description = (JingleContentDescription)provider.parse(parser2);
                            }
                            builder2.setDescription(description);
                            break block0;
                        }
                        case "transport": {
                            JingleContentTransport transport;
                            StandardExtensionElement standardExtensionElement;
                            ExtensionElementProvider provider = JingleContentProviderManager.getJingleContentTransportProvider(namespace);
                            if (provider == null) {
                                standardExtensionElement = (StandardExtensionElement)StandardExtensionElementProvider.INSTANCE.parse(parser2);
                                transport = new UnknownJingleContentTransport(standardExtensionElement);
                            } else {
                                transport = (JingleContentTransport)provider.parse(parser2);
                            }
                            builder2.setTransport(transport);
                            break block0;
                        }
                    }
                    LOGGER.severe("Unknown Jingle content element: " + tagName);
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return builder2.build();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static JingleReason parseJingleReason(XmlPullParser parser2) throws XmlPullParserException, IOException, SmackParsingException {
        void var7_10;
        ParserUtils.assertAtStartTag(parser2);
        int initialDepth = parser2.getDepth();
        String jingleNamespace = parser2.getNamespace();
        JingleReason.Reason reason = null;
        ExtensionElement element = null;
        String text = null;
        String sid = null;
        block12: while (true) {
            XmlPullParser.TagEvent tagEvent = parser2.nextTag();
            block0 : switch (tagEvent) {
                case START_ELEMENT: {
                    String elementName = parser2.getName();
                    String namespace = parser2.getNamespace();
                    if (namespace.equals(jingleNamespace)) {
                        switch (elementName) {
                            case "text": {
                                text = parser2.nextText();
                                break block0;
                            }
                            case "alternative-session": {
                                parser2.next();
                                sid = parser2.nextText();
                                break block0;
                            }
                        }
                        reason = JingleReason.Reason.fromString(elementName);
                        break;
                    }
                    element = PacketParserUtils.parseExtensionElement(elementName, namespace, parser2, null);
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() == initialDepth) break block12;
                }
            }
        }
        if (sid != null) {
            JingleReason.AlternativeSession alternativeSession = new JingleReason.AlternativeSession(sid, text, element);
            return var7_10;
        }
        JingleReason jingleReason = new JingleReason(reason, text, element);
        return var7_10;
    }
}

