/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableMergeArrayDelayError
extends Completable {
    final CompletableSource[] sources;

    public CompletableMergeArrayDelayError(CompletableSource[] sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        CompositeDisposable set = new CompositeDisposable();
        AtomicInteger wip = new AtomicInteger(this.sources.length + 1);
        AtomicThrowable errors = new AtomicThrowable();
        set.add(new TryTerminateAndReportDisposable(errors));
        observer.onSubscribe(set);
        for (CompletableSource c : this.sources) {
            if (set.isDisposed()) {
                return;
            }
            if (c == null) {
                NullPointerException ex = new NullPointerException("A completable source is null");
                errors.tryAddThrowableOrReport(ex);
                wip.decrementAndGet();
                continue;
            }
            c.subscribe(new MergeInnerCompletableObserver(observer, set, errors, wip));
        }
        if (wip.decrementAndGet() == 0) {
            errors.tryTerminateConsumer(observer);
        }
    }

    static final class MergeInnerCompletableObserver
    implements CompletableObserver {
        final CompletableObserver downstream;
        final CompositeDisposable set;
        final AtomicThrowable errors;
        final AtomicInteger wip;

        MergeInnerCompletableObserver(CompletableObserver observer, CompositeDisposable set, AtomicThrowable error, AtomicInteger wip) {
            this.downstream = observer;
            this.set = set;
            this.errors = error;
            this.wip = wip;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.set.add(d);
        }

        @Override
        public void onError(Throwable e) {
            if (this.errors.tryAddThrowableOrReport(e)) {
                this.tryTerminate();
            }
        }

        @Override
        public void onComplete() {
            this.tryTerminate();
        }

        void tryTerminate() {
            if (this.wip.decrementAndGet() == 0) {
                this.errors.tryTerminateConsumer(this.downstream);
            }
        }
    }

    static final class TryTerminateAndReportDisposable
    implements Disposable {
        final AtomicThrowable errors;

        TryTerminateAndReportDisposable(AtomicThrowable errors) {
            this.errors = errors;
        }

        @Override
        public void dispose() {
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.errors.isTerminated();
        }
    }
}

