/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.io.Serializable;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.persistence.remote.RemoteStore;
import org.jboss.logging.Logger;

abstract class CrossDCAwareCacheFactory {
    protected static final Logger logger = Logger.getLogger(CrossDCAwareCacheFactory.class);

    CrossDCAwareCacheFactory() {
    }

    abstract BasicCache<String, Serializable> getCache();

    static CrossDCAwareCacheFactory getFactory(Cache<String, Serializable> workCache, Set<RemoteStore> remoteStores) {
        RemoteStore remoteStore;
        RemoteCache remoteCache;
        if (remoteStores.isEmpty()) {
            logger.debugf("No configured remoteStore available. Cross-DC scenario is not used", new Object[0]);
            return new InfinispanCacheWrapperFactory(workCache);
        }
        logger.debugf("RemoteStore is available. Cross-DC scenario will be used", new Object[0]);
        if (remoteStores.size() > 1) {
            logger.warnf("More remoteStores configured for work cache. Will use just the first one", new Object[0]);
        }
        if ((remoteCache = (remoteStore = remoteStores.iterator().next()).getRemoteCache()) == null) {
            String cacheName = remoteStore.getConfiguration().remoteCacheName();
            throw new IllegalStateException("Remote cache '" + cacheName + "' is not available.");
        }
        return new RemoteCacheWrapperFactory((RemoteCache<String, Serializable>)remoteCache);
    }

    private static class InfinispanCacheWrapperFactory
    extends CrossDCAwareCacheFactory {
        private final Cache<String, Serializable> workCache;

        InfinispanCacheWrapperFactory(Cache<String, Serializable> workCache) {
            this.workCache = workCache;
        }

        @Override
        BasicCache<String, Serializable> getCache() {
            return this.workCache;
        }
    }

    private static class RemoteCacheWrapperFactory
    extends CrossDCAwareCacheFactory {
        private final RemoteCache<String, Serializable> remoteCache;

        RemoteCacheWrapperFactory(RemoteCache<String, Serializable> remoteCache) {
            this.remoteCache = remoteCache;
        }

        @Override
        BasicCache<String, Serializable> getCache() {
            return this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE});
        }
    }
}

