/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import io.reactivex.rxjava3.core.Flowable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.ByRef;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.persistence.manager.PersistenceManager;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.migration.ModelVersion;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.ModelException;
import org.keycloak.models.OfflineUserSessionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.AuthenticatedClientSessionAdapter;
import org.keycloak.models.sessions.infinispan.CacheDecorators;
import org.keycloak.models.sessions.infinispan.SessionFunction;
import org.keycloak.models.sessions.infinispan.SessionRefreshStore;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.changes.ClientSessionPersistentChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.JpaChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.MergedUpdate;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.sessions.infinispan.changes.SerializeExecutionsByKey;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.changes.Tasks;
import org.keycloak.models.sessions.infinispan.changes.UserSessionPersistentChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionStore;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveUserSessionsEvent;
import org.keycloak.models.sessions.infinispan.events.SessionEventsSenderTransaction;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;
import org.keycloak.models.sessions.infinispan.stream.Mappers;
import org.keycloak.models.sessions.infinispan.stream.SessionPredicate;
import org.keycloak.models.sessions.infinispan.stream.UserSessionPredicate;
import org.keycloak.models.sessions.infinispan.util.FuturesHelper;
import org.keycloak.models.sessions.infinispan.util.InfinispanKeyGenerator;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.utils.StreamsUtil;
import org.reactivestreams.Publisher;

public class PersistentUserSessionProvider
implements UserSessionProvider,
SessionRefreshStore {
    private static final Logger log = Logger.getLogger(PersistentUserSessionProvider.class);
    protected final KeycloakSession session;
    protected final Cache<String, SessionEntityWrapper<UserSessionEntity>> sessionCache;
    protected final Cache<String, SessionEntityWrapper<UserSessionEntity>> offlineSessionCache;
    protected final Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionCache;
    protected final Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> offlineClientSessionCache;
    protected final UserSessionPersistentChangelogBasedTransaction sessionTx;
    protected final ClientSessionPersistentChangelogBasedTransaction clientSessionTx;
    protected final SessionEventsSenderTransaction clusterEventsSenderTx;
    protected final CrossDCLastSessionRefreshStore lastSessionRefreshStore;
    protected final CrossDCLastSessionRefreshStore offlineLastSessionRefreshStore;
    protected final InfinispanKeyGenerator keyGenerator;

    public PersistentUserSessionProvider(KeycloakSession session, RemoteCacheInvoker remoteCacheInvoker, CrossDCLastSessionRefreshStore lastSessionRefreshStore, CrossDCLastSessionRefreshStore offlineLastSessionRefreshStore, InfinispanKeyGenerator keyGenerator, Cache<String, SessionEntityWrapper<UserSessionEntity>> sessionCache, Cache<String, SessionEntityWrapper<UserSessionEntity>> offlineSessionCache, Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionCache, Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> offlineClientSessionCache, ArrayBlockingQueue<PersistentUpdate> asyncQueuePersistentUpdate, SerializeExecutionsByKey<String> serializerSession, SerializeExecutionsByKey<String> serializerOfflineSession, SerializeExecutionsByKey<UUID> serializerClientSession, SerializeExecutionsByKey<UUID> serializerOfflineClientSession) {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS)) {
            throw new IllegalStateException("Persistent user sessions are not enabled");
        }
        this.session = session;
        this.sessionCache = sessionCache;
        this.clientSessionCache = clientSessionCache;
        this.offlineSessionCache = offlineSessionCache;
        this.offlineClientSessionCache = offlineClientSessionCache;
        this.sessionTx = new UserSessionPersistentChangelogBasedTransaction(session, sessionCache, offlineSessionCache, remoteCacheInvoker, SessionTimeouts::getUserSessionLifespanMs, SessionTimeouts::getUserSessionMaxIdleMs, SessionTimeouts::getOfflineSessionLifespanMs, SessionTimeouts::getOfflineSessionMaxIdleMs, asyncQueuePersistentUpdate, serializerSession, serializerOfflineSession);
        this.clientSessionTx = new ClientSessionPersistentChangelogBasedTransaction(session, clientSessionCache, offlineClientSessionCache, remoteCacheInvoker, SessionTimeouts::getClientSessionLifespanMs, SessionTimeouts::getClientSessionMaxIdleMs, SessionTimeouts::getOfflineClientSessionLifespanMs, SessionTimeouts::getOfflineClientSessionMaxIdleMs, this.sessionTx, asyncQueuePersistentUpdate, serializerClientSession, serializerOfflineClientSession);
        this.clusterEventsSenderTx = new SessionEventsSenderTransaction(session);
        this.lastSessionRefreshStore = lastSessionRefreshStore;
        this.offlineLastSessionRefreshStore = offlineLastSessionRefreshStore;
        this.keyGenerator = keyGenerator;
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.clusterEventsSenderTx);
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.sessionTx);
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.clientSessionTx);
    }

    protected Cache<String, SessionEntityWrapper<UserSessionEntity>> getCache(boolean offline) {
        return offline ? this.offlineSessionCache : this.sessionCache;
    }

    protected Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> getClientSessionCache(boolean offline) {
        return offline ? this.offlineClientSessionCache : this.clientSessionCache;
    }

    @Override
    public CrossDCLastSessionRefreshStore getLastSessionRefreshStore() {
        return this.lastSessionRefreshStore;
    }

    @Override
    public CrossDCLastSessionRefreshStore getOfflineLastSessionRefreshStore() {
        return this.offlineLastSessionRefreshStore;
    }

    @Override
    public PersisterLastSessionRefreshStore getPersisterLastSessionRefreshStore() {
        throw new IllegalStateException("PersisterLastSessionRefreshStore is not supported in PersistentUserSessionProvider");
    }

    public KeycloakSession getKeycloakSession() {
        return this.session;
    }

    public AuthenticatedClientSessionModel createClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession) {
        UUID clientSessionId = PersistentUserSessionProvider.createClientSessionUUID(userSession.getId(), client.getId());
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity(clientSessionId);
        entity.setRealmId(realm.getId());
        entity.setClientId(client.getId());
        entity.setUserSessionId(userSession.getId());
        entity.setTimestamp(Time.currentTime());
        entity.getNotes().put("startedAt", String.valueOf(entity.getTimestamp()));
        entity.getNotes().put("userSessionStartedAt", String.valueOf(userSession.getStarted()));
        if (userSession.isRememberMe()) {
            entity.getNotes().put("userSessionRememberMe", "true");
        }
        AuthenticatedClientSessionAdapter adapter = new AuthenticatedClientSessionAdapter(this.session, this, entity, client, userSession, this.clientSessionTx, false);
        if (userSession.isOffline() && this.sessionTx.get(realm, userSession.getId(), false) == null) {
            return adapter;
        }
        UserSessionModel.SessionPersistenceState persistenceState = userSession.getPersistenceState() != null ? userSession.getPersistenceState() : UserSessionModel.SessionPersistenceState.PERSISTENT;
        SessionUpdateTask createClientSessionTask = Tasks.addIfAbsentSync();
        this.clientSessionTx.addTask(clientSessionId, createClientSessionTask, entity, persistenceState);
        ClientSessionPersistentChangelogBasedTransaction.RegisterClientSessionTask registerClientSessionTask = new ClientSessionPersistentChangelogBasedTransaction.RegisterClientSessionTask(client.getId(), clientSessionId, userSession.isOffline());
        this.sessionTx.addTask(userSession.getId(), registerClientSessionTask);
        return adapter;
    }

    public UserSessionModel createUserSession(String id, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId, UserSessionModel.SessionPersistenceState persistenceState) {
        if (id == null) {
            id = this.keyGenerator.generateKeyString(this.session, this.sessionCache);
        }
        UserSessionEntity entity = new UserSessionEntity(id);
        this.updateSessionEntity(entity, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId);
        SessionUpdateTask createSessionTask = Tasks.addIfAbsentSync();
        this.sessionTx.addTask(id, createSessionTask, entity, persistenceState);
        UserSessionAdapter adapter = user instanceof LightweightUserAdapter ? this.wrap(realm, entity, false, user) : this.wrap(realm, entity, false);
        adapter.setPersistenceState(persistenceState);
        return adapter;
    }

    void updateSessionEntity(UserSessionEntity entity, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        entity.setRealmId(realm.getId());
        entity.setUser(user.getId());
        entity.setLoginUsername(loginUsername);
        entity.setIpAddress(ipAddress);
        entity.setAuthMethod(authMethod);
        entity.setRememberMe(rememberMe);
        entity.setBrokerSessionId(brokerSessionId);
        entity.setBrokerUserId(brokerUserId);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        return this.getUserSession(realm, id, false);
    }

    private UserSessionAdapter getUserSession(RealmModel realm, String id, boolean offline) {
        SessionEntityWrapper<UserSessionEntity> entityWrapper = this.sessionTx.get(realm, id, offline);
        return entityWrapper != null ? this.wrap(realm, entityWrapper.getEntity(), offline) : null;
    }

    private UserSessionEntity getUserSessionEntity(RealmModel realm, String id, boolean offline) {
        SessionEntityWrapper<UserSessionEntity> entityWrapper = this.sessionTx.get(realm, id, offline);
        return entityWrapper != null ? entityWrapper.getEntity() : null;
    }

    private Stream<UserSessionModel> getUserSessionsFromPersistenceProviderStream(RealmModel realm, UserModel user) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        return persister.loadUserSessionsStream(realm, user, true, Integer.valueOf(0), null).map(persistentUserSession -> this.getUserSession(realm, persistentUserSession.getId(), true)).filter(Objects::nonNull);
    }

    protected Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, final UserSessionPredicate predicate, boolean offline) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (predicate.getUserId() != null) {
            Object user = LightweightUserAdapter.isLightweightUser((String)predicate.getUserId()) ? new UserModelDelegate(null){

                public String getId() {
                    return predicate.getUserId();
                }
            } : this.session.users().getUserById(realm, predicate.getUserId());
            if (user != null) {
                return persister.loadUserSessionsStream(realm, (UserModel)user, offline, Integer.valueOf(0), null).filter(predicate.toModelPredicate()).map(s -> this.getUserSession(realm, s.getId(), offline)).filter(Objects::nonNull);
            }
            return Stream.empty();
        }
        if (predicate.getBrokerUserId() != null) {
            String[] idpAliasSessionId = predicate.getBrokerUserId().split("\\.");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("keycloak.session.realm.users.query.idp_alias", idpAliasSessionId[0]);
            attributes.put("keycloak.session.realm.users.query.idp_user_id", idpAliasSessionId[1]);
            UserProvider userProvider = (UserProvider)this.session.getProvider(UserProvider.class);
            UserModel userModel = userProvider.searchForUserStream(realm, attributes, Integer.valueOf(0), null).findFirst().orElse(null);
            return userModel != null ? persister.loadUserSessionsStream(realm, userModel, offline, Integer.valueOf(0), null).filter(predicate.toModelPredicate()).map(s -> this.getUserSession(realm, s.getId(), offline)).filter(Objects::nonNull) : Stream.empty();
        }
        if (predicate.getClient() != null) {
            ClientModel client = this.session.clients().getClientById(realm, predicate.getClient());
            return persister.loadUserSessionsStream(realm, client, offline, Integer.valueOf(0), null).filter(predicate.toModelPredicate()).map(s -> this.getUserSession(realm, s.getId(), offline)).filter(Objects::nonNull);
        }
        if (predicate.getBrokerSessionId() != null && !offline) {
            return Stream.of(persister.loadUserSessionsStreamByBrokerSessionId(realm, predicate.getBrokerSessionId(), false)).filter(predicate.toModelPredicate()).map(s -> this.getUserSession(realm, s.getId(), false)).filter(Objects::nonNull);
        }
        throw new ModelException("For offline sessions, only lookup by userId, brokerUserId and client is supported");
    }

    public AuthenticatedClientSessionAdapter getClientSession(UserSessionModel userSession, ClientModel client, String clientSessionId, boolean offline) {
        if (clientSessionId == null) {
            return null;
        }
        UUID clientSessionUUID = UUID.fromString(clientSessionId);
        SessionEntityWrapper<AuthenticatedClientSessionEntity> clientSessionEntity = this.clientSessionTx.get(client.getRealm(), client, userSession, clientSessionUUID, offline);
        if (clientSessionEntity != null) {
            return new AuthenticatedClientSessionAdapter(this.session, this, clientSessionEntity.getEntity(), client, userSession, this.clientSessionTx, offline);
        }
        return null;
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, UserModel user) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).user(user.getId()), false);
    }

    public Stream<UserSessionModel> getUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerUserId(brokerUserId), false);
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerSessionId(brokerSessionId), false).findFirst().orElse(null);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client) {
        return this.getUserSessionsStream(realm, client, -1, -1);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults) {
        return this.getUserSessionsStream(realm, client, firstResult, maxResults, false);
    }

    protected Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults, boolean offline) {
        UserSessionPredicate predicate = UserSessionPredicate.create(realm.getId()).client(client.getId());
        return StreamsUtil.paginatedStream(this.getUserSessionsStream(realm, predicate, offline), (Integer)firstResult, (Integer)maxResults);
    }

    public UserSessionModel getUserSessionWithPredicate(RealmModel realm, String id, boolean offline, Predicate<UserSessionModel> predicate) {
        UserSessionAdapter userSession = this.getUserSession(realm, id, offline);
        if (userSession == null) {
            return null;
        }
        if (predicate.test(userSession)) {
            log.debugf("getUserSessionWithPredicate(%s): found in local cache", (Object)id);
            return userSession;
        }
        return null;
    }

    public long getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, false);
    }

    public Map<String, Long> getActiveClientSessionStats(RealmModel realm, boolean offline) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        return persister.getUserSessionsCountsByClients(realm, offline);
    }

    protected long getUserSessionsCount(RealmModel realm, ClientModel client, boolean offline) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        return persister.getUserSessionsCount(realm, client, offline);
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        UserSessionEntity entity = this.getUserSessionEntity(realm, session, false);
        if (entity != null) {
            this.removeUserSession(entity, false);
        }
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, false);
    }

    protected void removeUserSessions(RealmModel realm, UserModel user, boolean offline) {
        UserSessionPredicate.create(realm.getId()).user(user.getId());
        this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).user(user.getId()), offline).forEach(s -> this.removeUserSession(realm, (UserSessionModel)s));
    }

    public void removeAllExpired() {
        this.session.realms().getRealmsStream().forEach(this::removeExpired);
    }

    public void removeExpired(RealmModel realm) {
        ((UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)).removeExpired(realm);
    }

    public void removeUserSessions(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RemoveUserSessionsEvent.createEvent(RemoveUserSessionsEvent.class, "REMOVE_USER_SESSIONS_EVENT", this.session, realm.getId(), true), ClusterProvider.DCNotify.ALL_DCS);
        ((UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)).removeUserSessions(realm, false);
    }

    protected void onRemoveUserSessionsEvent(String realmId) {
        this.removeLocalUserSessions(realmId, false);
        this.removeLocalUserSessions(realmId, true);
    }

    public void removeLocalUserSessions(String realmId, boolean offline) {
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> localCache = CacheDecorators.localCache(cache);
        Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionCache = this.getClientSessionCache(offline);
        AdvancedCache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> localClientSessionCache = CacheDecorators.localCache(clientSessionCache);
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> localCacheStoreIgnore = CacheDecorators.skipCacheLoadersIfRemoteStoreIsEnabled(localCache);
        AtomicInteger userSessionsSize = new AtomicInteger();
        PersistentUserSessionProvider.removeEntriesByRealm(realmId, localCacheStoreIgnore, userSessionsSize, localCache, localClientSessionCache);
        PersistentUserSessionProvider.removeEntriesByRealmRemote(realmId, (RemoteCache<String, SessionEntityWrapper<UserSessionEntity>>)InfinispanUtil.getRemoteCache(this.getCache(offline)), userSessionsSize, (RemoteCache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>>)InfinispanUtil.getRemoteCache(this.getClientSessionCache(offline)));
        log.debugf("Removed %d sessions in realm %s. Offline: %b", (Object)userSessionsSize.get(), (Object)realmId, (Object)offline);
    }

    private static void removeEntriesByRealm(String realmId, Cache<String, SessionEntityWrapper<UserSessionEntity>> sessions, AtomicInteger userSessionsSize, Cache<String, SessionEntityWrapper<UserSessionEntity>> localCache, Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessions) {
        FuturesHelper futures = new FuturesHelper();
        sessions.entrySet().stream().filter((Predicate)SessionPredicate.create(realmId)).map(Mappers.userSessionEntity()).forEach(userSessionEntity -> {
            userSessionsSize.incrementAndGet();
            CompletableFuture future = localCache.removeAsync((Object)userSessionEntity.getId());
            futures.addTask(future);
            userSessionEntity.getAuthenticatedClientSessions().forEach((clientUUID, clientSessionId) -> {
                CompletableFuture f = clientSessions.removeAsync(clientSessionId);
                futures.addTask(f);
            });
        });
        futures.waitForAllToFinish();
    }

    private static void removeEntriesByRealmRemote(String realmId, RemoteCache<String, SessionEntityWrapper<UserSessionEntity>> sessions, AtomicInteger userSessionsSize, RemoteCache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessions) {
        if (sessions == null) {
            return;
        }
        FuturesHelper futures = new FuturesHelper();
        sessions.entrySet().stream().filter(SessionPredicate.create(realmId)).map(Mappers.userSessionEntity()).forEach(userSessionEntity -> {
            userSessionsSize.incrementAndGet();
            CompletableFuture future = sessions.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).removeAsync((Object)userSessionEntity.getId());
            futures.addTask(future);
            if (clientSessions != null) {
                userSessionEntity.getAuthenticatedClientSessions().forEach((clientUUID, clientSessionId) -> {
                    CompletableFuture f = clientSessions.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).removeAsync(clientSessionId);
                    futures.addTask(f);
                });
            }
        });
        futures.waitForAllToFinish();
    }

    public void onRealmRemoved(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RealmRemovedSessionEvent.createEvent(RealmRemovedSessionEvent.class, "REALM_REMOVED_EVENT_SESSIONS", this.session, realm.getId(), true), ClusterProvider.DCNotify.ALL_DCS);
        UserSessionPersisterProvider sessionsPersister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (sessionsPersister != null) {
            sessionsPersister.onRealmRemoved(realm);
        }
    }

    protected void onRealmRemovedEvent(String realmId) {
        this.removeLocalUserSessions(realmId, true);
        this.removeLocalUserSessions(realmId, false);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        UserSessionPersisterProvider sessionsPersister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (sessionsPersister != null) {
            sessionsPersister.onClientRemoved(realm, client);
        }
    }

    protected void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, true);
        this.removeUserSessions(realm, user, false);
        UserSessionPersisterProvider persisterProvider = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (persisterProvider != null) {
            persisterProvider.onUserRemoved(realm, user);
        }
    }

    public void close() {
    }

    public int getStartupTime(RealmModel realm) {
        return ((ClusterProvider)this.session.getProvider(ClusterProvider.class)).getClusterStartupTime();
    }

    protected void removeUserSession(UserSessionEntity sessionEntity, boolean offline) {
        sessionEntity.getAuthenticatedClientSessions().forEach((clientUUID, clientSessionId) -> this.clientSessionTx.addTask(clientSessionId, Tasks.removeSync(offline)));
        SessionUpdateTask removeTask = Tasks.removeSync(offline);
        this.sessionTx.addTask(sessionEntity.getId(), removeTask);
    }

    UserSessionAdapter wrap(RealmModel realm, UserSessionEntity entity, boolean offline, UserModel user) {
        if (entity == null) {
            return null;
        }
        return new UserSessionAdapter<PersistentUserSessionProvider>(this.session, user, this, this.sessionTx, this.clientSessionTx, realm, entity, offline);
    }

    UserSessionAdapter wrap(RealmModel realm, UserSessionEntity entity, boolean offline) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.TRANSIENT_USERS) && entity.getNotes().containsKey("keycloak.userModel")) {
            LightweightUserAdapter lua = LightweightUserAdapter.fromString((KeycloakSession)this.session, (RealmModel)realm, (String)entity.getNotes().get("keycloak.userModel"));
            UserSessionAdapter us = this.wrap(realm, entity, offline, (UserModel)lua);
            lua.setUpdateHandler(lua1 -> {
                if (lua == lua1) {
                    us.setNote("keycloak.userModel", lua1.serialize());
                }
            });
            return us;
        }
        UserModel user = this.session.users().getUserById(realm, entity.getUser());
        if (user == null) {
            return null;
        }
        return this.wrap(realm, entity, offline, user);
    }

    UserSessionEntity getUserSessionEntity(RealmModel realm, UserSessionModel userSession, boolean offline) {
        if (userSession instanceof UserSessionAdapter) {
            if (!userSession.getRealm().equals(realm)) {
                return null;
            }
            return ((UserSessionAdapter)userSession).getEntity();
        }
        return this.getUserSessionEntity(realm, userSession.getId(), offline);
    }

    public UserSessionModel createOfflineUserSession(UserSessionModel userSession) {
        UserSessionEntity entity = this.createUserSessionEntityInstance(userSession);
        entity.setOffline(true);
        SessionUpdateTask importTask = Tasks.addIfAbsentSync();
        this.sessionTx.addTask(userSession.getId(), importTask, entity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        UserSessionAdapter offlineUserSession = this.wrap(userSession.getRealm(), entity, true);
        int currentTime = Time.currentTime();
        offlineUserSession.getEntity().setStarted(currentTime);
        offlineUserSession.getEntity().setLastSessionRefresh(currentTime);
        return offlineUserSession;
    }

    public UserSessionAdapter getOfflineUserSession(RealmModel realm, String userSessionId) {
        return this.getUserSession(realm, userSessionId, true);
    }

    public Stream<UserSessionModel> getOfflineUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerUserId(brokerUserId), true);
    }

    public void removeOfflineUserSession(RealmModel realm, UserSessionModel userSession) {
        UserSessionEntity userSessionEntity = this.getUserSessionEntity(realm, userSession, true);
        if (userSessionEntity != null) {
            this.removeUserSession(userSessionEntity, true);
        }
    }

    public AuthenticatedClientSessionModel createOfflineClientSession(AuthenticatedClientSessionModel clientSession, UserSessionModel offlineUserSession) {
        UserSessionAdapter userSessionAdapter = offlineUserSession instanceof UserSessionAdapter ? (UserSessionAdapter)offlineUserSession : this.getOfflineUserSession(offlineUserSession.getRealm(), offlineUserSession.getId());
        AuthenticatedClientSessionAdapter offlineClientSession = this.importOfflineClientSession(userSessionAdapter, clientSession);
        offlineClientSession.setTimestamp(Time.currentTime());
        offlineClientSession.getNotes().put("startedAt", String.valueOf(offlineClientSession.getTimestamp()));
        offlineClientSession.getNotes().put("userSessionStartedAt", String.valueOf(offlineUserSession.getStarted()));
        return offlineClientSession;
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, UserModel user) {
        return this.getUserSessionsFromPersistenceProviderStream(realm, user);
    }

    public long getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, true);
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, ClientModel client, Integer first, Integer max) {
        return this.getUserSessionsStream(realm, client, first, max, true);
    }

    public void importUserSessions(Collection<UserSessionModel> persistentUserSessions, boolean offline) {
        if (persistentUserSessions == null || persistentUserSessions.isEmpty()) {
            return;
        }
        persistentUserSessions.forEach(userSessionModel -> this.importUserSession((UserSessionModel)userSessionModel, offline));
    }

    public SessionEntityWrapper<UserSessionEntity> importUserSession(UserSessionModel persistentUserSession, boolean offline) {
        HashMap<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionsById = new HashMap<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>>();
        UserSessionEntity userSessionEntityToImport = this.createUserSessionEntityInstance(persistentUserSession);
        for (Map.Entry entry : persistentUserSession.getAuthenticatedClientSessions().entrySet()) {
            String clientUUID = (String)entry.getKey();
            AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)entry.getValue();
            AuthenticatedClientSessionEntity clientSessionToImport = this.createAuthenticatedClientSessionInstance(userSessionEntityToImport.getId(), clientSession, userSessionEntityToImport.getRealmId(), clientUUID, offline);
            clientSessionToImport.setUserSessionId(userSessionEntityToImport.getId());
            clientSessionToImport.setTimestamp(userSessionEntityToImport.getLastSessionRefresh());
            clientSessionsById.put(clientSessionToImport.getId(), new SessionEntityWrapper<AuthenticatedClientSessionEntity>(clientSessionToImport));
            AuthenticatedClientSessionStore clientSessions = userSessionEntityToImport.getAuthenticatedClientSessions();
            clientSessions.put(clientUUID, clientSessionToImport.getId());
        }
        SessionEntityWrapper<UserSessionEntity> wrappedUserSessionEntity = new SessionEntityWrapper<UserSessionEntity>(userSessionEntityToImport);
        Map<String, Object> sessionsById = Stream.of(wrappedUserSessionEntity).collect(Collectors.toMap(sessionEntityWrapper -> ((UserSessionEntity)sessionEntityWrapper.getEntity()).getId(), Function.identity()));
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> cache = CacheDecorators.skipCacheLoadersIfRemoteStoreIsEnabled(this.getCache(offline));
        if ((sessionsById = this.importSessionsWithExpiration((Map)sessionsById, (BasicCache)cache, (SessionFunction)(offline ? SessionTimeouts::getOfflineSessionLifespanMs : SessionTimeouts::getUserSessionLifespanMs), (SessionFunction)(offline ? SessionTimeouts::getOfflineSessionMaxIdleMs : SessionTimeouts::getUserSessionMaxIdleMs))).isEmpty()) {
            return null;
        }
        RemoteCache remoteCache = InfinispanUtil.getRemoteCache(cache);
        if (remoteCache != null) {
            Map sessionsByIdForTransport = Stream.of(wrappedUserSessionEntity).map(SessionEntityWrapper::forTransport).collect(Collectors.toMap(sessionEntityWrapper -> ((UserSessionEntity)sessionEntityWrapper.getEntity()).getId(), Function.identity()));
            this.importSessionsWithExpiration(sessionsByIdForTransport, (BasicCache)remoteCache, (SessionFunction)(offline ? SessionTimeouts::getOfflineSessionLifespanMs : SessionTimeouts::getUserSessionLifespanMs), (SessionFunction)(offline ? SessionTimeouts::getOfflineSessionMaxIdleMs : SessionTimeouts::getUserSessionMaxIdleMs));
        }
        AdvancedCache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessCache = CacheDecorators.skipCacheLoadersIfRemoteStoreIsEnabled(offline ? this.offlineClientSessionCache : this.clientSessionCache);
        this.importSessionsWithExpiration((Map)clientSessionsById, (BasicCache)clientSessCache, (SessionFunction)(offline ? SessionTimeouts::getOfflineClientSessionLifespanMs : SessionTimeouts::getClientSessionLifespanMs), (SessionFunction)(offline ? SessionTimeouts::getOfflineClientSessionMaxIdleMs : SessionTimeouts::getClientSessionMaxIdleMs));
        RemoteCache remoteCacheClientSessions = InfinispanUtil.getRemoteCache(clientSessCache);
        if (remoteCacheClientSessions != null) {
            Map sessionsByIdForTransport = clientSessionsById.values().stream().map(SessionEntityWrapper::forTransport).collect(Collectors.toMap(sessionEntityWrapper -> ((AuthenticatedClientSessionEntity)sessionEntityWrapper.getEntity()).getId(), Function.identity()));
            this.importSessionsWithExpiration(sessionsByIdForTransport, (BasicCache)remoteCacheClientSessions, (SessionFunction)(offline ? SessionTimeouts::getOfflineClientSessionLifespanMs : SessionTimeouts::getClientSessionLifespanMs), (SessionFunction)(offline ? SessionTimeouts::getOfflineClientSessionMaxIdleMs : SessionTimeouts::getClientSessionMaxIdleMs));
        }
        return sessionsById.entrySet().stream().findFirst().map(Map.Entry::getValue).orElse(null);
    }

    private <T extends SessionEntity, K> Map<K, SessionEntityWrapper<T>> importSessionsWithExpiration(Map<K, SessionEntityWrapper<T>> sessionsById, BasicCache<K, SessionEntityWrapper<T>> cache, SessionFunction<T> lifespanMsCalculator, SessionFunction<T> maxIdleTimeMsCalculator) {
        return sessionsById.entrySet().stream().map(entry -> {
            Object sessionEntity = ((SessionEntityWrapper)entry.getValue()).getEntity();
            RealmModel currentRealm = this.session.realms().getRealm(((SessionEntity)sessionEntity).getRealmId());
            ClientModel client = ((SessionEntityWrapper)entry.getValue()).getClientIfNeeded(currentRealm);
            long lifespan = lifespanMsCalculator.apply(currentRealm, client, sessionEntity);
            long maxIdle = maxIdleTimeMsCalculator.apply(currentRealm, client, sessionEntity);
            if (lifespan != -2L && maxIdle != -2L) {
                if (cache instanceof RemoteCache) {
                    Retry.executeWithBackoff(iteration -> {
                        try {
                            cache.putIfAbsent(entry.getKey(), (Object)((SessionEntityWrapper)entry.getValue()), lifespan, TimeUnit.MILLISECONDS, maxIdle, TimeUnit.MILLISECONDS);
                        }
                        catch (HotRodClientException re) {
                            if (log.isDebugEnabled()) {
                                log.debugf((Throwable)re, "Failed to put import %d sessions to remoteCache. Iteration '%s'. Will try to retry the task", sessionsById.size(), iteration);
                            }
                            throw re;
                        }
                    }, (int)10, (int)10);
                } else {
                    cache.putIfAbsent(entry.getKey(), (Object)((SessionEntityWrapper)entry.getValue()), lifespan, TimeUnit.MILLISECONDS, maxIdle, TimeUnit.MILLISECONDS);
                }
                return entry;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private UserSessionEntity createUserSessionEntityInstance(UserSessionModel userSession) {
        UserSessionEntity entity = new UserSessionEntity(userSession.getId());
        entity.setRealmId(userSession.getRealm().getId());
        entity.setAuthMethod(userSession.getAuthMethod());
        entity.setBrokerSessionId(userSession.getBrokerSessionId());
        entity.setBrokerUserId(userSession.getBrokerUserId());
        entity.setIpAddress(userSession.getIpAddress());
        entity.setNotes(userSession.getNotes() == null ? new ConcurrentHashMap() : userSession.getNotes());
        entity.setAuthenticatedClientSessions(new AuthenticatedClientSessionStore());
        entity.setRememberMe(userSession.isRememberMe());
        entity.setState(userSession.getState());
        if (userSession instanceof OfflineUserSessionModel) {
            OfflineUserSessionModel offlineUserSession = (OfflineUserSessionModel)userSession;
            entity.setUser(offlineUserSession.getUserId());
        } else {
            entity.setLoginUsername(userSession.getLoginUsername());
            entity.setUser(userSession.getUser().getId());
        }
        entity.setStarted(userSession.getStarted());
        entity.setLastSessionRefresh(userSession.getLastSessionRefresh());
        entity.setOffline(userSession.isOffline());
        return entity;
    }

    private AuthenticatedClientSessionAdapter importOfflineClientSession(UserSessionAdapter sessionToImportInto, AuthenticatedClientSessionModel clientSession) {
        AuthenticatedClientSessionEntity entity = this.createAuthenticatedClientSessionInstance(sessionToImportInto.getId(), clientSession, sessionToImportInto.getRealm().getId(), clientSession.getClient().getId(), true);
        entity.setUserSessionId(sessionToImportInto.getId());
        entity.setTimestamp(sessionToImportInto.getLastSessionRefresh());
        UUID clientSessionId = entity.getId();
        SessionUpdateTask createClientSessionTask = Tasks.addIfAbsentSync();
        this.clientSessionTx.addTask(entity.getId(), createClientSessionTask, entity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        AuthenticatedClientSessionStore clientSessions = sessionToImportInto.getEntity().getAuthenticatedClientSessions();
        clientSessions.put(clientSession.getClient().getId(), clientSessionId);
        ClientSessionPersistentChangelogBasedTransaction.RegisterClientSessionTask registerClientSessionTask = new ClientSessionPersistentChangelogBasedTransaction.RegisterClientSessionTask(clientSession.getClient().getId(), clientSessionId, true);
        this.sessionTx.addTask(sessionToImportInto.getId(), registerClientSessionTask);
        return new AuthenticatedClientSessionAdapter(this.session, this, entity, clientSession.getClient(), sessionToImportInto, this.clientSessionTx, true);
    }

    private AuthenticatedClientSessionEntity createAuthenticatedClientSessionInstance(String userSessionId, AuthenticatedClientSessionModel clientSession, String realmId, String clientId, boolean offline) {
        UUID clientSessionId = PersistentUserSessionProvider.createClientSessionUUID(userSessionId, clientId);
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity(clientSessionId);
        entity.setRealmId(realmId);
        entity.setAction(clientSession.getAction());
        entity.setAuthMethod(clientSession.getProtocol());
        entity.setNotes(clientSession.getNotes() == null ? new ConcurrentHashMap() : clientSession.getNotes());
        entity.setClientId(clientId);
        entity.setRedirectUri(clientSession.getRedirectUri());
        entity.setTimestamp(clientSession.getTimestamp());
        entity.setOffline(offline);
        return entity;
    }

    public SessionEntityWrapper<UserSessionEntity> wrapPersistentEntity(RealmModel realm, boolean offline, UserSessionModel persistentUserSession) {
        UserSessionEntity userSessionEntity = this.createUserSessionEntityInstance(persistentUserSession);
        if (this.isUserSessionExpired(realm, userSessionEntity, offline)) {
            return null;
        }
        this.sessionTx.addTask(userSessionEntity.getId(), null, userSessionEntity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        for (Map.Entry entry : persistentUserSession.getAuthenticatedClientSessions().entrySet()) {
            String clientUUID = (String)entry.getKey();
            AuthenticatedClientSessionEntity clientSession = this.createAuthenticatedClientSessionInstance(persistentUserSession.getId(), (AuthenticatedClientSessionModel)entry.getValue(), userSessionEntity.getRealmId(), clientUUID, offline);
            clientSession.setUserSessionId(userSessionEntity.getId());
            ClientModel client = this.session.clients().getClientById(realm, clientSession.getClientId());
            if (this.isClientSessionExpired(realm, client, clientSession, offline)) continue;
            AuthenticatedClientSessionStore clientSessions = userSessionEntity.getAuthenticatedClientSessions();
            clientSessions.put(clientUUID, clientSession.getId());
            this.clientSessionTx.addTask(clientSession.getId(), null, clientSession, UserSessionModel.SessionPersistenceState.PERSISTENT);
        }
        return this.sessionTx.get(userSessionEntity.getId(), offline);
    }

    private boolean isClientSessionExpired(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity entity, boolean offline) {
        SessionFunction<AuthenticatedClientSessionEntity> idleChecker = offline ? SessionTimeouts::getOfflineClientSessionMaxIdleMs : SessionTimeouts::getClientSessionMaxIdleMs;
        SessionFunction<AuthenticatedClientSessionEntity> lifetimeChecker = offline ? SessionTimeouts::getOfflineClientSessionLifespanMs : SessionTimeouts::getClientSessionLifespanMs;
        return idleChecker.apply(realm, client, entity) == -2L || lifetimeChecker.apply(realm, client, entity) == -2L;
    }

    private boolean isUserSessionExpired(RealmModel realm, UserSessionEntity entity, boolean offline) {
        SessionFunction<UserSessionEntity> idleChecker = offline ? SessionTimeouts::getOfflineSessionMaxIdleMs : SessionTimeouts::getUserSessionMaxIdleMs;
        SessionFunction<UserSessionEntity> lifetimeChecker = offline ? SessionTimeouts::getOfflineSessionLifespanMs : SessionTimeouts::getUserSessionLifespanMs;
        return idleChecker.apply(realm, null, entity) == -2L || lifetimeChecker.apply(realm, null, entity) == -2L;
    }

    public static UUID createClientSessionUUID(String userSessionId, String clientId) {
        return UUID.nameUUIDFromBytes((userSessionId + clientId).getBytes(StandardCharsets.UTF_8));
    }

    public void migrate(String modelVersion) {
        if (new ModelVersion(modelVersion).equals((Object)new ModelVersion("25.0.0"))) {
            this.migrateNonPersistentSessionsToPersistentSessions();
        }
    }

    public void migrateNonPersistentSessionsToPersistentSessions() {
        JpaChangesPerformer userSessionPerformer = new JpaChangesPerformer(this.sessionCache.getName(), new ArrayBlockingQueue<PersistentUpdate>(1));
        JpaChangesPerformer<UUID, AuthenticatedClientSessionEntity> clientSessionPerformer = new JpaChangesPerformer<UUID, AuthenticatedClientSessionEntity>(this.clientSessionCache.getName(), new ArrayBlockingQueue<PersistentUpdate>(1));
        AtomicInteger currentBatch = new AtomicInteger(0);
        PersistenceManager persistence = (PersistenceManager)ComponentRegistry.componentOf(this.sessionCache, PersistenceManager.class);
        if (persistence != null && !persistence.getStoresAsString().isEmpty()) {
            ByRef ref = ByRef.create(null);
            Flowable.fromPublisher((Publisher)persistence.publishEntries(true, false)).blockingSubscribe(e -> this.processEntryFromCache((SessionEntityWrapper)e.getValue(), userSessionPerformer, clientSessionPerformer, currentBatch), arg_0 -> ((ByRef)ref).set(arg_0));
            if (ref.get() != null) {
                throw new RuntimeException("Unable to migrate sessions", (Throwable)ref.get());
            }
        } else {
            this.sessionCache.forEach((key, value) -> this.processEntryFromCache((SessionEntityWrapper<UserSessionEntity>)value, userSessionPerformer, clientSessionPerformer, currentBatch));
        }
        this.flush(userSessionPerformer, clientSessionPerformer);
        this.sessionCache.clear();
        this.clientSessionCache.clear();
        this.offlineSessionCache.clear();
        this.offlineClientSessionCache.clear();
        log.infof("Migrated %d user sessions total.", (Object)currentBatch.intValue());
    }

    private void processEntryFromCache(SessionEntityWrapper<UserSessionEntity> sessionEntityWrapper, JpaChangesPerformer<String, UserSessionEntity> userSessionPerformer, JpaChangesPerformer<UUID, AuthenticatedClientSessionEntity> clientSessionPerformer, AtomicInteger count) {
        RealmModel realm = this.session.realms().getRealm(sessionEntityWrapper.getEntity().getRealmId());
        if (realm == null) {
            return;
        }
        sessionEntityWrapper.getEntity().getAuthenticatedClientSessions().forEach((clientId, uuid) -> {
            SessionEntityWrapper clientSession = (SessionEntityWrapper)this.clientSessionCache.get(uuid);
            if (clientSession != null) {
                if (((AuthenticatedClientSessionEntity)clientSession.getEntity()).getClientId() == null) {
                    ((AuthenticatedClientSessionEntity)clientSession.getEntity()).setClientId((String)clientId);
                }
                ((AuthenticatedClientSessionEntity)clientSession.getEntity()).setUserSessionId(((UserSessionEntity)sessionEntityWrapper.getEntity()).getId());
                MergedUpdate merged = MergedUpdate.computeUpdate(Collections.singletonList(Tasks.addIfAbsentSync()), clientSession, 1L, 1L);
                clientSessionPerformer.registerChange(Map.entry(uuid, new SessionUpdatesList(realm, clientSession)), merged);
            }
        });
        MergedUpdate<UserSessionEntity> merged = MergedUpdate.computeUpdate(Collections.singletonList(Tasks.addIfAbsentSync()), sessionEntityWrapper, 1L, 1L);
        userSessionPerformer.registerChange(Map.entry(sessionEntityWrapper.getEntity().getId(), new SessionUpdatesList<UserSessionEntity>(realm, sessionEntityWrapper)), merged);
        if (count.incrementAndGet() % 100 == 0) {
            this.flush(userSessionPerformer, clientSessionPerformer);
        }
        if (count.intValue() % 1000 == 0) {
            log.infof("Migrated %d user sessions total, continuing...", (Object)count.intValue());
        }
    }

    private <E extends SessionEntity, K> void flush(JpaChangesPerformer<K, E> userSessionsPerformer, JpaChangesPerformer<UUID, AuthenticatedClientSessionEntity> clientSessionPerformer) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), s -> {
            userSessionsPerformer.applyChangesSynchronously(s);
            clientSessionPerformer.applyChangesSynchronously(s);
        });
    }
}

