/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.util.Assert;

public class GeometryCollection
extends Geometry {
    private static final long serialVersionUID = -5694727726395021467L;
    protected Geometry[] geometries;

    public GeometryCollection(Geometry[] geometries, PrecisionModel precisionModel, int SRID) {
        this(geometries, new GeometryFactory(precisionModel, SRID));
    }

    public GeometryCollection(Geometry[] geometries, GeometryFactory factory) {
        super(factory);
        if (geometries == null) {
            geometries = new Geometry[]{};
        }
        if (GeometryCollection.hasNullElements(geometries)) {
            throw new IllegalArgumentException("geometries must not contain null elements");
        }
        this.geometries = geometries;
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries[0].getCoordinate();
    }

    @Override
    public Coordinate[] getCoordinates() {
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            Coordinate[] childCoordinates = this.geometries[i].getCoordinates();
            for (int j = 0; j < childCoordinates.length; ++j) {
                coordinates[++k] = childCoordinates[j];
            }
        }
        return coordinates;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.geometries.length; ++i) {
            if (this.geometries[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getDimension() {
        int dimension = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            dimension = Math.max(dimension, this.geometries[i].getDimension());
        }
        return dimension;
    }

    @Override
    public int getBoundaryDimension() {
        int dimension = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            dimension = Math.max(dimension, this.geometries[i].getBoundaryDimension());
        }
        return dimension;
    }

    @Override
    public int getNumGeometries() {
        return this.geometries.length;
    }

    @Override
    public Geometry getGeometryN(int n) {
        return this.geometries[n];
    }

    @Override
    public int getNumPoints() {
        int numPoints = 0;
        for (int i = 0; i < this.geometries.length; ++i) {
            numPoints += this.geometries[i].getNumPoints();
        }
        return numPoints;
    }

    @Override
    public String getGeometryType() {
        return "GeometryCollection";
    }

    @Override
    public Geometry getBoundary() {
        GeometryCollection.checkNotGeometryCollection(this);
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    public double getArea() {
        double area = 0.0;
        for (int i = 0; i < this.geometries.length; ++i) {
            area += this.geometries[i].getArea();
        }
        return area;
    }

    @Override
    public double getLength() {
        double sum = 0.0;
        for (int i = 0; i < this.geometries.length; ++i) {
            sum += this.geometries[i].getLength();
        }
        return sum;
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        GeometryCollection otherCollection = (GeometryCollection)other;
        if (this.geometries.length != otherCollection.geometries.length) {
            return false;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            if (this.geometries[i].equalsExact(otherCollection.geometries[i], tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(CoordinateFilter filter) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(filter);
        }
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        if (this.geometries.length == 0) {
            return;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(filter);
            if (filter.isDone()) break;
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter filter) {
        filter.filter(this);
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(filter);
        }
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(filter);
        }
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    protected GeometryCollection copyInternal() {
        Geometry[] geometries = new Geometry[this.geometries.length];
        for (int i = 0; i < geometries.length; ++i) {
            geometries[i] = this.geometries[i].copy();
        }
        return new GeometryCollection(geometries, this.factory);
    }

    @Override
    public void normalize() {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].normalize();
        }
        Arrays.sort(this.geometries);
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        Envelope envelope = new Envelope();
        for (int i = 0; i < this.geometries.length; ++i) {
            envelope.expandToInclude(this.geometries[i].getEnvelopeInternal());
        }
        return envelope;
    }

    @Override
    protected int compareToSameClass(Object o) {
        TreeSet<Geometry> theseElements = new TreeSet<Geometry>(Arrays.asList(this.geometries));
        TreeSet<Geometry> otherElements = new TreeSet<Geometry>(Arrays.asList(((GeometryCollection)o).geometries));
        return this.compare(theseElements, otherElements);
    }

    @Override
    protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
        int i;
        GeometryCollection gc = (GeometryCollection)o;
        int n1 = this.getNumGeometries();
        int n2 = gc.getNumGeometries();
        for (i = 0; i < n1 && i < n2; ++i) {
            Geometry otherGeom;
            Geometry thisGeom = this.getGeometryN(i);
            int holeComp = thisGeom.compareToSameClass(otherGeom = gc.getGeometryN(i), comp);
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i < n1) {
            return 1;
        }
        if (i < n2) {
            return -1;
        }
        return 0;
    }

    @Override
    protected int getTypeCode() {
        return 7;
    }

    @Override
    public Geometry reverse() {
        return super.reverse();
    }

    @Override
    protected Geometry reverseInternal() {
        int numGeometries = this.geometries.length;
        ArrayList<Geometry> reversed = new ArrayList<Geometry>(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            reversed.add(this.geometries[i].reverse());
        }
        return this.getFactory().buildGeometry(reversed);
    }
}

