/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.PropertiesConfigSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

public class ConfigArgsConfigSource
extends PropertiesConfigSource {
    public static final Set<String> SHORT_OPTIONS_ACCEPTING_VALUE = Set.of("-pf", "-cf");
    public static final String CLI_ARGS = "kc.config.args";
    public static final String NAME = "CliConfigSource";
    private static final String ARG_SEPARATOR = ";;";
    private static final Pattern ARG_KEY_VALUE_SPLIT = Pattern.compile("=");

    protected ConfigArgsConfigSource() {
        super(ConfigArgsConfigSource.parseArguments(), NAME, 600);
    }

    public static void setCliArgs(String ... args) {
        System.setProperty(CLI_ARGS, String.join((CharSequence)ARG_SEPARATOR, args));
    }

    public static List<String> getAllCliArgs() {
        if (System.getProperty(CLI_ARGS) == null) {
            return Collections.emptyList();
        }
        return List.of(System.getProperty(CLI_ARGS).split(ARG_SEPARATOR));
    }

    private static String getRawConfigArgs() {
        String args = System.getProperty(CLI_ARGS);
        if (args != null) {
            return args;
        }
        return String.join((CharSequence)ARG_SEPARATOR, System.getProperty("quarkus.args", "").split(" "));
    }

    public String getValue(String propertyName) {
        Map properties = this.getProperties();
        String value = (String)properties.get(propertyName);
        if (value != null) {
            return value;
        }
        return (String)properties.get(propertyName.replace('-', '.'));
    }

    private static Map<String, String> parseArguments() {
        String rawArgs = ConfigArgsConfigSource.getRawConfigArgs();
        if (rawArgs == null || "".equals(rawArgs.trim())) {
            return Collections.emptyMap();
        }
        final HashMap<String, String> properties = new HashMap<String, String>();
        ConfigArgsConfigSource.parseConfigArgs(ConfigArgsConfigSource.getAllCliArgs(), new BiConsumer<String, String>(){

            @Override
            public void accept(String key, String value) {
                key = "kc." + ((String)key).substring(2);
                properties.put(key, value);
                PropertyMapper<?> mapper = PropertyMappers.getMapper((String)key);
                if (mapper != null) {
                    String to = mapper.getTo();
                    if (to != null) {
                        properties.put(mapper.getTo(), value);
                    }
                    properties.put(mapper.getFrom(), value);
                }
            }
        }, ignored -> {});
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void parseConfigArgs(List<String> args, BiConsumer<String, String> valueArgConsumer, Consumer<String> unaryConsumer) {
        int i = 0;
        while (true) {
            block3: {
                String value;
                String key;
                block7: {
                    String[] keyValue;
                    block4: {
                        String arg;
                        block6: {
                            block5: {
                                block2: {
                                    if (i >= args.size()) {
                                        return;
                                    }
                                    arg = args.get(i);
                                    if (arg.startsWith("-")) break block2;
                                    unaryConsumer.accept(arg);
                                    break block3;
                                }
                                keyValue = ARG_KEY_VALUE_SPLIT.split(arg, 2);
                                key = keyValue[0];
                                if (keyValue.length != 1) break block4;
                                if (args.size() > i + 1) break block5;
                                unaryConsumer.accept(arg);
                                break block3;
                            }
                            PropertyMapper<?> mapper = PropertyMappers.getMapper(key);
                            if (mapper == null && !SHORT_OPTIONS_ACCEPTING_VALUE.contains(key) && !arg.startsWith("--spi")) break block6;
                            value = args.get(++i);
                            break block7;
                        }
                        unaryConsumer.accept(arg);
                        break block3;
                    }
                    value = keyValue[1];
                }
                valueArgConsumer.accept(key, value);
            }
            ++i;
        }
    }
}

