/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DisplayObject {
    @JsonIgnore
    private static final String NAME_KEY = "name";
    @JsonIgnore
    private static final String LOCALE_KEY = "locale";
    @JsonIgnore
    private static final String LOGO_KEY = "logo";
    @JsonIgnore
    private static final String DESCRIPTION_KEY = "description";
    @JsonIgnore
    private static final String BG_COLOR_KEY = "background_color";
    @JsonIgnore
    private static final String TEXT_COLOR_KEY = "text_color";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="locale")
    private String locale;
    @JsonProperty(value="logo")
    private String logo;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="background_color")
    private String backgroundColor;
    @JsonProperty(value="text_color")
    private String textColor;

    public String getName() {
        return this.name;
    }

    public DisplayObject setName(String name) {
        this.name = name;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public DisplayObject setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public String getLogo() {
        return this.logo;
    }

    public DisplayObject setLogo(String logo) {
        this.logo = logo;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public DisplayObject setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public DisplayObject setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public DisplayObject setTextColor(String textColor) {
        this.textColor = textColor;
        return this;
    }

    public Map<String, String> toDotNotation() {
        HashMap<String, String> dotNotation = new HashMap<String, String>();
        dotNotation.put(NAME_KEY, this.name);
        dotNotation.put(LOCALE_KEY, this.locale);
        dotNotation.put(LOGO_KEY, this.logo);
        dotNotation.put(DESCRIPTION_KEY, this.description);
        dotNotation.put(BG_COLOR_KEY, this.backgroundColor);
        dotNotation.put(TEXT_COLOR_KEY, this.textColor);
        return dotNotation;
    }

    public static DisplayObject fromDotNotation(Map<String, String> dotNotated) {
        DisplayObject displayObject = new DisplayObject();
        Optional.ofNullable(dotNotated.get(NAME_KEY)).ifPresent(displayObject::setName);
        Optional.ofNullable(dotNotated.get(LOCALE_KEY)).ifPresent(displayObject::setLocale);
        Optional.ofNullable(dotNotated.get(LOGO_KEY)).ifPresent(displayObject::setLogo);
        Optional.ofNullable(dotNotated.get(DESCRIPTION_KEY)).ifPresent(displayObject::setDescription);
        Optional.ofNullable(dotNotated.get(BG_COLOR_KEY)).ifPresent(displayObject::setBackgroundColor);
        Optional.ofNullable(dotNotated.get(TEXT_COLOR_KEY)).ifPresent(displayObject::setTextColor);
        return displayObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisplayObject)) {
            return false;
        }
        DisplayObject that = (DisplayObject)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getLocale() != null ? !this.getLocale().equals(that.getLocale()) : that.getLocale() != null) {
            return false;
        }
        if (this.getLogo() != null ? !this.getLogo().equals(that.getLogo()) : that.getLogo() != null) {
            return false;
        }
        if (this.getDescription() != null ? !this.getDescription().equals(that.getDescription()) : that.getDescription() != null) {
            return false;
        }
        if (this.getBackgroundColor() != null ? !this.getBackgroundColor().equals(that.getBackgroundColor()) : that.getBackgroundColor() != null) {
            return false;
        }
        return this.getTextColor() != null ? this.getTextColor().equals(that.getTextColor()) : that.getTextColor() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + (this.getLocale() != null ? this.getLocale().hashCode() : 0);
        result = 31 * result + (this.getLogo() != null ? this.getLogo().hashCode() : 0);
        result = 31 * result + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
        result = 31 * result + (this.getBackgroundColor() != null ? this.getBackgroundColor().hashCode() : 0);
        result = 31 * result + (this.getTextColor() != null ? this.getTextColor().hashCode() : 0);
        return result;
    }
}

