/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.internal.jta.recovery.arjunacore.NameScopedElement;
import java.util.Objects;
import javax.transaction.xa.XAResource;

public class NameScopedXAResource
implements NameScopedElement {
    private final XAResource xaResource;
    private final String jndiName;

    public NameScopedXAResource(XAResource xaResource, String jndiName) {
        this.xaResource = xaResource;
        this.jndiName = jndiName;
    }

    public XAResource getXaResource() {
        return this.xaResource;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public boolean isSameName(NameScopedElement other) {
        return this.jndiName != null && this.jndiName.equals(other.getJndiName());
    }

    @Override
    public boolean isAnonymous() {
        return this.jndiName == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameScopedXAResource that = (NameScopedXAResource)o;
        return this.xaResource.equals(that.xaResource) && Objects.equals(this.jndiName, that.jndiName);
    }

    public int hashCode() {
        return Objects.hash(this.xaResource, this.jndiName);
    }

    public String toString() {
        return "NameScopedXAResource{xaResource=" + this.xaResource + ", jndiName='" + this.jndiName + "'}";
    }
}

