/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.singlefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.exportimport.AbstractFileBasedImportProvider;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.util.ExportImportSessionTask;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.util.JsonSerialization;

public class SingleFileImportProvider
extends AbstractFileBasedImportProvider {
    private static final Logger logger = Logger.getLogger(SingleFileImportProvider.class);
    private final KeycloakSessionFactory factory;
    private final File file;
    private final Strategy strategy;
    protected Map<String, RealmRepresentation> realmReps;

    public SingleFileImportProvider(KeycloakSessionFactory factory, File file, Strategy strategy) {
        this.factory = factory;
        this.file = file;
        this.strategy = strategy;
    }

    public void importModel() throws IOException {
        logger.infof("Full importing from file %s", (Object)this.file.getAbsolutePath());
        this.checkRealmReps();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.factory, (KeycloakSessionTask)new ExportImportSessionTask(){

            @Override
            protected void runExportImportTask(KeycloakSession session) {
                ImportUtils.importRealms(session, SingleFileImportProvider.this.realmReps.values(), SingleFileImportProvider.this.strategy);
            }
        });
    }

    public boolean isMasterRealmExported() throws IOException {
        this.checkRealmReps();
        return this.realmReps.containsKey(Config.getAdminRealm());
    }

    protected void checkRealmReps() throws IOException {
        if (this.realmReps == null) {
            InputStream is = this.parseFile(this.file);
            this.realmReps = ImportUtils.getRealmsFromStream(JsonSerialization.mapper, is);
        }
    }

    public void close() {
    }
}

