/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.border;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.keys.border.BorderWidth;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.stylehandler.AbstractWidthReadHandler;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class BorderWidthReadHandler
extends AbstractWidthReadHandler
implements CSSCompoundValueReadHandler {
    public BorderWidthReadHandler() {
        super(true, false);
    }

    protected BorderWidthReadHandler(boolean bl, boolean bl2) {
        super(bl, bl2);
    }

    @Override
    protected CSSValue parseWidth(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() == 35) {
            if ("thin".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return BorderWidth.THIN;
            }
            if ("medium".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return BorderWidth.MEDIUM;
            }
            if ("thick".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return BorderWidth.THICK;
            }
        }
        return super.parseWidth(lexicalUnit);
    }

    @Override
    public Map createValues(LexicalUnit lexicalUnit) {
        CSSValue cSSValue;
        CSSValue cSSValue2;
        CSSValue cSSValue3;
        CSSValue cSSValue4 = this.parseWidth(lexicalUnit);
        if (cSSValue4 == null) {
            return null;
        }
        if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
            cSSValue3 = cSSValue4;
        } else {
            cSSValue3 = this.parseWidth(lexicalUnit);
            if (cSSValue3 == null) {
                return null;
            }
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
        if (lexicalUnit == null) {
            cSSValue2 = cSSValue4;
        } else {
            cSSValue2 = this.parseWidth(lexicalUnit);
            if (cSSValue2 == null) {
                return null;
            }
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
        if (lexicalUnit == null) {
            cSSValue = cSSValue3;
        } else {
            cSSValue = this.parseWidth(lexicalUnit);
            if (cSSValue == null) {
                return null;
            }
        }
        HashMap<StyleKey, CSSValue> hashMap = new HashMap<StyleKey, CSSValue>();
        hashMap.put(BorderStyleKeys.BORDER_TOP_WIDTH, cSSValue4);
        hashMap.put(BorderStyleKeys.BORDER_RIGHT_WIDTH, cSSValue3);
        hashMap.put(BorderStyleKeys.BORDER_BOTTOM_WIDTH, cSSValue2);
        hashMap.put(BorderStyleKeys.BORDER_LEFT_WIDTH, cSSValue);
        return hashMap;
    }

    @Override
    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{BorderStyleKeys.BORDER_TOP_WIDTH, BorderStyleKeys.BORDER_RIGHT_WIDTH, BorderStyleKeys.BORDER_BOTTOM_WIDTH, BorderStyleKeys.BORDER_LEFT_WIDTH};
    }
}

