/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUdevprop
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXTHREADSPERBLOCK;
    public static final int MAXTHREADSDIM;
    public static final int MAXGRIDSIZE;
    public static final int SHAREDMEMPERBLOCK;
    public static final int TOTALCONSTANTMEMORY;
    public static final int SIMDWIDTH;
    public static final int MEMPITCH;
    public static final int REGSPERBLOCK;
    public static final int CLOCKRATE;
    public static final int TEXTUREALIGN;

    public CUdevprop(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUdevprop.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int maxThreadsPerBlock() {
        return CUdevprop.nmaxThreadsPerBlock(this.address());
    }

    @NativeType(value="int[3]")
    public IntBuffer maxThreadsDim() {
        return CUdevprop.nmaxThreadsDim(this.address());
    }

    public int maxThreadsDim(int index) {
        return CUdevprop.nmaxThreadsDim(this.address(), index);
    }

    @NativeType(value="int[3]")
    public IntBuffer maxGridSize() {
        return CUdevprop.nmaxGridSize(this.address());
    }

    public int maxGridSize(int index) {
        return CUdevprop.nmaxGridSize(this.address(), index);
    }

    public int sharedMemPerBlock() {
        return CUdevprop.nsharedMemPerBlock(this.address());
    }

    public int totalConstantMemory() {
        return CUdevprop.ntotalConstantMemory(this.address());
    }

    public int SIMDWidth() {
        return CUdevprop.nSIMDWidth(this.address());
    }

    public int memPitch() {
        return CUdevprop.nmemPitch(this.address());
    }

    public int regsPerBlock() {
        return CUdevprop.nregsPerBlock(this.address());
    }

    public int clockRate() {
        return CUdevprop.nclockRate(this.address());
    }

    public int textureAlign() {
        return CUdevprop.ntextureAlign(this.address());
    }

    public CUdevprop maxThreadsPerBlock(int value) {
        CUdevprop.nmaxThreadsPerBlock(this.address(), value);
        return this;
    }

    public CUdevprop maxThreadsDim(@NativeType(value="int[3]") IntBuffer value) {
        CUdevprop.nmaxThreadsDim(this.address(), value);
        return this;
    }

    public CUdevprop maxThreadsDim(int index, int value) {
        CUdevprop.nmaxThreadsDim(this.address(), index, value);
        return this;
    }

    public CUdevprop maxGridSize(@NativeType(value="int[3]") IntBuffer value) {
        CUdevprop.nmaxGridSize(this.address(), value);
        return this;
    }

    public CUdevprop maxGridSize(int index, int value) {
        CUdevprop.nmaxGridSize(this.address(), index, value);
        return this;
    }

    public CUdevprop sharedMemPerBlock(int value) {
        CUdevprop.nsharedMemPerBlock(this.address(), value);
        return this;
    }

    public CUdevprop totalConstantMemory(int value) {
        CUdevprop.ntotalConstantMemory(this.address(), value);
        return this;
    }

    public CUdevprop SIMDWidth(int value) {
        CUdevprop.nSIMDWidth(this.address(), value);
        return this;
    }

    public CUdevprop memPitch(int value) {
        CUdevprop.nmemPitch(this.address(), value);
        return this;
    }

    public CUdevprop regsPerBlock(int value) {
        CUdevprop.nregsPerBlock(this.address(), value);
        return this;
    }

    public CUdevprop clockRate(int value) {
        CUdevprop.nclockRate(this.address(), value);
        return this;
    }

    public CUdevprop textureAlign(int value) {
        CUdevprop.ntextureAlign(this.address(), value);
        return this;
    }

    public CUdevprop set(int maxThreadsPerBlock, IntBuffer maxThreadsDim, IntBuffer maxGridSize, int sharedMemPerBlock, int totalConstantMemory, int SIMDWidth, int memPitch, int regsPerBlock, int clockRate, int textureAlign) {
        this.maxThreadsPerBlock(maxThreadsPerBlock);
        this.maxThreadsDim(maxThreadsDim);
        this.maxGridSize(maxGridSize);
        this.sharedMemPerBlock(sharedMemPerBlock);
        this.totalConstantMemory(totalConstantMemory);
        this.SIMDWidth(SIMDWidth);
        this.memPitch(memPitch);
        this.regsPerBlock(regsPerBlock);
        this.clockRate(clockRate);
        this.textureAlign(textureAlign);
        return this;
    }

    public CUdevprop set(CUdevprop src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUdevprop malloc() {
        return (CUdevprop)CUdevprop.wrap(CUdevprop.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUdevprop calloc() {
        return (CUdevprop)CUdevprop.wrap(CUdevprop.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUdevprop create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUdevprop)CUdevprop.wrap(CUdevprop.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUdevprop create(long address) {
        return (CUdevprop)CUdevprop.wrap(CUdevprop.class, (long)address);
    }

    @Nullable
    public static CUdevprop createSafe(long address) {
        return address == 0L ? null : (CUdevprop)CUdevprop.wrap(CUdevprop.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUdevprop.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUdevprop.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUdevprop.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUdevprop.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUdevprop.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUdevprop.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUdevprop.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static CUdevprop mallocStack() {
        return CUdevprop.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUdevprop callocStack() {
        return CUdevprop.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUdevprop mallocStack(MemoryStack stack) {
        return CUdevprop.malloc(stack);
    }

    @Deprecated
    public static CUdevprop callocStack(MemoryStack stack) {
        return CUdevprop.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUdevprop.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUdevprop.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUdevprop.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUdevprop.calloc(capacity, stack);
    }

    public static CUdevprop malloc(MemoryStack stack) {
        return (CUdevprop)CUdevprop.wrap(CUdevprop.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUdevprop calloc(MemoryStack stack) {
        return (CUdevprop)CUdevprop.wrap(CUdevprop.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CUdevprop.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CUdevprop.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nmaxThreadsPerBlock(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXTHREADSPERBLOCK);
    }

    public static IntBuffer nmaxThreadsDim(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)MAXTHREADSDIM), (int)3);
    }

    public static int nmaxThreadsDim(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)MAXTHREADSDIM + Checks.check((int)index, (int)3) * 4L);
    }

    public static IntBuffer nmaxGridSize(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)MAXGRIDSIZE), (int)3);
    }

    public static int nmaxGridSize(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)MAXGRIDSIZE + Checks.check((int)index, (int)3) * 4L);
    }

    public static int nsharedMemPerBlock(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHAREDMEMPERBLOCK);
    }

    public static int ntotalConstantMemory(long struct) {
        return UNSAFE.getInt(null, struct + (long)TOTALCONSTANTMEMORY);
    }

    public static int nSIMDWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIMDWIDTH);
    }

    public static int nmemPitch(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMPITCH);
    }

    public static int nregsPerBlock(long struct) {
        return UNSAFE.getInt(null, struct + (long)REGSPERBLOCK);
    }

    public static int nclockRate(long struct) {
        return UNSAFE.getInt(null, struct + (long)CLOCKRATE);
    }

    public static int ntextureAlign(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEXTUREALIGN);
    }

    public static void nmaxThreadsPerBlock(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXTHREADSPERBLOCK, value);
    }

    public static void nmaxThreadsDim(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)MAXTHREADSDIM), (long)(value.remaining() * 4));
    }

    public static void nmaxThreadsDim(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)MAXTHREADSDIM + Checks.check((int)index, (int)3) * 4L, value);
    }

    public static void nmaxGridSize(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)MAXGRIDSIZE), (long)(value.remaining() * 4));
    }

    public static void nmaxGridSize(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)MAXGRIDSIZE + Checks.check((int)index, (int)3) * 4L, value);
    }

    public static void nsharedMemPerBlock(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHAREDMEMPERBLOCK, value);
    }

    public static void ntotalConstantMemory(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TOTALCONSTANTMEMORY, value);
    }

    public static void nSIMDWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIMDWIDTH, value);
    }

    public static void nmemPitch(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMPITCH, value);
    }

    public static void nregsPerBlock(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REGSPERBLOCK, value);
    }

    public static void nclockRate(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CLOCKRATE, value);
    }

    public static void ntextureAlign(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TEXTUREALIGN, value);
    }

    static {
        Struct.Layout layout = CUdevprop.__struct((Struct.Member[])new Struct.Member[]{CUdevprop.__member((int)4), CUdevprop.__array((int)4, (int)3), CUdevprop.__array((int)4, (int)3), CUdevprop.__member((int)4), CUdevprop.__member((int)4), CUdevprop.__member((int)4), CUdevprop.__member((int)4), CUdevprop.__member((int)4), CUdevprop.__member((int)4), CUdevprop.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXTHREADSPERBLOCK = layout.offsetof(0);
        MAXTHREADSDIM = layout.offsetof(1);
        MAXGRIDSIZE = layout.offsetof(2);
        SHAREDMEMPERBLOCK = layout.offsetof(3);
        TOTALCONSTANTMEMORY = layout.offsetof(4);
        SIMDWIDTH = layout.offsetof(5);
        MEMPITCH = layout.offsetof(6);
        REGSPERBLOCK = layout.offsetof(7);
        CLOCKRATE = layout.offsetof(8);
        TEXTUREALIGN = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<CUdevprop, Buffer>
    implements NativeResource {
        private static final CUdevprop ELEMENT_FACTORY = CUdevprop.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUdevprop getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int maxThreadsPerBlock() {
            return CUdevprop.nmaxThreadsPerBlock(this.address());
        }

        @NativeType(value="int[3]")
        public IntBuffer maxThreadsDim() {
            return CUdevprop.nmaxThreadsDim(this.address());
        }

        public int maxThreadsDim(int index) {
            return CUdevprop.nmaxThreadsDim(this.address(), index);
        }

        @NativeType(value="int[3]")
        public IntBuffer maxGridSize() {
            return CUdevprop.nmaxGridSize(this.address());
        }

        public int maxGridSize(int index) {
            return CUdevprop.nmaxGridSize(this.address(), index);
        }

        public int sharedMemPerBlock() {
            return CUdevprop.nsharedMemPerBlock(this.address());
        }

        public int totalConstantMemory() {
            return CUdevprop.ntotalConstantMemory(this.address());
        }

        public int SIMDWidth() {
            return CUdevprop.nSIMDWidth(this.address());
        }

        public int memPitch() {
            return CUdevprop.nmemPitch(this.address());
        }

        public int regsPerBlock() {
            return CUdevprop.nregsPerBlock(this.address());
        }

        public int clockRate() {
            return CUdevprop.nclockRate(this.address());
        }

        public int textureAlign() {
            return CUdevprop.ntextureAlign(this.address());
        }

        public Buffer maxThreadsPerBlock(int value) {
            CUdevprop.nmaxThreadsPerBlock(this.address(), value);
            return this;
        }

        public Buffer maxThreadsDim(@NativeType(value="int[3]") IntBuffer value) {
            CUdevprop.nmaxThreadsDim(this.address(), value);
            return this;
        }

        public Buffer maxThreadsDim(int index, int value) {
            CUdevprop.nmaxThreadsDim(this.address(), index, value);
            return this;
        }

        public Buffer maxGridSize(@NativeType(value="int[3]") IntBuffer value) {
            CUdevprop.nmaxGridSize(this.address(), value);
            return this;
        }

        public Buffer maxGridSize(int index, int value) {
            CUdevprop.nmaxGridSize(this.address(), index, value);
            return this;
        }

        public Buffer sharedMemPerBlock(int value) {
            CUdevprop.nsharedMemPerBlock(this.address(), value);
            return this;
        }

        public Buffer totalConstantMemory(int value) {
            CUdevprop.ntotalConstantMemory(this.address(), value);
            return this;
        }

        public Buffer SIMDWidth(int value) {
            CUdevprop.nSIMDWidth(this.address(), value);
            return this;
        }

        public Buffer memPitch(int value) {
            CUdevprop.nmemPitch(this.address(), value);
            return this;
        }

        public Buffer regsPerBlock(int value) {
            CUdevprop.nregsPerBlock(this.address(), value);
            return this;
        }

        public Buffer clockRate(int value) {
            CUdevprop.nclockRate(this.address(), value);
            return this;
        }

        public Buffer textureAlign(int value) {
            CUdevprop.ntextureAlign(this.address(), value);
            return this;
        }
    }
}

