/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.sitemap.validation;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.openhab.core.model.sitemap.sitemap.Button;
import org.openhab.core.model.sitemap.sitemap.Buttongrid;
import org.openhab.core.model.sitemap.sitemap.Frame;
import org.openhab.core.model.sitemap.sitemap.Input;
import org.openhab.core.model.sitemap.sitemap.LinkableWidget;
import org.openhab.core.model.sitemap.sitemap.Setpoint;
import org.openhab.core.model.sitemap.sitemap.Sitemap;
import org.openhab.core.model.sitemap.sitemap.SitemapPackage;
import org.openhab.core.model.sitemap.sitemap.Widget;
import org.openhab.core.model.sitemap.validation.AbstractSitemapValidator;

public class SitemapValidator
extends AbstractSitemapValidator {
    private final List<String> ALLOWED_HINTS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"text", "number", "date", "time", "datetime"}));

    @Check
    public void checkFramesInFrame(Frame frame) {
        EList<Widget> _children = frame.getChildren();
        for (Widget w : _children) {
            if (w instanceof Frame) {
                this.error("Frames must not contain other frames", SitemapPackage.Literals.FRAME.getEStructuralFeature(9));
                return;
            }
            if (!(w instanceof Button)) continue;
            this.error("Frames should not contain Button, Button is allowed only in Buttongrid", SitemapPackage.Literals.FRAME.getEStructuralFeature(9));
            return;
        }
    }

    @Check
    public void checkFramesInWidgetList(Sitemap sitemap) {
        boolean containsFrames = false;
        boolean containsOtherWidgets = false;
        EList<Widget> _children = sitemap.getChildren();
        for (Widget w : _children) {
            if (w instanceof Button) {
                this.error("Sitemap should not contain Button, Button is allowed only in Buttongrid", SitemapPackage.Literals.SITEMAP.getEStructuralFeature(0));
                return;
            }
            if (w instanceof Frame) {
                containsFrames = true;
            } else {
                containsOtherWidgets = true;
            }
            if (!containsFrames || !containsOtherWidgets) continue;
            this.error("Sitemap should contain either only frames or none at all", SitemapPackage.Literals.SITEMAP.getEStructuralFeature(0));
            return;
        }
    }

    @Check
    public void checkFramesInWidgetList(LinkableWidget widget) {
        if (widget instanceof Frame) {
            return;
        }
        if (widget instanceof Buttongrid) {
            return;
        }
        boolean containsFrames = false;
        boolean containsOtherWidgets = false;
        EList<Widget> _children = widget.getChildren();
        for (Widget w : _children) {
            if (w instanceof Button) {
                this.error("Linkable widget should not contain Button, Button is allowed only in Buttongrid", SitemapPackage.Literals.FRAME.getEStructuralFeature(9));
                return;
            }
            if (w instanceof Frame) {
                containsFrames = true;
            } else {
                containsOtherWidgets = true;
            }
            if (!containsFrames || !containsOtherWidgets) continue;
            this.error("Linkable widget should contain either only frames or none at all", SitemapPackage.Literals.FRAME.getEStructuralFeature(9));
            return;
        }
    }

    @Check
    public void checkWidgetsInButtongrid(Buttongrid grid) {
        int nb = grid.getButtons().size();
        if (nb > 0 && grid.getItem() == null) {
            this.error("To use the \"buttons\" parameter in a Buttongrid, the \"item\" parameter is required", SitemapPackage.Literals.BUTTONGRID.getEStructuralFeature(0));
        }
        EList<Widget> _children = grid.getChildren();
        for (Widget w : _children) {
            if (w instanceof Button) continue;
            this.error("Buttongrid must contain only Button", SitemapPackage.Literals.BUTTONGRID.getEStructuralFeature(9));
            return;
        }
    }

    @Check
    public void checkSetpoints(Setpoint sp) {
        BigDecimal _step = sp.getStep();
        boolean _equals = Objects.equals(BigDecimal.ZERO, _step);
        if (_equals) {
            String _item = sp.getItem();
            String _plus = "Setpoint on item '" + _item;
            String _plus_1 = _plus + "' has step size of 0";
            this.error(_plus_1, SitemapPackage.Literals.SETPOINT.getEStructuralFeature(11));
        }
        if (sp.getStep() != null && sp.getStep().compareTo(BigDecimal.ZERO) < 0) {
            String _item_1 = sp.getItem();
            String _plus_2 = "Setpoint on item '" + _item_1;
            String _plus_3 = _plus_2 + "' has negative step size";
            this.error(_plus_3, SitemapPackage.Literals.SETPOINT.getEStructuralFeature(11));
        }
        if (sp.getMinValue() != null && sp.getMaxValue() != null && sp.getMinValue().compareTo(sp.getMaxValue()) > 0) {
            String _item_2 = sp.getItem();
            String _plus_4 = "Setpoint on item '" + _item_2;
            String _plus_5 = _plus_4 + "' has larger minValue than maxValue";
            this.error(_plus_5, SitemapPackage.Literals.SETPOINT.getEStructuralFeature(9));
        }
    }

    @Check
    public void checkInputHintParameter(Input i) {
        if (i.getInputHint() != null && !this.ALLOWED_HINTS.contains(i.getInputHint())) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)i);
            int line = node.getStartLine();
            String _item = i.getItem();
            String _plus = "Input on item '" + _item;
            String _plus_1 = _plus + "' has invalid inputHint '";
            String _inputHint = i.getInputHint();
            String _plus_2 = _plus_1 + _inputHint;
            String _plus_3 = _plus_2 + "' at line ";
            String _plus_4 = _plus_3 + String.valueOf((Object)line);
            this.error(_plus_4, SitemapPackage.Literals.INPUT.getEStructuralFeature(9));
        }
    }
}

