/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.discovery;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.DiscoveryServiceRegistry;
import org.openhab.core.config.discovery.ScanListener;
import org.openhab.core.io.rest.RESTResource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="discovery")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="discovery")
@Component(service={RESTResource.class, DiscoveryResource.class})
@JaxrsResource
@JaxrsName(value="discovery")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class DiscoveryResource
implements RESTResource {
    public static final String PATH_DISCOVERY = "discovery";
    private final Logger logger = LoggerFactory.getLogger(DiscoveryResource.class);
    private final DiscoveryServiceRegistry discoveryServiceRegistry;

    @Activate
    public DiscoveryResource(@Reference DiscoveryServiceRegistry discoveryServiceRegistry) {
        this.discoveryServiceRegistry = discoveryServiceRegistry;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getBindingsWithDiscoverySupport", summary="Gets all bindings that support discovery.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class), uniqueItems=true))})})
    public Response getDiscoveryServices() {
        List supportedBindings = this.discoveryServiceRegistry.getSupportedBindings();
        return Response.ok(new LinkedHashSet(supportedBindings)).build();
    }

    @POST
    @Path(value="/bindings/{bindingId}/scan")
    @Produces(value={"text/plain"})
    @Operation(operationId="scan", summary="Starts asynchronous discovery process for a binding and returns the timeout in seconds of the discovery operation.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=Integer.class))})})
    public Response scan(final @PathParam(value="bindingId") @Parameter(description="bindingId") String bindingId) {
        this.discoveryServiceRegistry.startScan(bindingId, new ScanListener(){

            public void onErrorOccurred(@Nullable Exception exception) {
                DiscoveryResource.this.logger.error("Error occurred while scanning for binding '{}'", (Object)bindingId, (Object)exception);
            }

            public void onFinished() {
                DiscoveryResource.this.logger.debug("Scan for binding '{}' successfully finished.", (Object)bindingId);
            }
        });
        return Response.ok((Object)this.discoveryServiceRegistry.getMaxScanTimeout(bindingId)).build();
    }
}

