/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence.extensions;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.i18n.TimeZoneProvider;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.library.items.NumberItem;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.persistence.FilterCriteria;
import org.openhab.core.persistence.HistoricItem;
import org.openhab.core.persistence.ModifiablePersistenceService;
import org.openhab.core.persistence.PersistenceService;
import org.openhab.core.persistence.PersistenceServiceRegistry;
import org.openhab.core.persistence.QueryablePersistenceService;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.TypeParser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@NonNullByDefault
public class PersistenceExtensions {
    private static @Nullable PersistenceServiceRegistry registry;
    private static @Nullable TimeZoneProvider timeZoneProvider;

    @Activate
    public PersistenceExtensions(@Reference PersistenceServiceRegistry registry, @Reference TimeZoneProvider timeZoneProvider) {
        PersistenceExtensions.registry = registry;
        PersistenceExtensions.timeZoneProvider = timeZoneProvider;
    }

    public static void persist(Item item) {
        PersistenceExtensions.internalPersist(item, null);
    }

    public static void persist(Item item, @Nullable String serviceId) {
        PersistenceExtensions.internalPersist(item, serviceId);
    }

    private static void internalPersist(Item item, @Nullable String serviceId) {
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return;
        }
        PersistenceService service = PersistenceExtensions.getService(effectiveServiceId);
        if (service != null) {
            service.store(item);
            return;
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no persistence service registered with the id '{}'", (Object)effectiveServiceId);
    }

    public static void persist(Item item, ZonedDateTime timestamp, State state) {
        PersistenceExtensions.internalPersist(item, timestamp, state, null);
    }

    public static void persist(Item item, ZonedDateTime timestamp, State state, @Nullable String serviceId) {
        PersistenceExtensions.internalPersist(item, timestamp, state, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static void internalPersist(Item item, ZonedDateTime timestamp, State state, @Nullable String serviceId) {
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return;
        }
        PersistenceService service = PersistenceExtensions.getService(effectiveServiceId);
        PersistenceService persistenceService = service;
        if (persistenceService instanceof ModifiablePersistenceService) {
            void modifiableService;
            ModifiablePersistenceService modifiablePersistenceService = (ModifiablePersistenceService)persistenceService;
            ModifiablePersistenceService cfr_ignored_0 = (ModifiablePersistenceService)persistenceService;
            modifiableService.store(item, timestamp, state);
            return;
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no modifiable persistence service registered with the id '{}'", (Object)effectiveServiceId);
    }

    public static void persist(Item item, ZonedDateTime timestamp, String stateString) {
        PersistenceExtensions.internalPersist(item, timestamp, stateString, null);
    }

    public static void persist(Item item, ZonedDateTime timestamp, String stateString, @Nullable String serviceId) {
        PersistenceExtensions.internalPersist(item, timestamp, stateString, serviceId);
    }

    private static void internalPersist(Item item, ZonedDateTime timestamp, String stateString, @Nullable String serviceId) {
        State state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)stateString);
        if (state != null) {
            PersistenceExtensions.internalPersist(item, timestamp, state, serviceId);
        } else {
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("State '{}' cannot be parsed for item '{}'.", (Object)stateString, (Object)item.getName());
        }
    }

    public static void persist(Item item, TimeSeries timeSeries) {
        PersistenceExtensions.internalPersist(item, timeSeries, null);
    }

    public static void persist(Item item, TimeSeries timeSeries, @Nullable String serviceId) {
        PersistenceExtensions.internalPersist(item, timeSeries, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static void internalPersist(Item item, TimeSeries timeSeries, @Nullable String serviceId) {
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null || timeSeries.size() == 0) {
            return;
        }
        PersistenceService service = PersistenceExtensions.getService(effectiveServiceId);
        TimeZoneProvider tzProvider = timeZoneProvider;
        ZoneId timeZone = tzProvider != null ? tzProvider.getTimeZone() : ZoneId.systemDefault();
        PersistenceService persistenceService = service;
        if (persistenceService instanceof ModifiablePersistenceService) {
            void modifiableService;
            ModifiablePersistenceService modifiablePersistenceService = (ModifiablePersistenceService)persistenceService;
            ModifiablePersistenceService cfr_ignored_0 = (ModifiablePersistenceService)persistenceService;
            if (timeSeries.getPolicy() == TimeSeries.Policy.REPLACE) {
                PersistenceExtensions.internalRemoveAllStatesBetween(item, timeSeries.getBegin().atZone(timeZone), timeSeries.getEnd().atZone(timeZone), serviceId);
            }
            timeSeries.getStates().forEach(arg_0 -> PersistenceExtensions.lambda$0((ModifiablePersistenceService)modifiableService, item, timeZone, arg_0));
            return;
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no modifiable persistence service registered with the id '{}'", (Object)effectiveServiceId);
    }

    @Deprecated
    public static @Nullable HistoricItem historicState(Item item, ZonedDateTime timestamp) {
        LoggerFactory.getLogger(PersistenceExtensions.class).info("The historicState method has been deprecated and will be removed in a future version, use persistedState instead.");
        return PersistenceExtensions.internalPersistedState(item, timestamp, null);
    }

    @Deprecated
    public static @Nullable HistoricItem historicState(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        LoggerFactory.getLogger(PersistenceExtensions.class).info("The historicState method has been deprecated and will be removed in a future version, use persistedState instead.");
        return PersistenceExtensions.internalPersistedState(item, timestamp, serviceId);
    }

    public static @Nullable HistoricItem persistedState(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalPersistedState(item, timestamp, null);
    }

    public static @Nullable HistoricItem persistedState(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalPersistedState(item, timestamp, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable HistoricItem internalPersistedState(Item item, @Nullable ZonedDateTime timestamp, @Nullable String serviceId) {
        String effectiveServiceId;
        if (timestamp == null) {
            return null;
        }
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        PersistenceService service = PersistenceExtensions.getService(effectiveServiceId);
        PersistenceService persistenceService = service;
        if (persistenceService instanceof QueryablePersistenceService) {
            void qService;
            QueryablePersistenceService queryablePersistenceService = (QueryablePersistenceService)persistenceService;
            QueryablePersistenceService cfr_ignored_0 = (QueryablePersistenceService)persistenceService;
            FilterCriteria filter = new FilterCriteria();
            filter.setEndDate(timestamp);
            filter.setItemName(item.getName());
            filter.setPageSize(1);
            filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
            Iterable<HistoricItem> result = qService.query(filter);
            if (result.iterator().hasNext()) {
                return result.iterator().next();
            }
        } else {
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the id '{}'", (Object)effectiveServiceId);
        }
        return null;
    }

    public static @Nullable ZonedDateTime lastUpdate(Item item) {
        return PersistenceExtensions.internalAdjacentUpdate(item, false, null);
    }

    public static @Nullable ZonedDateTime lastUpdate(Item item, @Nullable String serviceId) {
        return PersistenceExtensions.internalAdjacentUpdate(item, false, serviceId);
    }

    public static @Nullable ZonedDateTime nextUpdate(Item item) {
        return PersistenceExtensions.internalAdjacentUpdate(item, true, null);
    }

    public static @Nullable ZonedDateTime nextUpdate(Item item, @Nullable String serviceId) {
        return PersistenceExtensions.internalAdjacentUpdate(item, true, serviceId);
    }

    private static @Nullable ZonedDateTime internalAdjacentUpdate(Item item, boolean forward, @Nullable String serviceId) {
        return PersistenceExtensions.internalAdjacent(item, forward, false, serviceId);
    }

    public static @Nullable ZonedDateTime lastChange(Item item) {
        return PersistenceExtensions.internalAdjacentChange(item, false, null);
    }

    public static @Nullable ZonedDateTime lastChange(Item item, @Nullable String serviceId) {
        return PersistenceExtensions.internalAdjacentChange(item, false, serviceId);
    }

    public static @Nullable ZonedDateTime nextChange(Item item) {
        return PersistenceExtensions.internalAdjacentChange(item, true, null);
    }

    public static @Nullable ZonedDateTime nextChange(Item item, @Nullable String serviceId) {
        return PersistenceExtensions.internalAdjacentChange(item, true, serviceId);
    }

    private static @Nullable ZonedDateTime internalAdjacentChange(Item item, boolean forward, @Nullable String serviceId) {
        return PersistenceExtensions.internalAdjacent(item, forward, true, serviceId);
    }

    /*
     * Unable to fully structure code
     */
    private static @Nullable ZonedDateTime internalAdjacent(Item item, boolean forward, boolean skipEqual, @Nullable String serviceId) {
        block10: {
            block9: {
                v0 = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
                if (effectiveServiceId == null) {
                    return null;
                }
                service = PersistenceExtensions.getService(effectiveServiceId);
                var7_6 = service;
                if (!(var7_6 instanceof QueryablePersistenceService)) break block9;
                var6_7 = (QueryablePersistenceService)var7_6;
                (QueryablePersistenceService)var7_6;
                filter = new FilterCriteria();
                filter.setItemName(item.getName());
                if (forward) {
                    filter.setBeginDate(ZonedDateTime.now());
                } else {
                    filter.setEndDate(ZonedDateTime.now());
                }
                filter.setOrdering(forward != false ? FilterCriteria.Ordering.ASCENDING : FilterCriteria.Ordering.DESCENDING);
                filter.setPageSize(skipEqual != false ? 1000 : 1);
                startPage = 0;
                filter.setPageNumber(startPage);
                items = qService.query(filter);
                itemIterator = items.iterator();
                state = item.getState();
                if (!itemIterator.hasNext()) break block10;
                if (!skipEqual) {
                    historicItem = itemIterator.next();
                    if (!forward && !historicItem.getState().equals(state)) {
                        return null;
                    }
                    return historicItem.getTimestamp();
                }
                historicItem = itemIterator.next();
                itemCount = 1;
                if (historicItem.getState().equals(state)) ** GOTO lbl54
                return forward != false ? historicItem.getTimestamp() : null;
                {
                    nextHistoricItem = itemIterator.next();
                    ++itemCount;
                    if (!nextHistoricItem.getState().equals(state)) {
                        return forward != false ? nextHistoricItem.getTimestamp() : historicItem.getTimestamp();
                    }
                    historicItem = nextHistoricItem;
                    do {
                        if (historicItem.getState().equals(state) && itemIterator.hasNext()) continue block0;
                        if (itemCount == filter.getPageSize()) {
                            filter.setPageNumber(++startPage);
                            items = qService.query(filter);
                            itemCount = 0;
                            continue;
                        }
                        items = null;
lbl54:
                        // 3 sources

                    } while (items != null);
                }
                break block10;
            }
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the id '{}'", (Object)effectiveServiceId);
        }
        return null;
    }

    public static @Nullable HistoricItem previousState(Item item) {
        return PersistenceExtensions.internalAdjacentState(item, false, false, null);
    }

    public static @Nullable HistoricItem previousState(Item item, boolean skipEqual) {
        return PersistenceExtensions.internalAdjacentState(item, skipEqual, false, null);
    }

    public static @Nullable HistoricItem previousState(Item item, @Nullable String serviceId) {
        return PersistenceExtensions.internalAdjacentState(item, false, false, serviceId);
    }

    public static @Nullable HistoricItem previousState(Item item, boolean skipEqual, @Nullable String serviceId) {
        return PersistenceExtensions.internalAdjacentState(item, skipEqual, false, serviceId);
    }

    public static @Nullable HistoricItem nextState(Item item) {
        return PersistenceExtensions.internalAdjacentState(item, false, true, null);
    }

    public static @Nullable HistoricItem nextState(Item item, boolean skipEqual) {
        return PersistenceExtensions.internalAdjacentState(item, skipEqual, true, null);
    }

    public static @Nullable HistoricItem nextState(Item item, @Nullable String serviceId) {
        return PersistenceExtensions.internalAdjacentState(item, false, true, serviceId);
    }

    public static @Nullable HistoricItem nextState(Item item, boolean skipEqual, @Nullable String serviceId) {
        return PersistenceExtensions.internalAdjacentState(item, skipEqual, true, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable HistoricItem internalAdjacentState(Item item, boolean skipEqual, boolean forward, @Nullable String serviceId) {
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        PersistenceService service = PersistenceExtensions.getService(effectiveServiceId);
        PersistenceService persistenceService = service;
        if (persistenceService instanceof QueryablePersistenceService) {
            void qService;
            QueryablePersistenceService queryablePersistenceService = (QueryablePersistenceService)persistenceService;
            QueryablePersistenceService cfr_ignored_0 = (QueryablePersistenceService)persistenceService;
            FilterCriteria filter = new FilterCriteria();
            filter.setItemName(item.getName());
            if (forward) {
                filter.setBeginDate(ZonedDateTime.now());
            } else {
                filter.setEndDate(ZonedDateTime.now());
            }
            filter.setOrdering(forward ? FilterCriteria.Ordering.ASCENDING : FilterCriteria.Ordering.DESCENDING);
            filter.setPageSize(skipEqual ? 1000 : 1);
            int startPage = 0;
            filter.setPageNumber(startPage);
            Iterable<HistoricItem> items = qService.query(filter);
            while (items != null) {
                Iterator<HistoricItem> itemIterator = items.iterator();
                int itemCount = 0;
                while (itemIterator.hasNext()) {
                    HistoricItem historicItem = itemIterator.next();
                    ++itemCount;
                    if (skipEqual && historicItem.getState().equals(item.getState())) continue;
                    return historicItem;
                }
                if (itemCount == filter.getPageSize()) {
                    filter.setPageNumber(++startPage);
                    items = qService.query(filter);
                    continue;
                }
                items = null;
            }
        } else {
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the id '{}'", (Object)effectiveServiceId);
        }
        return null;
    }

    public static @Nullable Boolean changedSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalChangedBetween(item, timestamp, null, null);
    }

    public static @Nullable Boolean changedUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalChangedBetween(item, null, timestamp, null);
    }

    public static @Nullable Boolean changedBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalChangedBetween(item, begin, end, null);
    }

    public static @Nullable Boolean changedSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalChangedBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable Boolean changedUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalChangedBetween(item, null, timestamp, serviceId);
    }

    public static @Nullable Boolean changedBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalChangedBetween(item, begin, end, serviceId);
    }

    private static @Nullable Boolean internalChangedBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        Iterable<HistoricItem> result = PersistenceExtensions.internalGetAllStatesBetween(item, begin, end, effectiveServiceId);
        if (result != null) {
            Iterator<HistoricItem> it = result.iterator();
            HistoricItem itemThen = PersistenceExtensions.internalPersistedState(item, begin, effectiveServiceId);
            if (itemThen == null) {
                return it.hasNext();
            }
            State state = itemThen.getState();
            while (it.hasNext()) {
                HistoricItem hItem = it.next();
                if (!hItem.getState().equals(state)) {
                    return true;
                }
                state = hItem.getState();
            }
            return false;
        }
        return null;
    }

    public static @Nullable Boolean updatedSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalUpdatedBetween(item, timestamp, null, null);
    }

    public static @Nullable Boolean updatedUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalUpdatedBetween(item, null, timestamp, null);
    }

    public static @Nullable Boolean updatedBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalUpdatedBetween(item, begin, end, null);
    }

    public static @Nullable Boolean updatedSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalUpdatedBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable Boolean updatedUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalUpdatedBetween(item, null, timestamp, serviceId);
    }

    public static @Nullable Boolean updatedBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalUpdatedBetween(item, begin, end, serviceId);
    }

    private static @Nullable Boolean internalUpdatedBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        Iterable<HistoricItem> result = PersistenceExtensions.internalGetAllStatesBetween(item, begin, end, effectiveServiceId);
        if (result != null) {
            return result.iterator().hasNext();
        }
        return null;
    }

    public static @Nullable HistoricItem maximumSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalMaximumBetween(item, timestamp, null, null);
    }

    public static @Nullable HistoricItem maximumUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalMaximumBetween(item, null, timestamp, null);
    }

    public static @Nullable HistoricItem maximumBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalMaximumBetween(item, begin, end, null);
    }

    public static @Nullable HistoricItem maximumSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalMaximumBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable HistoricItem maximumUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalMaximumBetween(item, null, timestamp, serviceId);
    }

    public static @Nullable HistoricItem maximumBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalMaximumBetween(item, begin, end, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable HistoricItem internalMaximumBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        Unit unit;
        Item item2;
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetweenWithBoundaries(item, begin, end, effectiveServiceId);
        if (result == null) {
            return null;
        }
        Iterator<HistoricItem> it = result.iterator();
        HistoricItem maximumHistoricItem = null;
        Item baseItem = item;
        Item item3 = baseItem;
        if (item3 instanceof GroupItem) {
            void groupItem;
            GroupItem groupItem2 = (GroupItem)item3;
            GroupItem cfr_ignored_0 = (GroupItem)item3;
            baseItem = groupItem.getBaseItem();
        }
        if ((item2 = baseItem) instanceof NumberItem) {
            void numberItem;
            NumberItem numberItem2 = (NumberItem)item2;
            NumberItem cfr_ignored_1 = (NumberItem)item2;
            unit = numberItem.getUnit();
        } else {
            unit = null;
        }
        Unit unit2 = unit;
        DecimalType maximum = null;
        while (it.hasNext()) {
            HistoricItem historicItem = it.next();
            DecimalType value = PersistenceExtensions.getPersistedValue(historicItem, unit2);
            if (value == null || maximum != null && value.compareTo(maximum) <= 0) continue;
            maximum = value;
            maximumHistoricItem = historicItem;
        }
        return PersistenceExtensions.historicItemOrCurrentState(item, maximumHistoricItem);
    }

    public static @Nullable HistoricItem minimumSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalMinimumBetween(item, timestamp, null, null);
    }

    public static @Nullable HistoricItem minimumUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalMinimumBetween(item, null, timestamp, null);
    }

    public static @Nullable HistoricItem minimumBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalMinimumBetween(item, begin, end, null);
    }

    public static @Nullable HistoricItem minimumSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalMinimumBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable HistoricItem minimumUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalMinimumBetween(item, null, timestamp, serviceId);
    }

    public static @Nullable HistoricItem minimumBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalMinimumBetween(item, begin, end, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable HistoricItem internalMinimumBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        Unit unit;
        Item item2;
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetweenWithBoundaries(item, begin, end, effectiveServiceId);
        if (result == null) {
            return null;
        }
        Iterator<HistoricItem> it = result.iterator();
        HistoricItem minimumHistoricItem = null;
        Item baseItem = item;
        Item item3 = baseItem;
        if (item3 instanceof GroupItem) {
            void groupItem;
            GroupItem groupItem2 = (GroupItem)item3;
            GroupItem cfr_ignored_0 = (GroupItem)item3;
            baseItem = groupItem.getBaseItem();
        }
        if ((item2 = baseItem) instanceof NumberItem) {
            void numberItem;
            NumberItem numberItem2 = (NumberItem)item2;
            NumberItem cfr_ignored_1 = (NumberItem)item2;
            unit = numberItem.getUnit();
        } else {
            unit = null;
        }
        Unit unit2 = unit;
        DecimalType minimum = null;
        while (it.hasNext()) {
            HistoricItem historicItem = it.next();
            DecimalType value = PersistenceExtensions.getPersistedValue(historicItem, unit2);
            if (value == null || minimum != null && value.compareTo(minimum) >= 0) continue;
            minimum = value;
            minimumHistoricItem = historicItem;
        }
        return PersistenceExtensions.historicItemOrCurrentState(item, minimumHistoricItem);
    }

    public static @Nullable State varianceSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalVarianceBetween(item, timestamp, null, null);
    }

    public static @Nullable State varianceUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalVarianceBetween(item, null, timestamp, null);
    }

    public static @Nullable State varianceBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalVarianceBetween(item, begin, end, null);
    }

    public static @Nullable State varianceSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalVarianceBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable State varianceUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalVarianceBetween(item, null, timestamp, serviceId);
    }

    public static @Nullable State varianceBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalVarianceBetween(item, begin, end, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable State internalVarianceBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetweenWithBoundaries(item, begin, end, effectiveServiceId);
        if (result == null) {
            return null;
        }
        State averageState = PersistenceExtensions.internalAverageBetween(item, begin, end, effectiveServiceId);
        if (averageState != null) {
            Unit unit;
            Item item2;
            DecimalType dt = (DecimalType)averageState.as(DecimalType.class);
            BigDecimal average = dt != null ? dt.toBigDecimal() : BigDecimal.ZERO;
            BigDecimal sum = BigDecimal.ZERO;
            int count = 0;
            Item baseItem = item;
            Item item3 = baseItem;
            if (item3 instanceof GroupItem) {
                void groupItem;
                GroupItem groupItem2 = (GroupItem)item3;
                GroupItem cfr_ignored_0 = (GroupItem)item3;
                baseItem = groupItem.getBaseItem();
            }
            if ((item2 = baseItem) instanceof NumberItem) {
                void numberItem;
                NumberItem numberItem2 = (NumberItem)item2;
                NumberItem cfr_ignored_1 = (NumberItem)item2;
                unit = numberItem.getUnit();
            } else {
                unit = null;
            }
            Unit unit2 = unit;
            for (HistoricItem historicItem : result) {
                DecimalType value = PersistenceExtensions.getPersistedValue(historicItem, unit2);
                if (value == null) continue;
                ++count;
                sum = sum.add(value.toBigDecimal().subtract(average, MathContext.DECIMAL64).pow(2, MathContext.DECIMAL64));
            }
            if (count > 0) {
                BigDecimal variance = sum.divide(BigDecimal.valueOf(count), MathContext.DECIMAL64);
                if (unit2 != null) {
                    return new QuantityType((Number)variance, unit2.multiply(unit2));
                }
                return new DecimalType((Number)variance);
            }
        }
        return null;
    }

    public static @Nullable State deviationSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalDeviationBetween(item, timestamp, null, null);
    }

    public static @Nullable State deviationUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalDeviationBetween(item, timestamp, null, null);
    }

    public static @Nullable State deviationBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalDeviationBetween(item, begin, end, null);
    }

    public static @Nullable State deviationSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalDeviationBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable State deviationUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalDeviationBetween(item, null, timestamp, serviceId);
    }

    public static @Nullable State deviationBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalDeviationBetween(item, begin, end, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable State internalDeviationBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        DecimalType dt;
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        State variance = PersistenceExtensions.internalVarianceBetween(item, begin, end, effectiveServiceId);
        if (variance != null && (dt = (DecimalType)variance.as(DecimalType.class)) != null && DecimalType.ZERO.compareTo(dt) <= 0) {
            Item item2;
            BigDecimal deviation = dt.toBigDecimal().sqrt(MathContext.DECIMAL64);
            Item baseItem = item;
            Item item3 = baseItem;
            if (item3 instanceof GroupItem) {
                void groupItem;
                GroupItem groupItem2 = (GroupItem)item3;
                GroupItem cfr_ignored_0 = (GroupItem)item3;
                baseItem = groupItem.getBaseItem();
            }
            if ((item2 = baseItem) instanceof NumberItem) {
                void numberItem;
                NumberItem numberItem2 = (NumberItem)item2;
                NumberItem cfr_ignored_1 = (NumberItem)item2;
                Unit unit = numberItem.getUnit();
                if (unit != null) {
                    return new QuantityType((Number)deviation, unit);
                }
            }
            return new DecimalType((Number)deviation);
        }
        return null;
    }

    public static @Nullable State averageSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalAverageBetween(item, timestamp, null, null);
    }

    public static @Nullable State averageUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalAverageBetween(item, null, timestamp, null);
    }

    public static @Nullable State averageBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalAverageBetween(item, begin, end, null);
    }

    public static @Nullable State averageSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalAverageBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable State averageUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalAverageBetween(item, null, timestamp, serviceId);
    }

    public static @Nullable State averageBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalAverageBetween(item, begin, end, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable State internalAverageBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        Unit unit;
        Item item2;
        ZonedDateTime endTime;
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetweenWithBoundaries(item, begin, end, effectiveServiceId);
        if (result == null) {
            return null;
        }
        Iterator<HistoricItem> it = result.iterator();
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime beginTime = begin == null ? now : begin;
        ZonedDateTime zonedDateTime = endTime = end == null ? now : end;
        if (beginTime.isEqual(endTime)) {
            HistoricItem historicItem = PersistenceExtensions.internalPersistedState(item, beginTime, effectiveServiceId);
            return historicItem != null ? historicItem.getState() : null;
        }
        BigDecimal sum = BigDecimal.ZERO;
        HistoricItem lastItem = null;
        ZonedDateTime firstTimestamp = null;
        Item baseItem = item;
        Item item3 = baseItem;
        if (item3 instanceof GroupItem) {
            void groupItem;
            GroupItem groupItem2 = (GroupItem)item3;
            GroupItem cfr_ignored_0 = (GroupItem)item3;
            baseItem = groupItem.getBaseItem();
        }
        if ((item2 = baseItem) instanceof NumberItem) {
            void numberItem;
            NumberItem numberItem2 = (NumberItem)item2;
            NumberItem cfr_ignored_1 = (NumberItem)item2;
            unit = numberItem.getUnit();
        } else {
            unit = null;
        }
        Unit unit2 = unit;
        while (it.hasNext()) {
            DecimalType dtState;
            HistoricItem thisItem = it.next();
            if (lastItem != null && (dtState = PersistenceExtensions.getPersistedValue(lastItem, unit2)) != null) {
                BigDecimal value = dtState.toBigDecimal();
                BigDecimal weight = BigDecimal.valueOf(Duration.between(lastItem.getTimestamp(), thisItem.getTimestamp()).toMillis());
                sum = sum.add(value.multiply(weight));
            }
            if (firstTimestamp == null) {
                firstTimestamp = thisItem.getTimestamp();
            }
            lastItem = thisItem;
        }
        if (firstTimestamp != null) {
            BigDecimal totalDuration = BigDecimal.valueOf(Duration.between(firstTimestamp, endTime).toMillis());
            if (totalDuration.signum() == 0) {
                return null;
            }
            BigDecimal average = sum.divide(totalDuration, MathContext.DECIMAL64);
            if (unit2 != null) {
                return new QuantityType((Number)average, unit2);
            }
            return new DecimalType((Number)average);
        }
        return null;
    }

    public static @Nullable State sumSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalSumBetween(item, timestamp, null, null);
    }

    public static @Nullable State sumUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalSumBetween(item, null, timestamp, null);
    }

    public static @Nullable State sumBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalSumBetween(item, begin, end, null);
    }

    public static @Nullable State sumSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalSumBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable State sumUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalSumBetween(item, null, timestamp, serviceId);
    }

    public static @Nullable State sumBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalSumBetween(item, begin, end, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable State internalSumBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        Iterable<HistoricItem> result = PersistenceExtensions.internalGetAllStatesBetween(item, begin, end, effectiveServiceId);
        if (result != null) {
            Unit unit;
            Item item2;
            Iterator<HistoricItem> it = result.iterator();
            Item baseItem = item;
            Item item3 = baseItem;
            if (item3 instanceof GroupItem) {
                void groupItem;
                GroupItem groupItem2 = (GroupItem)item3;
                GroupItem cfr_ignored_0 = (GroupItem)item3;
                baseItem = groupItem.getBaseItem();
            }
            if ((item2 = baseItem) instanceof NumberItem) {
                void numberItem;
                NumberItem numberItem2 = (NumberItem)item2;
                NumberItem cfr_ignored_1 = (NumberItem)item2;
                unit = numberItem.getUnit();
            } else {
                unit = null;
            }
            Unit unit2 = unit;
            BigDecimal sum = BigDecimal.ZERO;
            while (it.hasNext()) {
                HistoricItem historicItem = it.next();
                DecimalType value = PersistenceExtensions.getPersistedValue(historicItem, unit2);
                if (value == null) continue;
                sum = sum.add(value.toBigDecimal());
            }
            if (unit2 != null) {
                return new QuantityType((Number)sum, unit2);
            }
            return new DecimalType((Number)sum);
        }
        return null;
    }

    public static @Nullable State deltaSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalDeltaBetween(item, timestamp, null, null);
    }

    public static @Nullable State deltaUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalDeltaBetween(item, null, timestamp, null);
    }

    public static @Nullable State deltaBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalDeltaBetween(item, begin, end, null);
    }

    public static @Nullable State deltaSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalDeltaBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable State deltaUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalDeltaBetween(item, null, timestamp, serviceId);
    }

    public static @Nullable State deltaBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalDeltaBetween(item, begin, end, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable State internalDeltaBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        Unit unit;
        Item item2;
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        HistoricItem itemStart = PersistenceExtensions.internalPersistedState(item, begin, effectiveServiceId);
        HistoricItem itemStop = PersistenceExtensions.internalPersistedState(item, end, effectiveServiceId);
        Item baseItem = item;
        Item item3 = baseItem;
        if (item3 instanceof GroupItem) {
            void groupItem;
            GroupItem groupItem2 = (GroupItem)item3;
            GroupItem cfr_ignored_0 = (GroupItem)item3;
            baseItem = groupItem.getBaseItem();
        }
        if ((item2 = baseItem) instanceof NumberItem) {
            void numberItem;
            NumberItem numberItem2 = (NumberItem)item2;
            NumberItem cfr_ignored_1 = (NumberItem)item2;
            unit = numberItem.getUnit();
        } else {
            unit = null;
        }
        Unit unit2 = unit;
        DecimalType valueStart = null;
        if (itemStart != null) {
            valueStart = PersistenceExtensions.getPersistedValue(itemStart, unit2);
        }
        DecimalType valueStop = null;
        if (itemStop != null) {
            valueStop = PersistenceExtensions.getPersistedValue(itemStop, unit2);
        }
        if (begin == null && end != null && end.isAfter(ZonedDateTime.now())) {
            valueStart = PersistenceExtensions.getItemValue(item);
        }
        if (begin != null && end == null && begin.isBefore(ZonedDateTime.now())) {
            valueStop = PersistenceExtensions.getItemValue(item);
        }
        if (valueStart != null && valueStop != null) {
            BigDecimal delta = valueStop.toBigDecimal().subtract(valueStart.toBigDecimal());
            return unit2 != null ? new QuantityType((Number)delta, unit2) : new DecimalType((Number)delta);
        }
        return null;
    }

    @Deprecated
    public static @Nullable DecimalType evolutionRate(Item item, ZonedDateTime timestamp) {
        LoggerFactory.getLogger(PersistenceExtensions.class).info("The evolutionRate method has been deprecated and will be removed in a future version, use evolutionRateSince instead.");
        return PersistenceExtensions.internalEvolutionRateBetween(item, timestamp, null, null);
    }

    public static @Nullable DecimalType evolutionRateSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalEvolutionRateBetween(item, timestamp, null, null);
    }

    public static @Nullable DecimalType evolutionRateUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalEvolutionRateBetween(item, null, timestamp, null);
    }

    @Deprecated
    public static @Nullable DecimalType evolutionRate(Item item, ZonedDateTime begin, ZonedDateTime end) {
        LoggerFactory.getLogger(PersistenceExtensions.class).info("The evolutionRate method has been deprecated and will be removed in a future version, use evolutionRateBetween instead.");
        return PersistenceExtensions.internalEvolutionRateBetween(item, begin, end, null);
    }

    public static @Nullable DecimalType evolutionRateBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalEvolutionRateBetween(item, begin, end, null);
    }

    @Deprecated
    public static @Nullable DecimalType evolutionRate(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        LoggerFactory.getLogger(PersistenceExtensions.class).info("The evolutionRate method has been deprecated and will be removed in a future version, use evolutionRateSince instead.");
        return PersistenceExtensions.internalEvolutionRateBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable DecimalType evolutionRateSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalEvolutionRateBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable DecimalType evolutionRateUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalEvolutionRateBetween(item, null, timestamp, serviceId);
    }

    @Deprecated
    public static @Nullable DecimalType evolutionRate(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        LoggerFactory.getLogger(PersistenceExtensions.class).info("The evolutionRate method has been deprecated and will be removed in a future version, use evolutionRateBetween instead.");
        return PersistenceExtensions.internalEvolutionRateBetween(item, begin, end, serviceId);
    }

    public static @Nullable DecimalType evolutionRateBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalEvolutionRateBetween(item, begin, end, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable DecimalType internalEvolutionRateBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        Unit unit;
        Item item2;
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        Item baseItem = item;
        Item item3 = baseItem;
        if (item3 instanceof GroupItem) {
            void groupItem;
            GroupItem groupItem2 = (GroupItem)item3;
            GroupItem cfr_ignored_0 = (GroupItem)item3;
            baseItem = groupItem.getBaseItem();
        }
        if ((item2 = baseItem) instanceof NumberItem) {
            void numberItem;
            NumberItem numberItem2 = (NumberItem)item2;
            NumberItem cfr_ignored_1 = (NumberItem)item2;
            unit = numberItem.getUnit();
        } else {
            unit = null;
        }
        Unit unit2 = unit;
        HistoricItem itemStart = PersistenceExtensions.internalPersistedState(item, begin, effectiveServiceId);
        HistoricItem itemStop = PersistenceExtensions.internalPersistedState(item, end, effectiveServiceId);
        DecimalType valueStart = null;
        if (itemStart != null) {
            valueStart = PersistenceExtensions.getPersistedValue(itemStart, unit2);
        }
        DecimalType valueStop = null;
        if (itemStop != null) {
            valueStop = PersistenceExtensions.getPersistedValue(itemStop, unit2);
        }
        if (begin == null && end != null && end.isAfter(ZonedDateTime.now())) {
            valueStart = PersistenceExtensions.getItemValue(item);
        }
        if (begin != null && end == null && begin.isBefore(ZonedDateTime.now())) {
            valueStop = PersistenceExtensions.getItemValue(item);
        }
        if (valueStart != null && valueStop != null && !valueStart.equals((Object)DecimalType.ZERO)) {
            return new DecimalType((Number)valueStop.toBigDecimal().subtract(valueStart.toBigDecimal()).divide(valueStart.toBigDecimal(), MathContext.DECIMAL64).movePointRight(2));
        }
        return null;
    }

    public static @Nullable Long countSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalCountBetween(item, timestamp, null, null);
    }

    public static @Nullable Long countUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalCountBetween(item, null, timestamp, null);
    }

    public static @Nullable Long countBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalCountBetween(item, begin, end, null);
    }

    public static @Nullable Long countSince(Item item, ZonedDateTime begin, @Nullable String serviceId) {
        return PersistenceExtensions.internalCountBetween(item, begin, null, serviceId);
    }

    public static @Nullable Long countUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalCountBetween(item, null, timestamp, serviceId);
    }

    public static @Nullable Long countBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalCountBetween(item, begin, end, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable Long internalCountBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        Iterable<HistoricItem> result = PersistenceExtensions.internalGetAllStatesBetween(item, begin, end, effectiveServiceId);
        if (result != null) {
            Iterable<HistoricItem> iterable = result;
            if (iterable instanceof Collection) {
                void collection;
                Collection collection2 = (Collection)iterable;
                Collection cfr_ignored_0 = (Collection)iterable;
                return collection.size();
            }
            return StreamSupport.stream(result.spliterator(), false).count();
        }
        return null;
    }

    public static @Nullable Long countStateChangesSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalCountStateChangesBetween(item, timestamp, null, null);
    }

    public static @Nullable Long countStateChangesUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalCountStateChangesBetween(item, null, timestamp, null);
    }

    public static @Nullable Long countStateChangesBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalCountStateChangesBetween(item, begin, end, null);
    }

    public static @Nullable Long countStateChangesSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalCountStateChangesBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable Long countStateChangesUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalCountStateChangesBetween(item, null, timestamp, serviceId);
    }

    public static @Nullable Long countStateChangesBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalCountStateChangesBetween(item, begin, end, serviceId);
    }

    private static @Nullable Long internalCountStateChangesBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        Iterable<HistoricItem> result = PersistenceExtensions.internalGetAllStatesBetween(item, begin, end, effectiveServiceId);
        if (result != null) {
            Iterator<HistoricItem> it = result.iterator();
            if (!it.hasNext()) {
                return 0L;
            }
            long count = 0L;
            State previousState = it.next().getState();
            while (it.hasNext()) {
                HistoricItem historicItem = it.next();
                State state = historicItem.getState();
                if (state.equals(previousState)) continue;
                previousState = state;
                ++count;
            }
            return count;
        }
        return null;
    }

    public static @Nullable Iterable<HistoricItem> getAllStatesSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalGetAllStatesBetween(item, timestamp, null, null);
    }

    public static @Nullable Iterable<HistoricItem> getAllStatesUntil(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.internalGetAllStatesBetween(item, null, timestamp, null);
    }

    public static @Nullable Iterable<HistoricItem> getAllStatesBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalGetAllStatesBetween(item, begin, end, null);
    }

    public static @Nullable Iterable<HistoricItem> getAllStatesSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalGetAllStatesBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable Iterable<HistoricItem> getAllStatesUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        return PersistenceExtensions.internalGetAllStatesBetween(item, null, timestamp, serviceId);
    }

    public static @Nullable Iterable<HistoricItem> getAllStatesBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        return PersistenceExtensions.internalGetAllStatesBetween(item, begin, end, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable Iterable<HistoricItem> internalGetAllStatesBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return null;
        }
        PersistenceService service = PersistenceExtensions.getService(effectiveServiceId);
        PersistenceService persistenceService = service;
        if (persistenceService instanceof QueryablePersistenceService) {
            void qService;
            QueryablePersistenceService queryablePersistenceService = (QueryablePersistenceService)persistenceService;
            QueryablePersistenceService cfr_ignored_0 = (QueryablePersistenceService)persistenceService;
            FilterCriteria filter = new FilterCriteria();
            ZonedDateTime now = ZonedDateTime.now();
            if (begin == null && end == null || begin != null && end == null && begin.isAfter(now) || begin == null && end != null && end.isBefore(now)) {
                LoggerFactory.getLogger(PersistenceExtensions.class).warn("Querying persistence service with open begin and/or end not allowed: begin {}, end {}, now {}", new Object[]{begin, end, now});
                return null;
            }
            if (begin != null) {
                filter.setBeginDate(begin);
            } else {
                filter.setBeginDate(ZonedDateTime.now());
            }
            if (end != null) {
                filter.setEndDate(end);
            } else {
                filter.setEndDate(ZonedDateTime.now());
            }
            filter.setItemName(item.getName());
            filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
            return qService.query(filter);
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the id '{}'", (Object)effectiveServiceId);
        return null;
    }

    public static void removeAllStatesSince(Item item, ZonedDateTime timestamp) {
        PersistenceExtensions.internalRemoveAllStatesBetween(item, timestamp, null, null);
    }

    public static void removeAllStatesUntil(Item item, ZonedDateTime timestamp) {
        PersistenceExtensions.internalRemoveAllStatesBetween(item, null, timestamp, null);
    }

    public static void removeAllStatesBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        PersistenceExtensions.internalRemoveAllStatesBetween(item, begin, end, null);
    }

    public static void removeAllStatesSince(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        PersistenceExtensions.internalRemoveAllStatesBetween(item, timestamp, null, serviceId);
    }

    public static void removeAllStatesUntil(Item item, ZonedDateTime timestamp, @Nullable String serviceId) {
        PersistenceExtensions.internalRemoveAllStatesBetween(item, null, timestamp, serviceId);
    }

    public static void removeAllStatesBetween(Item item, ZonedDateTime begin, ZonedDateTime end, @Nullable String serviceId) {
        PersistenceExtensions.internalRemoveAllStatesBetween(item, begin, end, serviceId);
    }

    /*
     * WARNING - void declaration
     */
    private static void internalRemoveAllStatesBetween(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        String effectiveServiceId;
        String string = effectiveServiceId = serviceId == null ? PersistenceExtensions.getDefaultServiceId() : serviceId;
        if (effectiveServiceId == null) {
            return;
        }
        PersistenceService service = PersistenceExtensions.getService(effectiveServiceId);
        PersistenceService persistenceService = service;
        if (persistenceService instanceof ModifiablePersistenceService) {
            void mService;
            ModifiablePersistenceService modifiablePersistenceService = (ModifiablePersistenceService)persistenceService;
            ModifiablePersistenceService cfr_ignored_0 = (ModifiablePersistenceService)persistenceService;
            FilterCriteria filter = new FilterCriteria();
            ZonedDateTime now = ZonedDateTime.now();
            if (begin == null && end == null || begin != null && end == null && begin.isAfter(now) || begin == null && end != null && end.isBefore(now)) {
                LoggerFactory.getLogger(PersistenceExtensions.class).warn("Querying persistence service with open begin and/or end not allowed: begin {}, end {}, now {}", new Object[]{begin, end, now});
                return;
            }
            if (begin != null) {
                filter.setBeginDate(begin);
            } else {
                filter.setBeginDate(ZonedDateTime.now());
            }
            if (end != null) {
                filter.setEndDate(end);
            } else {
                filter.setEndDate(ZonedDateTime.now());
            }
            filter.setItemName(item.getName());
            filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
            mService.remove(filter);
        } else {
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no modifiable persistence service registered with the id '{}'", (Object)effectiveServiceId);
        }
    }

    private static @Nullable Iterable<HistoricItem> getAllStatesBetweenWithBoundaries(Item item, @Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, @Nullable String serviceId) {
        Iterable<HistoricItem> betweenItems = PersistenceExtensions.internalGetAllStatesBetween(item, begin, end, serviceId);
        ZonedDateTime now = ZonedDateTime.now();
        if (begin == null && end == null || begin != null && end == null && begin.isAfter(now) || begin == null && end != null && end.isBefore(now) || begin != null && end != null && end.isBefore(begin)) {
            return null;
        }
        ZonedDateTime beginTime = begin == null ? now : begin;
        ZonedDateTime endTime = end == null ? now : end;
        ArrayList<HistoricItem> betweenItemsList = new ArrayList<HistoricItem>();
        if (betweenItems != null) {
            for (HistoricItem historicItem : betweenItems) {
                betweenItemsList.add(historicItem);
            }
        }
        if (betweenItemsList.isEmpty() || !((HistoricItem)betweenItemsList.get(0)).getTimestamp().equals(begin)) {
            HistoricItem first;
            HistoricItem historicItem = first = beginTime.equals(now) ? PersistenceExtensions.historicItemOrCurrentState(item, null) : PersistenceExtensions.internalPersistedState(item, beginTime, serviceId);
            if (first != null) {
                first = new RetimedHistoricItem(first, beginTime);
            }
            if (first != null) {
                betweenItemsList.add(0, first);
            }
        }
        if (betweenItemsList.isEmpty() || !((HistoricItem)betweenItemsList.get(betweenItemsList.size() - 1)).getTimestamp().equals(end)) {
            HistoricItem last;
            HistoricItem historicItem = last = endTime.equals(now) ? PersistenceExtensions.historicItemOrCurrentState(item, null) : PersistenceExtensions.internalPersistedState(item, endTime, serviceId);
            if (last != null) {
                last = new RetimedHistoricItem(last, endTime);
            }
            if (last != null) {
                betweenItemsList.add(last);
            }
        }
        return !betweenItemsList.isEmpty() ? betweenItemsList : null;
    }

    private static @Nullable PersistenceService getService(String serviceId) {
        PersistenceServiceRegistry reg = registry;
        return reg != null ? reg.get(serviceId) : null;
    }

    private static @Nullable String getDefaultServiceId() {
        PersistenceServiceRegistry reg = registry;
        if (reg != null) {
            String id = reg.getDefaultId();
            if (id != null) {
                return id;
            }
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no default persistence service configured!");
        } else {
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("PersistenceServiceRegistryImpl is not available!");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static @Nullable DecimalType getItemValue(Item item) {
        Item item2;
        Item baseItem = item;
        Item item3 = baseItem;
        if (item3 instanceof GroupItem) {
            void groupItem;
            GroupItem groupItem2 = (GroupItem)item3;
            GroupItem cfr_ignored_0 = (GroupItem)item3;
            baseItem = groupItem.getBaseItem();
        }
        if ((item2 = baseItem) instanceof NumberItem) {
            void numberItem;
            NumberItem numberItem2 = (NumberItem)item2;
            NumberItem cfr_ignored_1 = (NumberItem)item2;
            Unit unit = numberItem.getUnit();
            if (unit != null) {
                QuantityType qt = (QuantityType)item.getStateAs(QuantityType.class);
                QuantityType quantityType = qt = qt != null ? qt.toUnit(unit) : qt;
                if (qt != null) {
                    return new DecimalType((Number)qt.toBigDecimal());
                }
            }
        }
        return (DecimalType)item.getStateAs(DecimalType.class);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static @Nullable DecimalType getPersistedValue(HistoricItem historicItem, @Nullable Unit<?> unit) {
        QuantityType qtState;
        State state = historicItem.getState();
        if (unit == null) return (DecimalType)state.as(DecimalType.class);
        State state2 = state;
        if (!(state2 instanceof QuantityType)) {
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("Item {} is QuantityType but state {} at time {} retrieved from persistence has no unit", new Object[]{historicItem.getName(), historicItem.getState(), historicItem.getTimestamp()});
            return null;
        }
        QuantityType quantityType = (QuantityType)state2;
        QuantityType cfr_ignored_0 = (QuantityType)state2;
        qtState = qtState.toUnit(unit);
        if (qtState != null) {
            state = qtState;
            return (DecimalType)state.as(DecimalType.class);
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("Unit of state {} at time {} retrieved from persistence not compatible with item unit {} for item {}", new Object[]{state, historicItem.getTimestamp(), unit, historicItem.getName()});
        return null;
    }

    private static @Nullable HistoricItem historicItemOrCurrentState(final Item item, @Nullable HistoricItem historicItem) {
        if (historicItem == null) {
            return new HistoricItem(){

                @Override
                public ZonedDateTime getTimestamp() {
                    return ZonedDateTime.now();
                }

                @Override
                public State getState() {
                    return item.getState();
                }

                @Override
                public String getName() {
                    return item.getName();
                }
            };
        }
        return historicItem;
    }

    private static /* synthetic */ void lambda$0(ModifiablePersistenceService modifiablePersistenceService, Item item, ZoneId zoneId, TimeSeries.Entry s) {
        modifiablePersistenceService.store(item, s.timestamp().atZone(zoneId), s.state());
    }

    private static class RetimedHistoricItem
    implements HistoricItem {
        private final HistoricItem originItem;
        private final ZonedDateTime timestamp;

        public RetimedHistoricItem(HistoricItem originItem, ZonedDateTime timestamp) {
            this.originItem = originItem;
            this.timestamp = timestamp;
        }

        @Override
        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }

        @Override
        public State getState() {
            return this.originItem.getState();
        }

        @Override
        public String getName() {
            return this.originItem.getName();
        }

        public String toString() {
            return "RetimedHistoricItem [originItem=" + String.valueOf(this.originItem) + ", timestamp=" + String.valueOf(this.timestamp) + "]";
        }
    }
}

