/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.properties;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.apache.karaf.jaas.modules.JAASUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoginModule
extends AbstractKarafLoginModule {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(PropertiesLoginModule.class);
    static final String USER_FILE = "users";
    private String usersFile;

    @Override
    public void initialize(Subject sub, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(sub, handler, options);
        this.usersFile = JAASUtils.getString(options, USER_FILE);
        if (this.debug) {
            LOGGER.debug("Initialized debug={} usersFile={}", (Object)this.debug, (Object)this.usersFile);
        }
    }

    @Override
    public boolean login() throws LoginException {
        Properties users;
        if (this.usersFile == null) {
            throw new LoginException("The property users may not be null");
        }
        File f = new File(this.usersFile);
        if (!f.exists()) {
            throw new LoginException("Users file not found at " + f);
        }
        try {
            users = new Properties(f);
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load user properties file " + f);
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        if (this.callbackHandler != null) {
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.getMessage());
            }
            catch (UnsupportedCallbackException uce) {
                throw new LoginException(uce.getMessage() + " not available to obtain information from user");
            }
        }
        if (((NameCallback)callbacks[0]).getName() == null) {
            throw new LoginException("Username can not be null");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        if (this.user.startsWith("_g_:")) {
            throw new FailedLoginException("login failed");
        }
        if (((PasswordCallback)callbacks[1]).getPassword() == null) {
            throw new LoginException("Password can not be null");
        }
        String password = new String(((PasswordCallback)callbacks[1]).getPassword());
        String userInfos = null;
        try {
            userInfos = (String)users.get(this.user);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (userInfos == null) {
            if (!this.detailedLoginExcepion) {
                throw new FailedLoginException("login failed");
            }
            throw new FailedLoginException("User " + this.user + " does not exist");
        }
        String[] infos = userInfos.split(",");
        String storedPassword = infos[0];
        if (!this.checkPassword(password, storedPassword)) {
            if (!this.detailedLoginExcepion) {
                throw new FailedLoginException("login failed");
            }
            throw new FailedLoginException("Password for " + this.user + " does not match");
        }
        this.principals = new HashSet();
        this.principals.add(new UserPrincipal(this.user));
        for (int i = 1; i < infos.length; ++i) {
            if (infos[i].trim().startsWith("_g_:")) {
                this.principals.add(new GroupPrincipal(infos[i].trim().substring("_g_:".length())));
                String groupInfo = (String)users.get(infos[i].trim());
                if (groupInfo == null) continue;
                String[] roles = groupInfo.split(",");
                for (int j = 1; j < roles.length; ++j) {
                    this.principals.add(new RolePrincipal(roles[j].trim()));
                }
                continue;
            }
            this.principals.add(new RolePrincipal(infos[i].trim()));
        }
        users.clear();
        if (this.debug) {
            LOGGER.debug("Successfully logged in {}", (Object)this.user);
        }
        this.succeeded = true;
        return true;
    }
}

