"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class SnapshotManagementService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getAllSnapshotsWithPolicy", async (context, request, response) => {
      try {
        var _getRepositoryRes$pay;
        // if no repository input, we need to first get back all repositories
        const getRepositoryRes = await this.catRepositories(context, request, response);
        let repositories;
        if ((_getRepositoryRes$pay = getRepositoryRes.payload) !== null && _getRepositoryRes$pay !== void 0 && _getRepositoryRes$pay.ok) {
          var _getRepositoryRes$pay2;
          repositories = (_getRepositoryRes$pay2 = getRepositoryRes.payload) === null || _getRepositoryRes$pay2 === void 0 ? void 0 : _getRepositoryRes$pay2.response.map(repo => repo.id);
        } else {
          var _getRepositoryRes$pay3;
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: (_getRepositoryRes$pay3 = getRepositoryRes.payload) === null || _getRepositoryRes$pay3 === void 0 ? void 0 : _getRepositoryRes$pay3.error
            }
          });
        }
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        let snapshots = [];
        for (let i = 0; i < repositories.length; i++) {
          const res = await callWithRequest("snapshot.get", {
            repository: repositories[i],
            snapshot: "_all",
            ignore_unavailable: true
          });
          const snapshotWithPolicy = res.snapshots.map(s => {
            var _s$metadata;
            return {
              id: s.snapshot,
              status: s.state,
              start_epoch: s.start_time_in_millis,
              end_epoch: s.end_time_in_millis,
              duration: s.duration_in_millis,
              indices: s.indices.length,
              successful_shards: s.shards.successful,
              failed_shards: s.shards.failed,
              total_shards: s.shards.total,
              repository: repositories[i],
              policy: (_s$metadata = s.metadata) === null || _s$metadata === void 0 ? void 0 : _s$metadata.sm_policy
            };
          });
          snapshots = [...snapshots, ...snapshotWithPolicy];
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              snapshots: snapshots,
              totalSnapshots: snapshots.length
            }
          }
        });
      } catch (err) {
        // If getting a non-existing snapshot, need to handle the missing snapshot exception, and return empty
        return this.errorResponse(response, err, "getAllSnapshotsWithPolicy");
      }
    });
    _defineProperty(this, "getSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.get", {
          repository: repository,
          snapshot: `${id}`,
          ignore_unavailable: true
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res.snapshots[0]
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "getSnapshot");
      }
    });
    _defineProperty(this, "deleteSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("snapshot.delete", {
          repository: repository,
          snapshot: `${id}`
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: resp
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "deleteSnapshot");
      }
    });
    _defineProperty(this, "createSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const params = {
          repository: repository,
          snapshot: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("snapshot.create", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: resp
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "createSnapshot");
      }
    });
    _defineProperty(this, "restoreSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const params = {
          repository: repository,
          snapshot: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("snapshot.restore", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: resp
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "restoreSnapshot");
      }
    });
    _defineProperty(this, "createPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          policyId: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const rawRes = await callWithRequest("ism.createSMPolicy", params);
        const res = {
          seqNo: rawRes._seq_no,
          primaryTerm: rawRes._primary_term,
          id: rawRes._id,
          policy: rawRes.sm_policy
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "createPolicy");
      }
    });
    _defineProperty(this, "updatePolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          seqNo,
          primaryTerm
        } = request.query;
        const params = {
          policyId: id,
          ifSeqNo: seqNo,
          ifPrimaryTerm: primaryTerm,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const rawRes = await callWithRequest("ism.updateSMPolicy", params);
        const res = {
          seqNo: rawRes._seq_no,
          primaryTerm: rawRes._primary_term,
          id: rawRes._id,
          policy: rawRes.sm_policy
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "updatePolicy");
      }
    });
    _defineProperty(this, "getPolicies", async (context, request, response) => {
      try {
        const {
          from,
          size,
          sortField,
          sortOrder,
          queryString
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        let params = {
          from,
          size,
          sortField: `sm_policy.${sortField}`,
          sortOrder,
          queryString: queryString.trim() ? `${queryString.trim()}` : "*"
        };
        const res = await callWithRequest("ism.getSMPolicies", params);
        const policies = res.policies.map(p => ({
          seqNo: p._seq_no,
          primaryTerm: p._primary_term,
          id: p._id,
          policy: p.sm_policy
        }));
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              policies,
              totalPolicies: res.total_policies
            }
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.reason === "Snapshot management config index not found") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                policies: [],
                totalPolicies: 0
              }
            }
          });
        }
        return this.errorResponse(response, err, "getPolicies");
      }
    });
    _defineProperty(this, "getPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getSMPolicy", params);
        const metadata = await callWithRequest("ism.explainSnapshotPolicy", params);
        const documentPolicy = {
          id: id,
          seqNo: getResponse._seq_no,
          primaryTerm: getResponse._primary_term,
          policy: getResponse.sm_policy,
          metadata: metadata.policies[0]
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: documentPolicy
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.reason === "Snapshot management config index not found") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: null
            }
          });
        }
        return this.errorResponse(response, err, "getPolicy");
      }
    });
    _defineProperty(this, "deletePolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          policyId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const deletePolicyResponse = await callWithRequest("ism.deleteSMPolicy", params);
        if (deletePolicyResponse.result !== "deleted") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: deletePolicyResponse.result
            }
          });
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: true
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "deletePolicy");
      }
    });
    _defineProperty(this, "startPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("ism.startSnapshotPolicy", params);
        if (resp.acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to start snapshot policy."
            }
          });
        }
      } catch (err) {
        return this.errorResponse(response, err, "startPolicy");
      }
    });
    _defineProperty(this, "stopPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("ism.stopSnapshotPolicy", params);
        if (resp.acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to stop snapshot policy."
            }
          });
        }
      } catch (err) {
        return this.errorResponse(response, err, "stopPolicy");
      }
    });
    _defineProperty(this, "catRepositories", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("cat.repositories", {
          format: "json"
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "catRepositories");
      }
    });
    _defineProperty(this, "getIndexRecovery", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("indices.recovery", {
          format: "json"
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "getIndexRecovery");
      }
    });
    _defineProperty(this, "catSnapshotIndices", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("cat.indices", {
          format: "json"
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "catSnapshotIndices");
      }
    });
    _defineProperty(this, "catRepositoriesWithSnapshotCount", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("cat.repositories", {
          format: "json"
        });
        for (let i = 0; i < res.length; i++) {
          const getSnapshotRes = await callWithRequest("snapshot.get", {
            repository: res[i].id,
            snapshot: "_all",
            ignore_unavailable: true
          });
          res[i].snapshotCount = getSnapshotRes.snapshots.length;
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "catRepositoriesWithSnapshotCount");
      }
    });
    _defineProperty(this, "deleteRepository", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.deleteRepository", {
          repository: id
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "deleteRepository");
      }
    });
    _defineProperty(this, "getRepository", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.getRepository", {
          repository: id
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "getRepository");
      }
    });
    _defineProperty(this, "createRepository", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          repository: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.createRepository", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "createRepository");
      }
    });
    _defineProperty(this, "errorResponse", (response, error, methodName) => {
      console.error(`Index Management - SnapshotManagementService - ${methodName}:`, error);
      return response.custom({
        statusCode: 200,
        // error?.statusCode || 500,
        body: {
          ok: false,
          error: this.parseEsErrorResponse(error)
        }
      });
    });
    _defineProperty(this, "parseEsErrorResponse", error => {
      if (error.response) {
        try {
          const esErrorResponse = JSON.parse(error.response);
          return esErrorResponse.reason || error.response;
        } catch (parsingError) {
          return error.response;
        }
      }
      return error.message;
    });
  }
}
exports.default = SnapshotManagementService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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