"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _sample_savedObjects = require("../../common/helpers/events_explorer/sample_savedObjects");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// eslint-disable-next-line import/no-default-export
class SavedObjectFacet {
  constructor(client) {
    this.client = client;
    _defineProperty(this, "fetch", async (request, params, format) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics fetch error: ', err);
        res.data = err;
      }
      return res;
    });
    _defineProperty(this, "create", async (request, format, objectType) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const params = {
          body: {
            [objectType]: {
              ...request.body.object
            }
          }
        };
        const savedRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedRes;
      } catch (err) {
        console.error('Event analytics create error: ', err);
        res.data = err;
      }
      return res;
    });
    _defineProperty(this, "createTimestamp", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const params = {
          body: {
            objectId: request.body.index,
            timestamp: {
              ...request.body
            }
          }
        };
        const savedRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedRes;
      } catch (err) {
        console.error('Event analytics create timestamp error: ', err);
        res.data = err;
      }
      return res;
    });
    _defineProperty(this, "updateTimestamp", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const params = {
          objectId: request.body.objectId,
          body: {
            ...request.body
          }
        };
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics update error: ', err);
        res.data = err.message;
      }
      return res;
    });
    _defineProperty(this, "update", async (request, format, objectType) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const params = {
          objectId: request.body.object_id,
          body: {
            [objectType]: {
              ...request.body.object
            }
          }
        };
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics update error: ', err);
        res.data = err.message;
      }
      return res;
    });
    _defineProperty(this, "delete", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const params = {
          objectIdList: request.params.objectIdList
        };
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics delete error: ', err);
        res.data = err.message;
      }
      return res;
    });
    _defineProperty(this, "createSamples", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const savedVizIds = [];
        const savedQueryIds = [];
        if (['panels', 'event_analytics'].includes(request.params.sampleRequestor)) {
          for (let i = 0; i < _sample_savedObjects.sampleVisualizations.length; i++) {
            const params = {
              body: {
                savedVisualization: {
                  ..._sample_savedObjects.sampleVisualizations[i]
                }
              }
            };
            const savedVizRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
            savedVizIds.push(savedVizRes.objectId);
          }
          for (let i = 0; i < _sample_savedObjects.sampleQueries.length; i++) {
            const params = {
              body: {
                savedQuery: {
                  ..._sample_savedObjects.sampleQueries[i]
                }
              }
            };
            const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
            savedQueryIds.push(savedQueryRes.objectId);
          }
        }
        res.success = true;
        res.data = {
          savedVizIds,
          savedQueryIds
        };
      } catch (err) {
        console.error('Event analytics create error: ', err);
        res.data = err;
      }
      return res;
    });
    _defineProperty(this, "getSavedObject", async request => {
      const params = {};
      for (const [param, value] of request.url.searchParams.entries()) {
        params[param] = value;
      }
      return this.fetch(request, {
        ...params
      }, 'observability.getObject');
    });
    _defineProperty(this, "createSavedQuery", async request => {
      return this.create(request, 'observability.createObject', 'savedQuery');
    });
    _defineProperty(this, "createSavedVisualization", request => {
      return this.create(request, 'observability.createObject', 'savedVisualization');
    });
    _defineProperty(this, "createSavedTimestamp", request => {
      return this.createTimestamp(request, 'observability.createObject');
    });
    _defineProperty(this, "updateSavedTimestamp", request => {
      return this.updateTimestamp(request, 'observability.updateObjectById');
    });
    _defineProperty(this, "updateSavedQuery", request => {
      return this.update(request, 'observability.updateObjectById', 'savedQuery');
    });
    _defineProperty(this, "updateSavedVisualization", request => {
      return this.update(request, 'observability.updateObjectById', 'savedVisualization');
    });
    _defineProperty(this, "deleteSavedObject", async request => {
      return this.delete(request, 'observability.deleteObjectByIdList');
    });
    _defineProperty(this, "createSampleSavedObjects", async request => {
      return this.createSamples(request, 'observability.createObject');
    });
    this.client = client;
  }
}
exports.default = SavedObjectFacet;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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