/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.Drawable14Converter;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfReporter;
import de.escape.quincunx.i18n.I18n;

public class ConverterTester
implements DxfReporter {
    private int nrWarnings;

    public ConverterTester(String path) {
        String operation = "read";
        System.out.println("File: " + path);
        try {
            long now = System.currentTimeMillis();
            DxfFile dxf = new DxfFile(path, (DxfReporter)this);
            long readDuration = System.currentTimeMillis() - now;
            operation = "conversion";
            now = System.currentTimeMillis();
            Drawable14Converter conv = new Drawable14Converter();
            conv.convert(dxf);
            long convDuration = System.currentTimeMillis() - now;
            System.out.println("OK: " + path + " (" + this.nrWarnings + " warnings), durations: R=" + readDuration / 1000L + "." + readDuration % 100L + ", C=" + convDuration / 1000L + "." + convDuration % 1000L);
        }
        catch (Exception x) {
            System.err.println(x);
            System.out.println("WRONG (during " + operation + "): " + path + " (" + this.nrWarnings + " warnings)");
        }
        System.out.println();
    }

    public void showStatus(String msg) {
    }

    public void showStatusRes(String tag) {
    }

    public void showStatusRes(String tag, String[] args) {
    }

    public void showWarning(String msg) {
        ++this.nrWarnings;
        System.out.println("\t" + msg);
    }

    public void showWarningRes(String tag) {
        this.showWarning(I18n.getString(tag, null));
    }

    public void showWarningRes(String tag, String[] args) {
        this.showWarning(I18n.format(tag, args, null));
    }

    public void showProgress() {
    }

    public void showProgress(float level) {
    }

    public void showProgress(float level, float maxLevel) {
    }

    public void showProgress(long level, long maxLevel) {
    }

    public static void main(String[] args) {
        int a = 0;
        while (a < args.length) {
            new ConverterTester(args[a]);
            ++a;
        }
    }
}

