# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.orgs.projects.vpcs.subnets.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class DhcpStaticBindingConfigs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.vpcs.subnets.dhcp_static_binding_configs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DhcpStaticBindingConfigsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               org_id,
               project_id,
               vpc_id,
               subnet_id,
               binding_id,
               ):
        """
        Delete VPC Subnet DHCP static binding

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  binding_id: :class:`str`
        :param binding_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'binding_id': binding_id,
                            })

    def get(self,
            org_id,
            project_id,
            vpc_id,
            subnet_id,
            binding_id,
            ):
        """
        Read VPC Subnet DHCP static binding

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  binding_id: :class:`str`
        :param binding_id: (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.DhcpStaticBindingConfig
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DhcpStaticBindingConfig`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'binding_id': binding_id,
                            })

    def list(self,
             org_id,
             project_id,
             vpc_id,
             subnet_id,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all VPC Subnet DHCP static binding instances

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpStaticBindingConfigListResult`
        :return: com.vmware.nsx_policy.model.DhcpStaticBindingConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              org_id,
              project_id,
              vpc_id,
              subnet_id,
              binding_id,
              dhcp_static_binding_config,
              ):
        """
        If binding with the binding-id is not already present, create a new VPC
        Subnet DHCP static binding instance. If it already exists, replace the
        existing VPC Subnet DHCP static binding instance with specified
        attributes.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  binding_id: :class:`str`
        :param binding_id: (required)
        :type  dhcp_static_binding_config: :class:`vmware.vapi.struct.VapiStruct`
        :param dhcp_static_binding_config: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DhcpStaticBindingConfig`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'binding_id': binding_id,
                            'dhcp_static_binding_config': dhcp_static_binding_config,
                            })

    def update(self,
               org_id,
               project_id,
               vpc_id,
               subnet_id,
               binding_id,
               dhcp_static_binding_config,
               ):
        """
        If binding with the binding-id is not already present, create a new VPC
        Subnet DHCP static binding instance. If it already exists, replace the
        existing VPC Subnet DHCP static binding instance with this object.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  binding_id: :class:`str`
        :param binding_id: (required)
        :type  dhcp_static_binding_config: :class:`vmware.vapi.struct.VapiStruct`
        :param dhcp_static_binding_config: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DhcpStaticBindingConfig`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.DhcpStaticBindingConfig
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DhcpStaticBindingConfig`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'binding_id': binding_id,
                            'dhcp_static_binding_config': dhcp_static_binding_config,
                            })
class IpPools(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.vpcs.subnets.ip_pools'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpPoolsStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            org_id,
            project_id,
            vpc_id,
            subnet_id,
            ip_pool_id,
            ):
        """
        Read IpAddressPool with given Id.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  ip_pool_id: :class:`str`
        :param ip_pool_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressPool`
        :return: com.vmware.nsx_policy.model.IpAddressPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'ip_pool_id': ip_pool_id,
                            })

    def list(self,
             org_id,
             project_id,
             vpc_id,
             subnet_id,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of IpAddressPools of VPC Subnet.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressPoolListResult`
        :return: com.vmware.nsx_policy.model.IpAddressPoolListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class Ports(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.vpcs.subnets.ports'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PortsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               org_id,
               project_id,
               vpc_id,
               subnet_id,
               port_id,
               ):
        """
        Delete a VPC Subnet Port by giving ID.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  port_id: :class:`str`
        :param port_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'port_id': port_id,
                            })

    def get(self,
            org_id,
            project_id,
            vpc_id,
            subnet_id,
            port_id,
            ):
        """
        Get detail information on VPC Subnet Port by giving ID.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  port_id: :class:`str`
        :param port_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.VpcSubnetPort`
        :return: com.vmware.nsx_policy.model.VpcSubnetPort
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'port_id': port_id,
                            })

    def list(self,
             org_id,
             project_id,
             vpc_id,
             subnet_id,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all the ports for a VPC Subnet.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.VpcSubnetPortListResult`
        :return: com.vmware.nsx_policy.model.VpcSubnetPortListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              org_id,
              project_id,
              vpc_id,
              subnet_id,
              port_id,
              vpc_subnet_port,
              ):
        """
        Create a VPC Subnet port if it does not exist based on the IDs, or
        update existing port information by replacing the port object fields
        which presents in the request body.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  port_id: :class:`str`
        :param port_id: (required)
        :type  vpc_subnet_port: :class:`com.vmware.nsx_policy.model_client.VpcSubnetPort`
        :param vpc_subnet_port: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'port_id': port_id,
                            'vpc_subnet_port': vpc_subnet_port,
                            })

    def update(self,
               org_id,
               project_id,
               vpc_id,
               subnet_id,
               port_id,
               vpc_subnet_port,
               ):
        """
        Create a VPC Subnet port if it does not exist based on the IDs, or
        update existing port information by replacing the port object already
        exists.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  port_id: :class:`str`
        :param port_id: (required)
        :type  vpc_subnet_port: :class:`com.vmware.nsx_policy.model_client.VpcSubnetPort`
        :param vpc_subnet_port: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.VpcSubnetPort`
        :return: com.vmware.nsx_policy.model.VpcSubnetPort
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'port_id': port_id,
                            'vpc_subnet_port': vpc_subnet_port,
                            })
class Statistics(VapiInterface):
    """
    
    """
    GET_SOURCE_REALTIME = "realtime"
    """
    Possible value for ``source`` of method :func:`Statistics.get`.

    """
    GET_SOURCE_CACHED = "cached"
    """
    Possible value for ``source`` of method :func:`Statistics.get`.

    """
    GET_STATS_TYPE_STATS = "DATAPATH_STATS"
    """
    Possible value for ``statsType`` of method :func:`Statistics.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.vpcs.subnets.statistics'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatisticsStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            org_id,
            project_id,
            vpc_id,
            subnet_id,
            cursor=None,
            edge_path=None,
            enforcement_point_path=None,
            include_mark_for_delete_objects=None,
            included_fields=None,
            page_size=None,
            sort_ascending=None,
            sort_by=None,
            source=None,
            stats_type=None,
            transport_node_id=None,
            ):
        """
        Get VPC Subnet statistics information.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  edge_path: :class:`str` or ``None``
        :param edge_path: Policy path of edge node (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  source: :class:`str` or ``None``
        :param source: Data source type. (optional)
        :type  stats_type: :class:`str` or ``None``
        :param stats_type: Segment statistics type (optional)
        :type  transport_node_id: :class:`str` or ``None``
        :param transport_node_id: Transport Node Id (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SubnetStatistics`
        :return: com.vmware.nsx_policy.model.SubnetStatistics
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            'cursor': cursor,
                            'edge_path': edge_path,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'source': source,
                            'stats_type': stats_type,
                            'transport_node_id': transport_node_id,
                            })
class Status(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.vpcs.subnets.status'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatusStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             org_id,
             project_id,
             vpc_id,
             subnet_id,
             ):
        """
        Get VPC Subnet status Provides status of the VPC subnet as well as
        network information such as gateway address, subnet mask, dhcp server
        address, dhcp range, static ip pools, static ip pool range.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  subnet_id: :class:`str`
        :param subnet_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.VpcSubnetStatusListResult`
        :return: com.vmware.nsx_policy.model.VpcSubnetStatusListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'subnet_id': subnet_id,
                            })
class _DhcpStaticBindingConfigsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'binding_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/dhcp-static-binding-configs/{binding-id}',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
                'binding_id': 'binding-id',
            },
             header_parameters={
                       },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'binding_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/dhcp-static-binding-configs/{binding-id}',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
                'binding_id': 'binding-id',
            },
             header_parameters={
                       },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/dhcp-static-binding-configs',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
            },
             header_parameters={
                                 },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'binding_id': type.StringType(),
            'dhcp_static_binding_config': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpStaticBindingConfig')]),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/dhcp-static-binding-configs/{binding-id}',
            request_body_parameter='dhcp_static_binding_config',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
                'binding_id': 'binding-id',
            },
             header_parameters={
                         },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'binding_id': type.StringType(),
            'dhcp_static_binding_config': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpStaticBindingConfig')]),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/dhcp-static-binding-configs/{binding-id}',
            request_body_parameter='dhcp_static_binding_config',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
                'binding_id': 'binding-id',
            },
             header_parameters={
                         },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpStaticBindingConfig')]),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpStaticBindingConfigListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpStaticBindingConfig')]),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.vpcs.subnets.dhcp_static_binding_configs',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _IpPoolsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'ip_pool_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/ip-pools/{ip-pool-id}',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
                'ip_pool_id': 'ip-pool-id',
            },
             header_parameters={
                       },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/ip-pools',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
            },
             header_parameters={
                                 },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IpAddressPool'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IpAddressPoolListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.vpcs.subnets.ip_pools',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _PortsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'port_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/ports/{port-id}',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
                'port_id': 'port-id',
            },
             header_parameters={
                       },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'port_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/ports/{port-id}',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
                'port_id': 'port-id',
            },
             header_parameters={
                       },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/ports',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
            },
             header_parameters={
                                 },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'port_id': type.StringType(),
            'vpc_subnet_port': type.ReferenceType('com.vmware.nsx_policy.model_client', 'VpcSubnetPort'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/ports/{port-id}',
            request_body_parameter='vpc_subnet_port',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
                'port_id': 'port-id',
            },
             header_parameters={
                         },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'port_id': type.StringType(),
            'vpc_subnet_port': type.ReferenceType('com.vmware.nsx_policy.model_client', 'VpcSubnetPort'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/ports/{port-id}',
            request_body_parameter='vpc_subnet_port',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
                'port_id': 'port-id',
            },
             header_parameters={
                         },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'VpcSubnetPort'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'VpcSubnetPortListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'VpcSubnetPort'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.vpcs.subnets.ports',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatisticsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'edge_path': type.OptionalType(type.StringType()),
            'enforcement_point_path': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'source': type.OptionalType(type.StringType()),
            'stats_type': type.OptionalType(type.StringType()),
            'transport_node_id': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/statistics',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
            },
             header_parameters={
                                           },
            query_parameters={
                'cursor': 'cursor',
                'edge_path': 'edge_path',
                'enforcement_point_path': 'enforcement_point_path',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'source': 'source',
                'stats_type': 'stats_type',
                'transport_node_id': 'transport_node_id',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'SubnetStatistics'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.vpcs.subnets.statistics',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatusStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'subnet_id': type.StringType(),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}/subnets/{subnet-id}/status',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
                'subnet_id': 'subnet-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'VpcSubnetStatusListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.vpcs.subnets.status',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'DhcpStaticBindingConfigs': DhcpStaticBindingConfigs,
        'IpPools': IpPools,
        'Ports': Ports,
        'Statistics': Statistics,
        'Status': Status,
        'dhcp_server_config': 'com.vmware.nsx_policy.orgs.projects.vpcs.subnets.dhcp_server_config_client.StubFactory',
        'gateway_interface_statistics': 'com.vmware.nsx_policy.orgs.projects.vpcs.subnets.gateway_interface_statistics_client.StubFactory',
        'ip_pools': 'com.vmware.nsx_policy.orgs.projects.vpcs.subnets.ip_pools_client.StubFactory',
        'ports': 'com.vmware.nsx_policy.orgs.projects.vpcs.subnets.ports_client.StubFactory',
    }

