/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.calendar.prefs;

import au.com.trgtd.tr.calendar.prefs.CalendarOptionsPanelController;
import au.com.trgtd.tr.calendar.prefs.CalendarPrefs;
import au.com.trgtd.tr.calendar.spi.CalendarSynchronizer;
import au.com.trgtd.tr.calendar.spi.CalendarSynchronizerOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class CalendarPrefsPanel
extends JPanel {
    private final CalendarOptionsPanelController controller;
    private final SynchronizerItem noneItem = new SynchronizerItem("", null);
    private final Lookup.Result<CalendarSynchronizer> lookup = Lookup.getDefault().lookupResult(CalendarSynchronizer.class);
    private JPanel emptyPanel;
    private JRadioButton delegatedAsEventRadio;
    private JRadioButton delegatedAsToDoRadio;
    private JCheckBox delegatedCheck;
    private JCheckBox delegatedNoDateCheck;
    private ButtonGroup delegatedTypeButtonGroup;
    private JRadioButton doasapDueAsEventRadio;
    private JRadioButton doasapDueAsToDoRadio;
    private JCheckBox doasapDueCheck;
    private ButtonGroup doasapDueTypeButtonGroup;
    private JCheckBox doasapNoDueCheck;
    private JRadioButton inactiveAsEventRadio;
    private JRadioButton inactiveAsToDoRadio;
    private JCheckBox inactiveCheck;
    private ButtonGroup inactiveTypeButtonGroup;
    private JCheckBox requiredCheck;
    private JCheckBox scheduledCheck;
    private JComboBox synchronizerCombo;
    private JLabel synchronizerLabel;
    private JPanel synchronizerPanel;
    private JScrollPane synchronizerScrollPane;

    CalendarPrefsPanel(CalendarOptionsPanelController controller) {
        this.controller = controller;
        this.initForm();
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(CalendarPrefsPanel.class, (String)key);
    }

    private void initForm() {
        this.initComponents();
        this.initFields();
        this.add((Component)this.getView(), "Center");
    }

    private void initFields() {
        this.doasapDueTypeButtonGroup = new ButtonGroup();
        this.delegatedTypeButtonGroup = new ButtonGroup();
        this.inactiveTypeButtonGroup = new ButtonGroup();
        this.emptyPanel = new JPanel();
        this.requiredCheck = new JCheckBox(this.getMsg("CTL_Required"));
        this.requiredCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CalendarPrefsPanel.this.RequiredCheckBoxActionPerformed(evt);
            }
        });
        this.inactiveCheck = new JCheckBox(this.getMsg("inactive.action.date.checkbox"));
        this.inactiveCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CalendarPrefsPanel.this.inactiveCheckBoxActionPerformed(evt);
            }
        });
        this.inactiveAsEventRadio = new JRadioButton(this.getMsg("as.events"));
        this.inactiveAsToDoRadio = new JRadioButton(this.getMsg("as.todos"));
        this.inactiveTypeButtonGroup.add(this.inactiveAsEventRadio);
        this.inactiveTypeButtonGroup.add(this.inactiveAsToDoRadio);
        this.doasapDueCheck = new JCheckBox(this.getMsg("doasap.due.date.checkbox"));
        this.doasapDueCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CalendarPrefsPanel.this.doasapDueCheckBoxActionPerformed(evt);
            }
        });
        this.doasapDueAsEventRadio = new JRadioButton(this.getMsg("as.events"));
        this.doasapDueAsToDoRadio = new JRadioButton(this.getMsg("as.todos"));
        this.doasapDueTypeButtonGroup.add(this.doasapDueAsEventRadio);
        this.doasapDueTypeButtonGroup.add(this.doasapDueAsToDoRadio);
        this.doasapNoDueCheck = new JCheckBox(this.getMsg("doasap.no.due.date.checkbox"));
        this.doasapNoDueCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CalendarPrefsPanel.this.doasapNoDueCheckBoxActionPerformed(evt);
            }
        });
        this.delegatedCheck = new JCheckBox(this.getMsg("delegated.checkbox"));
        this.delegatedCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CalendarPrefsPanel.this.delegatedCheckBoxActionPerformed(evt);
            }
        });
        this.delegatedAsEventRadio = new JRadioButton(this.getMsg("as.events"));
        this.delegatedAsToDoRadio = new JRadioButton(this.getMsg("as.todos"));
        this.delegatedTypeButtonGroup.add(this.delegatedAsEventRadio);
        this.delegatedTypeButtonGroup.add(this.delegatedAsToDoRadio);
        this.delegatedNoDateCheck = new JCheckBox(this.getMsg("delegated.no.date.checkbox"));
        this.delegatedNoDateCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CalendarPrefsPanel.this.delegatedNoDateCheckBoxActionPerformed(evt);
            }
        });
        this.scheduledCheck = new JCheckBox(this.getMsg("scheduled.checkbox"));
        this.scheduledCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CalendarPrefsPanel.this.scheduledCheckBoxActionPerformed(evt);
            }
        });
        this.synchronizerLabel = new JLabel(this.getMsg("CalendarPanel.importerLabel.text"));
        this.synchronizerCombo = new JComboBox();
        this.synchronizerCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CalendarPrefsPanel.this.synchronizerComboBoxActionPerformed(evt);
            }
        });
        this.synchronizerScrollPane = new JScrollPane();
        this.synchronizerPanel = new JPanel();
        this.synchronizerPanel.setLayout(new BorderLayout());
        this.synchronizerPanel.add((Component)this.synchronizerScrollPane, "Center");
    }

    private JComponent getView() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[]2[grow]0", "0[]2[]2[]2[]2[]2[]2[]4[]2[grow]0"));
        panel.add((Component)this.requiredCheck, "align left, span, wrap");
        panel.add((Component)this.inactiveCheck, "align left");
        panel.add((Component)this.inactiveAsEventRadio, "align left");
        panel.add((Component)this.inactiveAsToDoRadio, "align left, wrap");
        panel.add((Component)this.doasapDueCheck, "align left");
        panel.add((Component)this.doasapDueAsEventRadio, "align left");
        panel.add((Component)this.doasapDueAsToDoRadio, "align left, wrap");
        panel.add((Component)this.doasapNoDueCheck, "align left, spanx, wrap");
        panel.add((Component)this.delegatedCheck, "align left");
        panel.add((Component)this.delegatedAsEventRadio, "align left");
        panel.add((Component)this.delegatedAsToDoRadio, "align left, wrap");
        panel.add((Component)this.delegatedNoDateCheck, "align left, spanx, wrap");
        panel.add((Component)this.scheduledCheck, "align left, spanx, wrap");
        panel.add((Component)this.synchronizerLabel, "align left, spanx, split 2");
        panel.add((Component)this.synchronizerCombo, "align left, wrap");
        panel.add((Component)this.synchronizerPanel, "align left, spanx 100, growx 100, growy 100");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private void enableDisableFields() {
        boolean b = this.requiredCheck.isSelected();
        this.inactiveCheck.setEnabled(b);
        this.inactiveAsEventRadio.setEnabled(b && this.inactiveCheck.isSelected());
        this.inactiveAsToDoRadio.setEnabled(b && this.inactiveCheck.isSelected());
        this.doasapDueCheck.setEnabled(b);
        this.doasapDueAsEventRadio.setEnabled(b && this.doasapDueCheck.isSelected());
        this.doasapDueAsToDoRadio.setEnabled(b && this.doasapDueCheck.isSelected());
        this.doasapNoDueCheck.setEnabled(b);
        this.delegatedCheck.setEnabled(b);
        this.delegatedAsEventRadio.setEnabled(b && this.delegatedCheck.isSelected());
        this.delegatedAsToDoRadio.setEnabled(b && this.delegatedCheck.isSelected());
        this.delegatedNoDateCheck.setEnabled(b);
        this.scheduledCheck.setEnabled(b);
        this.synchronizerLabel.setEnabled(b);
        this.synchronizerCombo.setEnabled(b);
        if (this.getSelectedSynchronizer() != null) {
            this.getSelectedSynchronizer().getOptions().enable(b);
        }
    }

    private CalendarSynchronizer getSelectedSynchronizer() {
        SynchronizerItem synchronizerItem = (SynchronizerItem)this.synchronizerCombo.getSelectedItem();
        if (synchronizerItem == null) {
            return null;
        }
        return synchronizerItem.synchronizer;
    }

    void load() {
        this.requiredCheck.setSelected(CalendarPrefs.isICalendarRequired());
        this.inactiveCheck.setSelected(CalendarPrefs.isSyncInactive());
        if (CalendarPrefs.isInactiveAsTodo()) {
            this.inactiveAsToDoRadio.setSelected(true);
        } else {
            this.inactiveAsEventRadio.setSelected(true);
        }
        this.doasapDueCheck.setSelected(CalendarPrefs.isSyncDoasapDueDate());
        if (CalendarPrefs.isDoasapDueAsTodo()) {
            this.doasapDueAsToDoRadio.setSelected(true);
        } else {
            this.doasapDueAsEventRadio.setSelected(true);
        }
        this.doasapNoDueCheck.setSelected(CalendarPrefs.isSyncDoasapNoDueDate());
        this.delegatedCheck.setSelected(CalendarPrefs.isSyncDelegated());
        if (CalendarPrefs.isDelegatedAsTodo()) {
            this.delegatedAsToDoRadio.setSelected(true);
        } else {
            this.delegatedAsEventRadio.setSelected(true);
        }
        this.delegatedNoDateCheck.setSelected(CalendarPrefs.isSyncDelegatedNoDate());
        this.scheduledCheck.setSelected(CalendarPrefs.isSyncScheduled());
        SynchronizerItem selected = null;
        Vector<SynchronizerItem> synchronizers = new Vector<SynchronizerItem>();
        synchronizers.add(this.noneItem);
        for (CalendarSynchronizer synchronizer : this.lookup.allInstances()) {
            SynchronizerItem item = new SynchronizerItem(synchronizer.getID(), synchronizer);
            synchronizers.add(item);
            if (!synchronizer.getID().equals(CalendarPrefs.getSynchronizerID())) continue;
            selected = item;
        }
        this.synchronizerCombo.setModel(new DefaultComboBoxModel<Object>(synchronizers.toArray()));
        if (selected == null) {
            this.loadSynchronizerOptions(null);
        } else {
            this.synchronizerCombo.setSelectedItem(selected);
            this.loadSynchronizerOptions(selected.synchronizer);
        }
        this.enableDisableFields();
    }

    void loadSynchronizerOptions(CalendarSynchronizer synchronizer) {
        if (synchronizer == null) {
            this.synchronizerScrollPane.setViewportView(this.emptyPanel);
        } else {
            CalendarSynchronizerOptions syncOptions = synchronizer.getOptions();
            if (syncOptions == null) {
                this.synchronizerScrollPane.setViewportView(this.emptyPanel);
            } else {
                syncOptions.load();
                this.synchronizerScrollPane.setViewportView(syncOptions.getPanel());
            }
        }
        this.synchronizerPanel.revalidate();
        this.synchronizerPanel.repaint();
    }

    void store() {
        CalendarPrefs.setICalendarRequired(this.requiredCheck.isSelected());
        CalendarPrefs.setSyncInactive(this.inactiveCheck.isSelected());
        CalendarPrefs.setInactiveAsTodo(this.inactiveAsToDoRadio.isSelected());
        CalendarPrefs.setSyncDoASAPWithDueDate(this.doasapDueCheck.isSelected());
        CalendarPrefs.setDoasapDueAsTodo(this.doasapDueAsToDoRadio.isSelected());
        CalendarPrefs.setSyncDoASAPWithNoDueDate(this.doasapNoDueCheck.isSelected());
        CalendarPrefs.setSyncDelegated(this.delegatedCheck.isSelected());
        CalendarPrefs.setDelegatedAsTodo(this.delegatedAsToDoRadio.isSelected());
        CalendarPrefs.setSyncDelegatedNoDate(this.delegatedNoDateCheck.isSelected());
        CalendarPrefs.setSyncScheduled(this.scheduledCheck.isSelected());
        CalendarSynchronizer synchronizer = this.getSelectedSynchronizer();
        if (synchronizer == null) {
            CalendarPrefs.setSynchronizerID("");
        } else {
            CalendarPrefs.setSynchronizerID(synchronizer.getID());
            synchronizer.getOptions().store();
        }
    }

    boolean valid() {
        if (!this.requiredCheck.isSelected()) {
            return true;
        }
        CalendarSynchronizer synchronizer = this.getSelectedSynchronizer();
        if (synchronizer == null) {
            return false;
        }
        return synchronizer.getOptions().valid();
    }

    private void RequiredCheckBoxActionPerformed(ActionEvent evt) {
        this.enableDisableFields();
        this.controller.changed();
    }

    private void delegatedCheckBoxActionPerformed(ActionEvent evt) {
        this.controller.changed();
        this.delegatedAsEventRadio.setEnabled(this.delegatedCheck.isSelected());
        this.delegatedAsToDoRadio.setEnabled(this.delegatedCheck.isSelected());
    }

    private void doasapDueCheckBoxActionPerformed(ActionEvent evt) {
        this.controller.changed();
        this.doasapDueAsEventRadio.setEnabled(this.doasapDueCheck.isSelected());
        this.doasapDueAsToDoRadio.setEnabled(this.doasapDueCheck.isSelected());
    }

    private void doasapNoDueCheckBoxActionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    private void scheduledCheckBoxActionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    private void synchronizerComboBoxActionPerformed(ActionEvent evt) {
        SynchronizerItem synchronizerItem = (SynchronizerItem)this.synchronizerCombo.getSelectedItem();
        if (synchronizerItem == null || synchronizerItem.equals(this.noneItem)) {
            this.loadSynchronizerOptions(null);
        } else {
            this.loadSynchronizerOptions(synchronizerItem.synchronizer);
        }
    }

    private void delegatedNoDateCheckBoxActionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    private void inactiveCheckBoxActionPerformed(ActionEvent evt) {
        this.controller.changed();
        this.inactiveAsEventRadio.setEnabled(this.inactiveCheck.isSelected());
        this.inactiveAsToDoRadio.setEnabled(this.inactiveCheck.isSelected());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private final class SynchronizerItem {
        final String id;
        final CalendarSynchronizer synchronizer;

        SynchronizerItem(String id, CalendarSynchronizer synchronizer) {
            this.id = id;
            this.synchronizer = synchronizer;
        }

        public String toString() {
            return this.synchronizer == null ? "None" : this.synchronizer.getName();
        }

        public boolean equals(Object object) {
            if (object instanceof SynchronizerItem) {
                return this.id.equals(((SynchronizerItem)object).id);
            }
            return false;
        }
    }
}

